/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.extension.TestSuiteEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class TestSuiteForm
extends EditorForm {
    private int testCasePageIndex;
    private int testComponentPageIndex;
    private int sutPageIndex;
    private NamedElementSection namedElementSection;
    private NamedElementsSection testCasesSection;
    private NamedElementsSection testComponentsSection;
    private NamedElementsSection sutsSection;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public TestSuiteForm(TestSuiteEditorExtension testSuiteEditorExtension, WidgetFactory widgetFactory) {
        super(testSuiteEditorExtension, widgetFactory);
        this.setHeadingText(TestUIPlugin.getString("W_OVERVIEW"));
    }

    public void dispose() {
        this.namedElementSection.dispose();
        this.namedElementSection = null;
        this.testCasesSection.dispose();
        this.testCasesSection = null;
        this.testComponentsSection.dispose();
        this.testComponentsSection = null;
        this.sutsSection.dispose();
        this.sutsSection = null;
        super.dispose();
    }

    protected TPFTestSuite getTestSuite() {
        return ((TestSuiteEditorExtension)this.getBaseEditorExtension()).getTestSuite();
    }

    public void setTestCasePageIndex(int index) {
        this.testCasePageIndex = index;
    }

    public void setTestComponentPageIndex(int index) {
        this.testComponentPageIndex = index;
    }

    public void setSUTIndex(int index) {
        this.sutPageIndex = index;
    }

    public Control createControl() {
        Control control = super.createControl();
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)(TestUIPlugin.getID() + ".tstf0001"));
        return control;
    }

    protected void createEditorFormContents(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        parent.setLayout((Layout)gridLayout);
        Composite leftColumn = this.createColumn(parent);
        Composite rightColumn = this.createColumn(parent);
        Control control = this.createGenericInformation(leftColumn);
        control.setLayoutData((Object)new GridData(770));
        WorkbenchHelp.setHelp((Control)control, (String)(TestUIPlugin.getID() + ".tstf0004"));
        this.testCasesSection = new NamedElementsSection((IEditorExtension)this.getBaseEditorExtension(), this.testCasePageIndex);
        this.registerSection(this.testCasesSection);
        this.testCasesSection.createControl(leftColumn, this.factory, TestUIPlugin.getString("W_TST_CASES"), TestUIPlugin.getString("EDT_TST_CASE_DSC"));
        this.testComponentsSection = new NamedElementsSection((IEditorExtension)this.getBaseEditorExtension(), this.testComponentPageIndex);
        this.registerSection(this.testComponentsSection);
        this.testComponentsSection.createControl(rightColumn, this.factory, TestUIPlugin.getString("W_TST_COMPS"), TestUIPlugin.getString("EDT_TST_COMP_DSC"));
        this.sutsSection = new NamedElementsSection((IEditorExtension)this.getBaseEditorExtension(), this.sutPageIndex);
        this.registerSection(this.sutsSection);
        this.sutsSection.createControl(rightColumn, this.factory, TestUIPlugin.getString("W_SUTS"), TestUIPlugin.getString("EDT_SUTS_DSC"));
    }

    protected Control createGenericInformation(Composite parent) {
        this.namedElementSection = new NamedElementSection(this){
            private StyledText typeText;
            private StyledText fileText;

            protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory) {
                Composite detailComposite = TestSuiteForm.this.getWidgetFactory().createComposite(parent);
                GridLayout gridLayout = new GridLayout(2, false);
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
                detailComposite.setLayout((Layout)gridLayout);
                detailComposite.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                TestSuiteForm.this.getWidgetFactory().createLabel(detailComposite, TestUIPlugin.getString("L_TYPE"));
                this.typeText = TestSuiteForm.this.getWidgetFactory().createStyledText(detailComposite, 65540);
                this.typeText.setEnabled(false);
                this.typeText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                TestSuiteForm.this.getWidgetFactory().createLabel(detailComposite, TestUIPlugin.getString("L_FILE"));
                this.fileText = TestSuiteForm.this.getWidgetFactory().createStyledText(detailComposite, 65540);
                this.fileText.setEnabled(false);
                this.fileText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                WorkbenchHelp.setHelp((Control)this.typeText, (String)(TestUIPlugin.getID() + ".tstf0003"));
                WorkbenchHelp.setHelp((Control)this.fileText, (String)(TestUIPlugin.getID() + ".tstf0002"));
            }

            public void setInput(Object object) {
                IFile file;
                super.setInput(object);
                String value = TestSuiteForm.this.getTestSuite().getType();
                if (value != null) {
                    IAssociationDescriptor descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(value);
                    if (descriptor != null && descriptor.getName() != null) {
                        value = descriptor.getName();
                    }
                    this.typeText.setText(value);
                }
                if ((file = EMFUtil.getWorkspaceFile((EObject)TestSuiteForm.this.getTestSuite())) != null) {
                    this.fileText.setText(file.getFullPath().toString());
                }
            }
        };
        this.registerSection(this.namedElementSection);
        this.namedElementSection.setHeaderText(TestUIPlugin.getString("EDT_GENERAL_INFO"));
        this.namedElementSection.setDescription(TestUIPlugin.getString("EDT_GENERAL_DSC"));
        return this.namedElementSection.createControl(parent, this.getWidgetFactory());
    }

    public void load() {
        this.namedElementSection.setInput(this.getTestSuite());
        this.testCasesSection.initialize((EObject)this.getTestSuite(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases(), TestUIPlugin.getString("W_TST_CASES"));
        this.testComponentsSection.initialize((EObject)this.getTestSuite(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestComponents(), TestUIPlugin.getString("W_TST_COMPS"));
        this.sutsSection.initialize((EObject)this.getTestSuite(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_SUTs(), TestUIPlugin.getString("W_SUTS"));
    }

    public void updateTitle() {
        String title = ((IWorkbenchAdapter)this.getTestSuite().getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = TestSuiteForm.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)).getLabel((Object)this.getTestSuite());
        if (title != null) {
            this.getBaseEditorExtension().getHyadesEditorPart().setTitle(title);
        }
    }

    public boolean activated() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

