/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.util.Hashtable;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IBulletParagraph;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Locator;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Paragraph;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class BulletParagraph
extends Paragraph
implements IBulletParagraph {
    private int style = 0;
    private String text;
    private int CIRCLE_DIAM = 5;
    private int SPACING = 10;
    private int indent = -1;

    public BulletParagraph(boolean addVerticalSpace) {
        super(addVerticalSpace);
    }

    public int getIndent() {
        if (this.indent != -1) {
            return this.indent;
        }
        switch (this.style) {
            case 0: {
                return this.CIRCLE_DIAM + this.SPACING;
            }
        }
        return 20;
    }

    public int getBulletStyle() {
        return this.style;
    }

    public void setBulletStyle(int style) {
        this.style = style;
    }

    public void setBulletText(String text) {
        this.text = text;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public String getBulletText() {
        return this.text;
    }

    public void paint(GC gc, int width, Locator loc, int lineHeight, Hashtable objectTable, IHyperlinkSegment selectedLink) {
        this.paintBullet(gc, loc, lineHeight, objectTable);
        super.paint(gc, width, loc, lineHeight, objectTable, selectedLink);
    }

    public void paintBullet(GC gc, Locator loc, int lineHeight, Hashtable objectTable) {
        Image image;
        int x = loc.x - this.getIndent();
        if (this.style == 0) {
            int y = loc.y + lineHeight / 2 - this.CIRCLE_DIAM / 2;
            Color bg = gc.getBackground();
            Color fg = gc.getForeground();
            gc.setBackground(fg);
            gc.fillRectangle(x, y + 1, 5, 3);
            gc.fillRectangle(x + 1, y, 3, 5);
            gc.setBackground(bg);
        } else if (this.style == 1 && this.text != null) {
            gc.drawText(this.text, x, loc.y);
        } else if (this.style == 2 && this.text != null && (image = (Image)objectTable.get(this.text)) != null) {
            int y = loc.y + lineHeight / 2 - image.getBounds().height / 2;
            gc.drawImage(image, x, y);
        }
    }
}

