/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.DefaultDeploymentsProvider;
import org.eclipse.hyades.test.ui.internal.launch.extensions.DefaultExecutionHistoryDefaultsProvider;
import org.eclipse.hyades.test.ui.launch.extensions.IDeploymentsProvider;
import org.eclipse.hyades.test.ui.launch.extensions.IExecutionHistoryDefaultsProvider;
import org.eclipse.hyades.test.ui.launch.extensions.IExecutionHistoryDefaultsProvider2;
import org.eclipse.hyades.test.ui.launch.extensions.IExecutionResultsLocationFilter;
import org.eclipse.hyades.test.ui.launch.extensions.IRunHandler;
import org.eclipse.hyades.test.ui.launch.extensions.ITestLaunchConfigurationValidator;

public class LaunchConfigurationExtensionsManager {
    private static LaunchConfigurationExtensionsManager instance;
    private static final String KIND_TEST = "test";
    private static final String KIND_COMPONENT = "testComponent";
    private Map testExtensionMap = new HashMap();
    private Map componentExtensionMap = new HashMap();
    private Map launchConfigurationMap = new HashMap();
    private IDeploymentsProvider defaultDeploymentsProvider = new DefaultDeploymentsProvider();
    private IExecutionHistoryDefaultsProvider defaultExecutionHistoryDefaultsProvider = new DefaultExecutionHistoryDefaultsProvider();

    public static LaunchConfigurationExtensionsManager getInstance() {
        if (instance == null) {
            instance = new LaunchConfigurationExtensionsManager();
        }
        return instance;
    }

    private LaunchConfigurationExtensionsManager() {
        this.registerRunHandlers();
        this.registerDeploymentsProviders();
        this.registerExecutionHistoryDefaultsProviders();
        this.registerExecutionHistoryDefaults2Providers();
        this.registerSupportedTestTypes();
        this.registerLaunchConfigurationValidators();
        this.registerExecutionResultsLocationFilters();
    }

    private TestExtensionDescriptor getExtensionDescriptor(String type, String kind) {
        Assert.isNotNull((Object)kind);
        Assert.isNotNull((Object)type);
        Map map = null;
        if (kind.equals(KIND_TEST)) {
            map = this.testExtensionMap;
        } else if (kind.equals(KIND_COMPONENT)) {
            map = this.componentExtensionMap;
        } else {
            throw new IllegalArgumentException("Invalid kind");
        }
        Assert.isNotNull((Object)map);
        Object o = map.get(type);
        if (o == null) {
            o = new TestExtensionDescriptor();
            map.put(type, o);
        }
        return (TestExtensionDescriptor)o;
    }

    private TestExtensionDescriptor getTestExtensionDescriptor(Object testElement) {
        if (testElement != null) {
            TPFTestComponent testComponent;
            if (testElement instanceof TPFTest) {
                TPFTest test = (TPFTest)testElement;
                if (test.getType() != null) {
                    return this.getExtensionDescriptor(test.getType(), KIND_TEST);
                }
            } else if (testElement instanceof TPFTestComponent && (testComponent = (TPFTestComponent)testElement).getType() != null) {
                return this.getExtensionDescriptor(testComponent.getType(), KIND_COMPONENT);
            }
        }
        return null;
    }

    private LaunchConfigurationExtensionDescriptor getLaunchConfigurationExtensionDescriptor(String launchConfigurationType) {
        Assert.isNotNull((Object)launchConfigurationType);
        Object o = this.launchConfigurationMap.get(launchConfigurationType);
        if (o == null) {
            o = new LaunchConfigurationExtensionDescriptor();
            this.launchConfigurationMap.put(launchConfigurationType, o);
        }
        return (LaunchConfigurationExtensionDescriptor)o;
    }

    private void registerRunHandlers() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".runHandler");
        if (extPoint != null) {
            IConfigurationElement[] runHandlers = extPoint.getConfigurationElements();
            for (int i = 0; i < runHandlers.length; ++i) {
                IConfigurationElement[] supportedTypes = runHandlers[i].getChildren();
                for (int j = 0; j < supportedTypes.length; ++j) {
                    String type = supportedTypes[j].getAttribute("type");
                    String kind = supportedTypes[j].getAttribute("kind");
                    try {
                        TestExtensionDescriptor ed = this.getExtensionDescriptor(type, kind);
                        ed.runHandlerConfigElem = runHandlers[i];
                        continue;
                    }
                    catch (Exception e) {
                        TestUIPlugin.logError("Extension " + runHandlers[i].getName() + " was ignored. See next messages for details.");
                        TestUIPlugin.logError(e);
                    }
                }
            }
        }
    }

    private void registerExecutionHistoryDefaultsProviders() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".executionHistoryDefaults");
        if (extPoint != null) {
            IConfigurationElement[] defaultsProviders = extPoint.getConfigurationElements();
            for (int i = 0; i < defaultsProviders.length; ++i) {
                IConfigurationElement[] supportedStuff = defaultsProviders[i].getChildren();
                for (int j = 0; j < supportedStuff.length; ++j) {
                    String type = supportedStuff[j].getAttribute("type");
                    String kind = supportedStuff[j].getAttribute("kind");
                    try {
                        TestExtensionDescriptor ed = this.getExtensionDescriptor(type, kind);
                        ed.execHistoryDefaultsProviderConfigElem = defaultsProviders[i];
                        continue;
                    }
                    catch (Exception e) {
                        TestUIPlugin.logError("Extension " + defaultsProviders[i].getName() + " was ignored. See next messages for details.");
                        TestUIPlugin.logError(e);
                    }
                }
            }
        }
    }

    private void registerExecutionHistoryDefaults2Providers() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".executionHistoryDefaults2");
        if (extPoint != null) {
            IConfigurationElement[] defaultsProviders = extPoint.getConfigurationElements();
            for (int i = 0; i < defaultsProviders.length; ++i) {
                IConfigurationElement[] supportedStuff = defaultsProviders[i].getChildren();
                for (int j = 0; j < supportedStuff.length; ++j) {
                    String type = supportedStuff[j].getAttribute("type");
                    try {
                        LaunchConfigurationExtensionDescriptor ed = this.getLaunchConfigurationExtensionDescriptor(type);
                        ed.execHistoryDefaultsProviderConfigElem = defaultsProviders[i];
                        continue;
                    }
                    catch (Exception e) {
                        TestUIPlugin.logError("Extension " + defaultsProviders[i].getName() + " was ignored. See next messages for details.");
                        TestUIPlugin.logError(e);
                    }
                }
            }
        }
    }

    private void registerDeploymentsProviders() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".deploymentProvider");
        if (extPoint != null) {
            IConfigurationElement[] deploymentProviders = extPoint.getConfigurationElements();
            for (int i = 0; i < deploymentProviders.length; ++i) {
                IConfigurationElement[] supportedTypes = deploymentProviders[i].getChildren();
                for (int j = 0; j < supportedTypes.length; ++j) {
                    String type = supportedTypes[j].getAttribute("type");
                    String kind = supportedTypes[j].getAttribute("kind");
                    try {
                        TestExtensionDescriptor ed = this.getExtensionDescriptor(type, kind);
                        ed.deploymentsProviderConfigElem = deploymentProviders[i];
                        continue;
                    }
                    catch (Exception e) {
                        TestUIPlugin.logError("Extension " + deploymentProviders[i].getName() + " was ignored. See next messages for details.");
                        TestUIPlugin.logError(e);
                    }
                }
            }
        }
    }

    private void registerLaunchConfigurationValidators() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".launchConfigValidator");
        if (extPoint != null) {
            IConfigurationElement[] launchConfigurationValidators = extPoint.getConfigurationElements();
            for (int i = 0; i < launchConfigurationValidators.length; ++i) {
                IConfigurationElement[] supportedTypes = launchConfigurationValidators[i].getChildren();
                for (int j = 0; j < supportedTypes.length; ++j) {
                    String type = supportedTypes[j].getAttribute("type");
                    String kind = supportedTypes[j].getAttribute("kind");
                    try {
                        TestExtensionDescriptor ed = this.getExtensionDescriptor(type, kind);
                        ed.launchConfigurationValidatorConfigElem = launchConfigurationValidators[i];
                        continue;
                    }
                    catch (Exception e) {
                        TestUIPlugin.logError("Extension " + launchConfigurationValidators[i].getName() + " was ignored. See next messages for details.");
                        TestUIPlugin.logError(e);
                    }
                }
            }
        }
    }

    private void registerExecutionResultsLocationFilters() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".executionResultsLocationFilter");
        if (extPoint != null) {
            IConfigurationElement[] execResultsLocationFilters = extPoint.getConfigurationElements();
            for (int i = 0; i < execResultsLocationFilters.length; ++i) {
                IConfigurationElement[] supportedStuff = execResultsLocationFilters[i].getChildren();
                for (int j = 0; j < supportedStuff.length; ++j) {
                    String type = supportedStuff[j].getAttribute("type");
                    try {
                        LaunchConfigurationExtensionDescriptor ed = this.getLaunchConfigurationExtensionDescriptor(type);
                        ed.execResultsLocationFilterConfigElem = execResultsLocationFilters[i];
                        continue;
                    }
                    catch (Exception e) {
                        TestUIPlugin.logError("Extension " + execResultsLocationFilters[i].getName() + " was ignored. See next messages for details.");
                        TestUIPlugin.logError(e);
                    }
                }
            }
        }
    }

    private void registerSupportedTestTypes() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TestUIPlugin.getID() + ".launchableType");
        if (extPoint != null) {
            IConfigurationElement[] supportedTypes = extPoint.getConfigurationElements();
            for (int i = 0; i < supportedTypes.length; ++i) {
                String type = supportedTypes[i].getAttribute("type");
                String kind = supportedTypes[i].getAttribute("kind");
                String lcType = supportedTypes[i].getAttribute("launchConfigurationType");
                try {
                    TestExtensionDescriptor ed = this.getExtensionDescriptor(type, kind);
                    ed.launchConfigurationType = lcType;
                    IConfigurationElement[] supportedModes = supportedTypes[i].getChildren();
                    for (int j = 0; j < supportedModes.length; ++j) {
                        String mode = supportedModes[j].getAttribute("mode");
                        boolean shortcutAvailable = "true".equals(supportedModes[j].getAttribute("shortcutAvailable"));
                        ed.supportedLaunchModes.add(mode);
                        if (!shortcutAvailable) continue;
                        ed.availableShortcutModes.add(mode);
                    }
                    continue;
                }
                catch (Exception e) {
                    TestUIPlugin.logError("Extension " + supportedTypes[i].getName() + " was ignored. See next messages for details.");
                    TestUIPlugin.logError(e);
                }
            }
        }
    }

    public IRunHandler getRunHandler(Object testElement) {
        TestExtensionDescriptor ed = this.getTestExtensionDescriptor(testElement);
        if (ed != null) {
            return ed.getRunHandler();
        }
        return null;
    }

    public IExecutionHistoryDefaultsProvider getExecutionHistoryDefaultsProvider(Object testElement) {
        IExecutionHistoryDefaultsProvider result = null;
        TestExtensionDescriptor ed = this.getTestExtensionDescriptor(testElement);
        if (ed != null) {
            result = ed.getExecutionHistoryDefaultsProvider();
        }
        if (result == null) {
            result = this.defaultExecutionHistoryDefaultsProvider;
        }
        return result;
    }

    public IExecutionHistoryDefaultsProvider2 getExecutionHistoryDefaultsProvider2(String launchConfigurationType) {
        IExecutionHistoryDefaultsProvider2 result = null;
        LaunchConfigurationExtensionDescriptor ed = this.getLaunchConfigurationExtensionDescriptor(launchConfigurationType);
        if (ed != null) {
            result = ed.getExecutionHistoryDefaultsProvider();
        }
        return result;
    }

    public IExecutionResultsLocationFilter getExecutionResultsLocationFilter(String launchConfigurationType) {
        if (launchConfigurationType == null) {
            return null;
        }
        IExecutionResultsLocationFilter result = null;
        LaunchConfigurationExtensionDescriptor ed = this.getLaunchConfigurationExtensionDescriptor(launchConfigurationType);
        if (ed != null) {
            result = ed.getExecutionResultsLocationFilter();
        }
        return result;
    }

    public IDeploymentsProvider getDeploymentsProvider(Object testElement) {
        IDeploymentsProvider result = null;
        TestExtensionDescriptor ed = this.getTestExtensionDescriptor(testElement);
        if (ed != null) {
            result = ed.getDeploymentsProvider();
        }
        if (result == null) {
            result = this.defaultDeploymentsProvider;
        }
        return result;
    }

    public ITestLaunchConfigurationValidator getLaunchConfigurationValidator(Object testElement) {
        ITestLaunchConfigurationValidator result = null;
        TestExtensionDescriptor ed = this.getTestExtensionDescriptor(testElement);
        if (ed != null) {
            result = ed.getLaunchConfigurationValidator();
        }
        return result;
    }

    public boolean isLaunchableElement(Object testElement, String mode, String launchConfigurationType) {
        TestExtensionDescriptor ed = this.getTestExtensionDescriptor(testElement);
        if (ed != null) {
            return ed.isLaunchConfigurationTypeSupported(launchConfigurationType) && ed.supportedLaunchModes.contains(mode);
        }
        return false;
    }

    public boolean isShortcutAvailable(Object testElement, String mode) {
        TestExtensionDescriptor ed = this.getTestExtensionDescriptor(testElement);
        if (ed != null) {
            return ed.launchConfigurationType == null && ed.availableShortcutModes.contains(mode);
        }
        return false;
    }

    public IExecutionHistoryDefaultsProvider getDefaultExecutionHistoryDefaultsProvider() {
        return this.defaultExecutionHistoryDefaultsProvider;
    }

    public IDeploymentsProvider getDefaultDeploymentsProvider() {
        return this.defaultDeploymentsProvider;
    }

    private class LaunchConfigurationExtensionDescriptor {
        public IConfigurationElement execHistoryDefaultsProviderConfigElem = null;
        private IExecutionHistoryDefaultsProvider2 execHistoryDefaultsProvider = null;
        public IConfigurationElement execResultsLocationFilterConfigElem = null;
        public IExecutionResultsLocationFilter execResultsLocationFilter = null;

        private LaunchConfigurationExtensionDescriptor() {
        }

        public IExecutionHistoryDefaultsProvider2 getExecutionHistoryDefaultsProvider() {
            if (this.execHistoryDefaultsProvider == null && this.execHistoryDefaultsProviderConfigElem != null) {
                try {
                    this.execHistoryDefaultsProvider = (IExecutionHistoryDefaultsProvider2)this.execHistoryDefaultsProviderConfigElem.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                    this.execHistoryDefaultsProviderConfigElem = null;
                }
            }
            return this.execHistoryDefaultsProvider;
        }

        public IExecutionResultsLocationFilter getExecutionResultsLocationFilter() {
            if (this.execResultsLocationFilter == null && this.execResultsLocationFilterConfigElem != null) {
                try {
                    this.execResultsLocationFilter = (IExecutionResultsLocationFilter)this.execResultsLocationFilterConfigElem.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                    this.execResultsLocationFilterConfigElem = null;
                }
            }
            return this.execResultsLocationFilter;
        }
    }

    private class TestExtensionDescriptor {
        public IConfigurationElement runHandlerConfigElem = null;
        private IRunHandler runHandler = null;
        public List supportedLaunchModes = new ArrayList(3);
        public List availableShortcutModes = new ArrayList(3);
        public String launchConfigurationType = null;
        public IConfigurationElement execHistoryDefaultsProviderConfigElem = null;
        private IExecutionHistoryDefaultsProvider execHistoryDefaultsProvider = null;
        public IConfigurationElement deploymentsProviderConfigElem = null;
        private IDeploymentsProvider deploymentsProvider = null;
        public IConfigurationElement launchConfigurationValidatorConfigElem = null;
        private ITestLaunchConfigurationValidator launchConfigurationValidator = null;

        private TestExtensionDescriptor() {
        }

        public IRunHandler getRunHandler() {
            if (this.runHandler == null && this.runHandlerConfigElem != null) {
                try {
                    this.runHandler = (IRunHandler)this.runHandlerConfigElem.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                    this.runHandlerConfigElem = null;
                }
            }
            return this.runHandler;
        }

        public IExecutionHistoryDefaultsProvider getExecutionHistoryDefaultsProvider() {
            if (this.execHistoryDefaultsProvider == null && this.execHistoryDefaultsProviderConfigElem != null) {
                try {
                    this.execHistoryDefaultsProvider = (IExecutionHistoryDefaultsProvider)this.execHistoryDefaultsProviderConfigElem.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                    this.execHistoryDefaultsProviderConfigElem = null;
                }
            }
            return this.execHistoryDefaultsProvider;
        }

        public IDeploymentsProvider getDeploymentsProvider() {
            if (this.deploymentsProvider == null && this.deploymentsProviderConfigElem != null) {
                try {
                    this.deploymentsProvider = (IDeploymentsProvider)this.deploymentsProviderConfigElem.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                    this.deploymentsProviderConfigElem = null;
                }
            }
            return this.deploymentsProvider;
        }

        public ITestLaunchConfigurationValidator getLaunchConfigurationValidator() {
            if (this.launchConfigurationValidator == null && this.launchConfigurationValidatorConfigElem != null) {
                try {
                    this.launchConfigurationValidator = (ITestLaunchConfigurationValidator)this.launchConfigurationValidatorConfigElem.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    TestUIPlugin.logError(e);
                    this.launchConfigurationValidatorConfigElem = null;
                }
            }
            return this.launchConfigurationValidator;
        }

        public boolean isLaunchConfigurationTypeSupported(String lcType) {
            return this.launchConfigurationType == lcType || lcType != null && lcType.equals(this.launchConfigurationType);
        }
    }
}

