/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.execution.harness.TestExecutionHarness;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.help.WorkbenchHelp;

public abstract class ControlEventAction
extends Action
implements IDisposable {
    private IStructuredSelection structuredSelection;
    private String m_controlEvent = null;
    private String m_text = null;

    public ControlEventAction(String controlEvent, String text, String contextID) {
        super(TestUIPlugin.getString(text));
        WorkbenchHelp.setHelp((IAction)this, (String)(TestUIPlugin.getID() + contextID));
        this.m_controlEvent = controlEvent;
        this.m_text = text;
    }

    public void dispose() {
        this.structuredSelection = null;
    }

    protected IStructuredSelection getStructuredSelection() {
        return this.structuredSelection;
    }

    public void selectionChanged(IStructuredSelection structuredSelection) {
        this.structuredSelection = structuredSelection;
    }

    public void run() {
        Object object;
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection != null && !selection.isEmpty() && (object = selection.getFirstElement()) instanceof TPFExecutionResult) {
            TPFExecutionResult execResult = (TPFExecutionResult)object;
            TPFTest test = execResult.getTest();
            ITestSuite testSuite = null;
            if (test instanceof ITestSuite) {
                testSuite = (ITestSuite)test;
            } else if (test instanceof ITestCase) {
                testSuite = ((ITestCase)test).getOwner();
            }
            String port = TestUIPlugin.getInstance().getPreferenceStore().getString("localhost_port");
            TPFDeployment deployment = execResult.getDeployment();
            EList list = deployment.getLocations();
            boolean fError = true;
            String errors = new String();
            for (int i = 0; i < list.size(); ++i) {
                CFGLocation loc = (CFGLocation)list.get(i);
                String machineName = ((CFGMachineConstraint)loc).getHostname();
                String error = new TestExecutionHarness().performControlEvent(testSuite, (ITest)test, loc, port, execResult, this.m_controlEvent, null);
                if (error == null) {
                    fError = false;
                    continue;
                }
                errors = errors + error + "\r";
            }
            if (fError) {
                String errMsg = TestUIPlugin.getString("CONTROL_EVT_FAIL_TEXT");
                errMsg = StringUtil.replace((String)errMsg, (String)"%1", (String)TestUIPlugin.getString(this.m_text));
                errMsg = StringUtil.replace((String)errMsg, (String)"%2", (String)deployment.getName());
                Status err1 = new Status(2, "org.eclipse.core.resources", 566, errors, null);
                ErrorDialog.openError(null, (String)TestUIPlugin.getString("TEST_ERR_MSG"), (String)errMsg, (IStatus)err1);
            }
        }
        this.structuredSelection = null;
    }

    public boolean isApplicableForSelection() {
        if (this.structuredSelection == null || this.structuredSelection.size() != 1) {
            return false;
        }
        Object selection = this.structuredSelection.getFirstElement();
        return selection instanceof TPFExecutionResult;
    }

    public boolean isApplicableForEnablement() {
        if (this.structuredSelection == null || this.structuredSelection.size() != 1) {
            return false;
        }
        Object selection = this.structuredSelection.getFirstElement();
        boolean canBePerformed = false;
        if (selection instanceof TPFExecutionResult) {
            TPFTypedEvent execEvent;
            TPFExecutionType type;
            Object obj;
            TPFExecutionResult execResult = (TPFExecutionResult)selection;
            TPFExecutionHistory execHistory = execResult.getExecutionHistory();
            EList execEvents = execHistory.getExecutionEvents();
            if (execEvents.size() > 0 && (obj = execEvents.get(execEvents.size() - 1)) instanceof TPFTypedEvent && (type = (execEvent = (TPFTypedEvent)obj).getType()).getValue() == 1) {
                return false;
            }
            TPFTest test = execResult.getTest();
            ITestSuite testSuite = null;
            if (test instanceof ITestSuite) {
                testSuite = (ITestSuite)test;
            } else if (test instanceof ITestCase) {
                testSuite = ((ITestCase)test).getOwner();
            }
            String port = TestUIPlugin.getInstance().getPreferenceStore().getString("localhost_port");
            TPFDeployment deployment = execResult.getDeployment();
            EList list = deployment.getLocations();
            for (int i = 0; i < list.size(); ++i) {
                CFGLocation loc = (CFGLocation)list.get(0);
                String machineName = ((CFGMachineConstraint)loc).getHostname();
                canBePerformed = new TestExecutionHarness().canSupportControlEvent(testSuite, (ITest)test, loc, port, execResult, this.m_controlEvent);
                if (!canBePerformed) break;
            }
        }
        return canBePerformed;
    }
}

