/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness;

import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.harness.IExecutableObjectAdapter;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

public class JavaProcessExecutableObjectAdapter
implements IExecutableObjectAdapter {
    public void setupExecutableObject(IExecutableObject execObj, CFGClass rootResource, IImplementor theImplementor, TPFDeployment deployment) throws ClassCastException {
        String testID = theImplementor.getId();
        String testClass = theImplementor.getResource();
        boolean DEBUG = false;
        int nusers = 1;
        try {
            if (rootResource instanceof TPFTestSuite) {
                if (((TPFTestSuite)rootResource).getInstances().isEmpty()) {
                    CFGInstance instance = Common_ConfigurationFactory.eINSTANCE.createCFGInstance();
                    ((TPFTestSuite)rootResource).getInstances().add((Object)instance);
                }
                CFGInstance cfg = (CFGInstance)((TPFTestSuite)rootResource).getInstances().get(0);
                nusers = cfg.getMaxCount();
            }
        }
        catch (Exception e) {
            nusers = 1;
        }
        String jvmArgs = "";
        jvmArgs = jvmArgs + "-Dhyades.loadtest.nusers=" + nusers + " ";
        jvmArgs = jvmArgs + "org.eclipse.hyades.test.java.runner.HyadesJUnitRunner " + testClass + " ";
        jvmArgs = jvmArgs + testID + " " + nusers;
        if (!(rootResource instanceof ITestSuite)) {
            jvmArgs = jvmArgs + " " + theImplementor.getLocation();
        }
        ((JavaProcessExecutableObjectStub)execObj).setArgs(jvmArgs);
        ((JavaProcessExecutableObjectStub)execObj).setTestID(testID);
        ((JavaProcessExecutableObjectStub)execObj).setSuiteID(rootResource.getId());
    }
}

