/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.load;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class BackgroundLoader {
    private static BackgroundLoader instance;
    private Thread thread;
    private IProgressMonitor monitor = new CancelMonitor();
    private IRunnableWithProgress nextTask;

    public static synchronized BackgroundLoader getInstance() {
        if (instance == null) {
            instance = new BackgroundLoader();
        }
        return instance;
    }

    public synchronized void newTask(IRunnableWithProgress task) {
        this.nextTask = task;
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (BackgroundLoader.this.nextTask != null) {
                        try {
                            IRunnableWithProgress current;
                            BackgroundLoader backgroundLoader = BackgroundLoader.this;
                            synchronized (backgroundLoader) {
                                current = BackgroundLoader.this.nextTask;
                                BackgroundLoader.this.monitor.setCanceled(false);
                            }
                            current.run(BackgroundLoader.this.monitor);
                            backgroundLoader = BackgroundLoader.this;
                            synchronized (backgroundLoader) {
                                if (current == BackgroundLoader.this.nextTask) {
                                    BackgroundLoader.this.nextTask = null;
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        BackgroundLoader.this.monitor.setCanceled(false);
                    }
                }
            });
            this.thread.setName("Sequence diagram loader");
            this.thread.start();
        } else {
            this.monitor.setCanceled(true);
        }
    }

    public synchronized void cancelTask() {
        this.monitor.setCanceled(true);
        if (this.thread.isAlive()) {
            this.thread.destroy();
        }
    }

    public static void shutdown() {
        if (instance != null && BackgroundLoader.instance.monitor != null && !BackgroundLoader.instance.monitor.isCanceled()) {
            BackgroundLoader.instance.monitor.setCanceled(true);
        }
    }

    private BackgroundLoader() {
    }

    private static class CancelMonitor
    implements IProgressMonitor {
        private volatile boolean canceled = false;

        private CancelMonitor() {
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean canceled_) {
            this.canceled = canceled_;
        }

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
        }

        public void internalWorked(double work) {
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }
    }
}

