/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.presentation;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterType;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.LoggingAgentOutputterTypeType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.NotificationOutputterTypeType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.SingleFileOutputterTypeType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.StandardOutOutputterTypeType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.AdapterCBESensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SingleFileSensorType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.StaticParserSensorType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;

public class MigrationUtil {
    public static PropertyType getOrCreateProperty(ProcessUnitType object, String string) {
        PropertyType propertyType = MigrationUtil.getProperty(object.getProperty(), string);
        if (propertyType != null) {
            return propertyType;
        }
        propertyType = UnitFactory.eINSTANCE.createPropertyType();
        propertyType.setPropertyName(string);
        object.getProperty().add((Object)propertyType);
        return propertyType;
    }

    public static Object migrateLoad(AdapterType adapter) {
        if (adapter != null) {
            try {
                adapter.getConfiguration().getContextInstance();
                Iterator iter = adapter.getConfiguration().getContextInstance().iterator();
                while (iter.hasNext()) {
                    ContextInstanceType contextInstanceType = (ContextInstanceType)iter.next();
                    if (contextInstanceType == null) continue;
                    Iterator iterator = contextInstanceType.getOutputter().iterator();
                    while (iterator.hasNext()) {
                        OutputterConfigType outputterConfigType = (OutputterConfigType)iterator.next();
                        if (outputterConfigType.getSingleFileOutputterType() != null) {
                            MigrationUtil.migrateLoad(outputterConfigType.getSingleFileOutputterType());
                            continue;
                        }
                        if (outputterConfigType.getLoggingAgentOutputterType() != null) {
                            MigrationUtil.migrateLoad(outputterConfigType.getLoggingAgentOutputterType());
                            continue;
                        }
                        if (outputterConfigType.getNotificationOutputterType() == null) continue;
                        MigrationUtil.migrateLoad(outputterConfigType.getNotificationOutputterType());
                    }
                    if (contextInstanceType.getSensor() == null) continue;
                    SensorConfigType sensorConfigType = contextInstanceType.getSensor();
                    if (sensorConfigType.getSingleFileSensor() != null) {
                        MigrationUtil.migrateLoad(sensorConfigType.getSingleFileSensor());
                        continue;
                    }
                    if (sensorConfigType.getStaticParserSensor() == null) continue;
                    MigrationUtil.migrateLoad(sensorConfigType.getStaticParserSensor());
                }
            }
            catch (Exception e) {
                Status status = new Status(4, AcadEditorPlugin.getDefault().getPluginId(), 4, AcadEditorPlugin.getDefault().getString("MIGRATION_LOAD_ERROR"), (Throwable)e);
                AcadEditorPlugin.getDefault().logMessage((IStatus)status);
            }
        }
        return adapter;
    }

    public static Object migrateSave(AdapterType adapter) {
        if (adapter != null) {
            try {
                adapter.getConfiguration().getContextInstance();
                Iterator iter = adapter.getConfiguration().getContextInstance().iterator();
                while (iter.hasNext()) {
                    ContextInstanceType contextInstanceType = (ContextInstanceType)iter.next();
                    if (contextInstanceType == null) continue;
                    Iterator iterator = contextInstanceType.getOutputter().iterator();
                    while (iterator.hasNext()) {
                        OutputterConfigType outputterConfigType = (OutputterConfigType)iterator.next();
                        MigrationUtil.migrateSave(outputterConfigType);
                    }
                    if (contextInstanceType.getSensor() == null) continue;
                    SensorConfigType sensorConfigType = contextInstanceType.getSensor();
                    MigrationUtil.migrateSave(sensorConfigType);
                }
            }
            catch (Exception e) {
                Status status = new Status(4, AcadEditorPlugin.getDefault().getPluginId(), 4, AcadEditorPlugin.getDefault().getString("MIGRATION_SAVE_ERROR"), (Throwable)e);
                AcadEditorPlugin.getDefault().logMessage((IStatus)status);
            }
        }
        return adapter;
    }

    public static void migrateSave(SensorConfigType sensorConfigType) {
        if (sensorConfigType.getType() == SensorType.SINGLE_FILE_SENSOR_LITERAL) {
            SingleFileSensorType type = sensorConfigType.getSingleFileSensor();
            if (type == null) {
                type = SensorFactory.eINSTANCE.createSingleFileSensorType();
                sensorConfigType.setSingleFileSensor(type);
            }
            sensorConfigType.setAdapterCBESensor(null);
            sensorConfigType.setStaticParserSensor(null);
            type.setDirectory(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getSingleFileSensorType_Directory()));
            type.setFileName(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getSingleFileSensorType_FileName()));
            type.setConverter(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getSingleFileSensorType_Converter()));
            type.setShell(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getSingleFileSensorType_Shell()));
        } else if (sensorConfigType.getType() == SensorType.STATIC_PARSER_SENSOR_LITERAL) {
            StaticParserSensorType type = sensorConfigType.getStaticParserSensor();
            if (type == null) {
                type = SensorFactory.eINSTANCE.createStaticParserSensorType();
                sensorConfigType.setStaticParserSensor(type);
            }
            sensorConfigType.setAdapterCBESensor(null);
            sensorConfigType.setSingleFileSensor(null);
            type.setDirectory(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getStaticParserSensorType_Directory()));
            type.setFileName(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getStaticParserSensorType_FileName()));
            type.setParserClassName(MigrationUtil.getPropertyValue(sensorConfigType.getProperty(), SensorPackage.eINSTANCE.getStaticParserSensorType_ParserClassName()));
        } else if (sensorConfigType.getType() == SensorType.ADAPTER_CBE_SENSOR_LITERAL) {
            AdapterCBESensorType type = sensorConfigType.getAdapterCBESensor();
            if (type == null) {
                type = SensorFactory.eINSTANCE.createAdapterCBESensorType();
                sensorConfigType.setAdapterCBESensor(type);
            }
            sensorConfigType.setStaticParserSensor(null);
            sensorConfigType.setSingleFileSensor(null);
        } else {
            sensorConfigType.setStaticParserSensor(null);
            sensorConfigType.setSingleFileSensor(null);
            sensorConfigType.setAdapterCBESensor(null);
        }
    }

    public static PropertyType getProperty(EList list, String attribute) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            PropertyType element = (PropertyType)iter.next();
            if (element.getPropertyName() == null || !element.getPropertyName().equals(attribute)) continue;
            return element;
        }
        return null;
    }

    public static String getPropertyValue(EList list, EAttribute attribute) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            PropertyType element = (PropertyType)iter.next();
            if (element.getPropertyName() == null || !element.getPropertyName().equals(attribute.getName())) continue;
            return element.getPropertyValue();
        }
        return null;
    }

    public static void migrateSave(OutputterConfigType outputterConfigType) {
        if (outputterConfigType.getType() == OutputterType.SINGLE_FILE_OUTPUTTER_LITERAL) {
            SingleFileOutputterTypeType type = outputterConfigType.getSingleFileOutputterType();
            if (type == null) {
                type = OutputterFactory.eINSTANCE.createSingleFileOutputterTypeType();
                outputterConfigType.setSingleFileOutputterType(type);
            }
            outputterConfigType.setLoggingAgentOutputterType(null);
            outputterConfigType.setNotificationOutputterType(null);
            outputterConfigType.setStandardOutOutputterType(null);
            type.setDirectory(MigrationUtil.getPropertyValue(outputterConfigType.getProperty(), OutputterPackage.eINSTANCE.getSingleFileOutputterTypeType_Directory()));
            type.setFileName(MigrationUtil.getPropertyValue(outputterConfigType.getProperty(), OutputterPackage.eINSTANCE.getSingleFileOutputterTypeType_FileName()));
        } else if (outputterConfigType.getType() == OutputterType.LOGGING_AGENT_OUTPUTTER_LITERAL) {
            LoggingAgentOutputterTypeType type = outputterConfigType.getLoggingAgentOutputterType();
            if (type == null) {
                type = OutputterFactory.eINSTANCE.createLoggingAgentOutputterTypeType();
                outputterConfigType.setLoggingAgentOutputterType(type);
            }
            outputterConfigType.setSingleFileOutputterType(null);
            outputterConfigType.setNotificationOutputterType(null);
            outputterConfigType.setStandardOutOutputterType(null);
            type.setAgentName(MigrationUtil.getPropertyValue(outputterConfigType.getProperty(), OutputterPackage.eINSTANCE.getLoggingAgentOutputterTypeType_AgentName()));
            type.setWaitUntilLoggingTime(MigrationUtil.getPropertyValue(outputterConfigType.getProperty(), OutputterPackage.eINSTANCE.getLoggingAgentOutputterTypeType_WaitUntilLoggingTime()));
        } else if (outputterConfigType.getType() == OutputterType.NOTIFICATION_OUTPUTTER_LITERAL) {
            NotificationOutputterTypeType type = outputterConfigType.getNotificationOutputterType();
            if (type == null) {
                type = OutputterFactory.eINSTANCE.createNotificationOutputterTypeType();
                outputterConfigType.setNotificationOutputterType(type);
            }
            outputterConfigType.setSingleFileOutputterType(null);
            outputterConfigType.setLoggingAgentOutputterType(null);
            outputterConfigType.setStandardOutOutputterType(null);
            type.setResourceURL(MigrationUtil.getPropertyValue(outputterConfigType.getProperty(), OutputterPackage.eINSTANCE.getNotificationOutputterTypeType_ResourceURL()));
        } else if (outputterConfigType.getType() == OutputterType.SINGLE_FILE_OUTPUTTER_LITERAL) {
            StandardOutOutputterTypeType type = outputterConfigType.getStandardOutOutputterType();
            if (type == null) {
                type = OutputterFactory.eINSTANCE.createStandardOutOutputterTypeType();
                outputterConfigType.setStandardOutOutputterType(type);
            }
            outputterConfigType.setNotificationOutputterType(null);
            outputterConfigType.setSingleFileOutputterType(null);
            outputterConfigType.setLoggingAgentOutputterType(null);
        } else {
            outputterConfigType.setNotificationOutputterType(null);
            outputterConfigType.setSingleFileOutputterType(null);
            outputterConfigType.setLoggingAgentOutputterType(null);
            outputterConfigType.setStandardOutOutputterType(null);
        }
    }

    public static void migrateLoad(LoggingAgentOutputterTypeType type) {
        MigrationUtil.addOrSetProperty(type.eContainer(), OutputterPackage.eINSTANCE.getLoggingAgentOutputterTypeType_AgentName(), type.getAgentName());
        MigrationUtil.addOrSetProperty(type.eContainer(), OutputterPackage.eINSTANCE.getLoggingAgentOutputterTypeType_WaitUntilLoggingTime(), type.getWaitUntilLoggingTime());
    }

    public static void migrateLoad(NotificationOutputterTypeType type) {
        MigrationUtil.addOrSetProperty(type.eContainer(), OutputterPackage.eINSTANCE.getNotificationOutputterTypeType_ResourceURL(), type.getResourceURL());
    }

    public static void addOrSetProperty(EObject object, EAttribute attribute, String value) {
        MigrationUtil.addOrSetProperty(object, attribute.getName(), value);
    }

    public static void migrateLoad(SingleFileOutputterTypeType type) {
        MigrationUtil.addOrSetProperty(type.eContainer(), OutputterPackage.eINSTANCE.getSingleFileOutputterTypeType_Directory(), type.getDirectory());
        MigrationUtil.addOrSetProperty(type.eContainer(), OutputterPackage.eINSTANCE.getSingleFileOutputterTypeType_FileName(), type.getFileName());
    }

    public static void addOrSetProperty(EObject type, String name, String value) {
        if (value == null) {
            return;
        }
        PropertyType propertyType = MigrationUtil.getOrCreateProperty((ProcessUnitType)type, name);
        propertyType.setPropertyValue(value);
    }

    public static void migrateLoad(SingleFileSensorType type) {
        MigrationUtil.addOrSetProperty(type.eContainer(), SensorPackage.eINSTANCE.getSingleFileSensorType_Directory(), type.getDirectory());
        MigrationUtil.addOrSetProperty(type.eContainer(), SensorPackage.eINSTANCE.getSingleFileSensorType_FileName(), type.getFileName());
        MigrationUtil.addOrSetProperty(type.eContainer(), SensorPackage.eINSTANCE.getSingleFileSensorType_Converter(), type.getConverter());
        MigrationUtil.addOrSetProperty(type.eContainer(), SensorPackage.eINSTANCE.getSingleFileSensorType_Shell(), type.getShell());
    }

    public static void migrateLoad(StaticParserSensorType type) {
        MigrationUtil.addOrSetProperty(type.eContainer(), SensorPackage.eINSTANCE.getStaticParserSensorType_Directory(), type.getDirectory());
        MigrationUtil.addOrSetProperty(type.eContainer(), SensorPackage.eINSTANCE.getStaticParserSensorType_FileName(), type.getFileName());
        MigrationUtil.addOrSetProperty(type.eContainer(), SensorPackage.eINSTANCE.getStaticParserSensorType_ParserClassName(), type.getParserClassName());
        Iterator iter = type.getSensorProperty().iterator();
        while (iter.hasNext()) {
            SensorPropertyType element = (SensorPropertyType)iter.next();
            MigrationUtil.addOrSetProperty(type.eContainer(), element.getPropertyName(), element.getPropertyValue());
        }
    }
}

