/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.internal.sdb.impl;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.util.IUnresolvedResourceHelper;

public class SDBResourceSetImpl
extends ResourceSetImpl {
    private static SDBResourceSetImpl instance;
    private IUnresolvedResourceHelper helper;

    public static SDBResourceSetImpl getInstance() {
        if (instance == null) {
            instance = new SDBResourceSetImpl();
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcdbxmi", new SDBResourceFactoryImpl());
        }
        return instance;
    }

    public EObject getObjectAndLoad(URI uri) throws WrappedException {
        EObject obj = null;
        try {
            obj = super.getEObject(uri, true);
        }
        catch (WrappedException e) {
            if (this.helper != null) {
                this.helper.uriException(uri, (Exception)((Object)e));
            }
            throw e;
        }
        return obj;
    }

    public IUnresolvedResourceHelper getUnresolvedException() {
        return this.helper;
    }

    public void setUnresolvedResourceHelper(IUnresolvedResourceHelper helper) {
        this.helper = helper;
    }

    public Resource makeResource(String uriPath, EList extent) {
        return this.makeResource((IPath)new Path(uriPath), extent);
    }

    public Resource makeResource(IPath uriPath, EList extent) {
        return null;
    }

    protected static SDBResourceSetImpl getInstanceGen() {
        if (instance == null) {
            instance = new SDBResourceSetImpl();
            instance.setURIConverter((URIConverter)new URIConverterImpl());
        }
        return instance;
    }

    protected EObject getObjectAndLoadGen(URI uri) throws WrappedException {
        EObject obj = null;
        try {
            obj = super.getEObject(uri, true);
        }
        catch (WrappedException e) {
            if (this.helper != null) {
                this.helper.uriException(uri, (Exception)((Object)e));
            }
            throw e;
        }
        return obj;
    }

    protected IProject getProjectFromURI(IPath uriPath) {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember(uriPath.removeLastSegments(1));
        if (container != null) {
            return container.getProject();
        }
        return null;
    }

    protected IUnresolvedResourceHelper getUnresolvedExceptionGen() {
        return this.helper;
    }

    protected void setUnresolvedResourceHelperGen(IUnresolvedResourceHelper helper) {
        this.helper = helper;
    }
}

