/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.security.util;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import org.eclipse.hyades.execution.security.KeystoreHelper;
import org.eclipse.hyades.security.SecurityPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SecurityUI
implements Listener {
    private Shell fShell;
    private Text txtPath;
    private Text txtName;
    private String fAlias;
    private String fType;
    private String fPath;
    private ArrayList listenerList;
    private Button btnBrowse;

    public SecurityUI(Shell shell) {
        this.fShell = shell;
        this.listenerList = new ArrayList();
    }

    public void createContents(Composite c) {
        Composite nameGroup = new Composite(c, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        GridData data = GridUtil.createFill();
        data.widthHint = 400;
        nameGroup.setLayoutData((Object)data);
        nameGroup.setLayout((Layout)layout);
        Label lblPath = new Label(nameGroup, 0);
        lblPath.setText(SecurityPlugin.getResourceString("STR_CERTIFICATE_FILE"));
        this.txtPath = new Text(nameGroup, 2048);
        this.txtPath.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.txtPath.setText("");
        this.btnBrowse = new Button(nameGroup, 8);
        this.btnBrowse.setText(SecurityPlugin.getResourceString("STR_BROWSE"));
        this.btnBrowse.addListener(13, (Listener)this);
        Label lblName = new Label(nameGroup, 0);
        lblName.setText(SecurityPlugin.getResourceString("STR_CERTIFICATE_ALIAS"));
        this.txtName = new Text(nameGroup, 2048);
        this.txtName.setText("");
        this.txtName.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.txtName.addListener(24, (Listener)this);
        this.txtPath.addListener(24, (Listener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.btnBrowse) {
            this.showFileDialog();
            this.NotifyListeners(event);
        }
        if (event.widget == this.txtName || event.widget == this.txtPath) {
            this.fPath = this.txtPath.getText();
            this.fAlias = this.txtName.getText();
            this.NotifyListeners(event);
        }
    }

    public void NotifyListeners(Event event) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ((Listener)this.listenerList.get(i)).handleEvent(event);
        }
    }

    public boolean validateDialog() {
        return this.txtName.getText().trim().length() > 0 && this.txtPath.getText().trim().length() > 0;
    }

    private void setButtonState() {
        this.fShell.getDefaultButton().setEnabled(this.validateDialog());
    }

    private void showFileDialog() {
        String currentSource = this.txtPath.getText();
        FileDialog dlg = new FileDialog(this.fShell, 4096);
        dlg.setFileName(currentSource);
        dlg.setFilterExtensions(new String[]{"*.cer", "*.*"});
        String source = dlg.open();
        if (source != null) {
            this.txtPath.setText(source);
        }
    }

    public Certificate loadCertificate(KeyStore ks) throws IOException, CertificateException, KeyStoreException {
        Certificate fCertificate = KeystoreHelper.loadCertificate((String)this.getPath());
        KeystoreHelper.addCertificateToKeyStore((KeyStore)ks, (Certificate)fCertificate, (String)this.getAliasName());
        return fCertificate;
    }

    public void registerListener(Listener listener) {
        this.listenerList.add(listener);
    }

    public String getAliasName() {
        return this.fAlias;
    }

    public String getPath() {
        return this.fPath;
    }
}

