/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFTestObjective;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TestObjectiveSection
extends FormSection
implements ModifyListener {
    protected WidgetFactory widgetFactory;
    protected BaseEditorExtension baseEditorExtension;
    protected String testObjectiveReference;
    protected StyledText testObjectiveDescription;
    protected TPFTestSuite testSuite;
    private String[] types = new String[]{TestUIPlugin.getString("L_STRING_TYPE"), TestUIPlugin.getString("L_FILE_TYPE")};
    protected Composite typeComposite;
    protected CCombo type;

    public TestObjectiveSection(BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory) {
        this.setWidgetFactory(widgetFactory);
        this.setBaseEditorExtension(baseEditorExtension);
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite detailComposite = this.getWidgetFactory().createComposite(parent);
        detailComposite.setLayout((Layout)new GridLayout(3, false));
        parent.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.getWidgetFactory().createLabel(detailComposite, TestUIPlugin.getString("L_TYPE"));
        this.type = this.getWidgetFactory().createCCombo(detailComposite, 4);
        this.type.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        for (int i = 0; i < this.types.length; ++i) {
            this.type.add(this.types[i]);
        }
        this.type.setEditable(false);
        this.typeComposite = this.getWidgetFactory().createComposite(detailComposite);
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 3;
        gd2.heightHint = 100;
        gd2.grabExcessHorizontalSpace = true;
        this.typeComposite.setLayoutData((Object)gd2);
        this.type.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Control[] children = TestObjectiveSection.this.typeComposite.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    children[i].dispose();
                }
                TestObjectiveSection.this.createObjectiveControl(TestObjectiveSection.this.typeComposite, TestObjectiveSection.this.type.getSelectionIndex(), "");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.getWidgetFactory().paintBordersFor(detailComposite);
        return detailComposite;
    }

    protected void createObjectiveControl(Composite typeComposite, int typeIndex, String testObjectiveReference) {
        this.setTestObjectiveReference(testObjectiveReference);
        Control[] children = typeComposite.getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].dispose();
        }
        switch (typeIndex) {
            case 0: {
                this.createStringObjective(typeComposite);
                break;
            }
            case 1: {
                this.createFileObjective(typeComposite);
            }
        }
        if (this.testObjectiveDescription != null) {
            this.testObjectiveDescription.addModifyListener((ModifyListener)this);
        }
    }

    protected void createStringObjective(Composite typeComposite) {
        typeComposite.setLayout((Layout)new GridLayout());
        this.testObjectiveDescription = this.getWidgetFactory().createStyledText(typeComposite, 66114);
        GridData gridData = GridDataUtil.createHorizontalFill();
        gridData.heightHint = 4 * this.testObjectiveDescription.getLineHeight();
        this.testObjectiveDescription.setLayoutData((Object)gridData);
        this.testObjectiveDescription.setEditable(true);
        this.testObjectiveDescription.setText(this.getTestObjectiveReference());
        typeComposite.redraw();
        typeComposite.layout();
        this.getWidgetFactory().paintBordersFor(typeComposite);
    }

    protected void createFileObjective(Composite typeComposite) {
        typeComposite.setLayout((Layout)new GridLayout());
        this.testObjectiveDescription = this.getWidgetFactory().createStyledText(typeComposite, 65540);
        this.testObjectiveDescription.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.testObjectiveDescription.setEditable(true);
        this.testObjectiveDescription.setText(this.getTestObjectiveReference());
        Button btn = this.getWidgetFactory().createButton(typeComposite, TestUIPlugin.getString("BROWSE"), 8);
        btn.setLayoutData((Object)new GridData(128));
        btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(new Shell());
                fd.open();
                Path path = new Path(fd.getFilterPath());
                TestObjectiveSection.this.testObjectiveDescription.setText(path.addTrailingSeparator().toOSString() + fd.getFileName());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        typeComposite.redraw();
        typeComposite.layout();
        this.getWidgetFactory().paintBordersFor(typeComposite);
    }

    public void setInput(Object object) {
        if (this.testObjectiveDescription != null) {
            this.testObjectiveDescription.removeModifyListener((ModifyListener)this);
        }
        if (object instanceof TPFTestSuite) {
            TPFTestObjective testObjective;
            this.setTestSuite((TPFTestSuite)object);
            EList testObjectives = this.getTestSuite().getTestObjectives();
            if (testObjectives != null && testObjectives.size() > 0 && testObjectives.get(0) instanceof TPFTestObjective && (testObjective = (TPFTestObjective)testObjectives.get(0)) != null) {
                int index = this.getIndexFromType(testObjective.getType());
                String objective = testObjective.getReference();
                if (index > -1 && objective != null) {
                    this.setTestObjectiveReference(objective);
                    this.createObjectiveControl(this.typeComposite, index, this.getTestObjectiveReference());
                    this.type.select(index);
                }
            }
        }
        if (this.testObjectiveDescription != null) {
            this.testObjectiveDescription.addModifyListener((ModifyListener)this);
        }
    }

    protected int getIndexFromType(String type) {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].equals(type)) continue;
            return i;
        }
        return -1;
    }

    protected WidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    private void setWidgetFactory(WidgetFactory widgetFactory) {
        this.widgetFactory = widgetFactory;
    }

    public BaseEditorExtension getBaseEditorExtension() {
        return this.baseEditorExtension;
    }

    private void setBaseEditorExtension(BaseEditorExtension baseEditorExtension) {
        this.baseEditorExtension = baseEditorExtension;
    }

    public String getTestObjectiveReference() {
        return this.testObjectiveReference;
    }

    public void setTestObjectiveReference(String testObjectiveReference) {
        this.testObjectiveReference = testObjectiveReference;
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.testObjectiveDescription) {
            EList testObjectives = this.getTestSuite().getTestObjectives();
            TPFTestObjective testObjective = null;
            if (testObjectives != null && testObjectives.size() == 1 && testObjectives.get(0) instanceof TPFTestObjective) {
                testObjective = (TPFTestObjective)testObjectives.get(0);
            }
            if (testObjective != null) {
                testObjective.setType(this.type.getText());
                testObjective.setReference(this.testObjectiveDescription.getText());
            } else {
                testObjective = Common_TestprofileFactory.eINSTANCE.createTPFTestObjective();
                testObjective.setType(this.type.getText());
                testObjective.setReference(this.testObjectiveDescription.getText());
                this.getTestSuite().getTestObjectives().add((Object)testObjective);
            }
            this.getBaseEditorExtension().markDirty();
        }
    }

    public TPFTestSuite getTestSuite() {
        return this.testSuite;
    }

    public void setTestSuite(TPFTestSuite testSuite) {
        this.testSuite = testSuite;
    }
}

