/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.reports.responsetime;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.reports.HTTPReportGenerator;
import org.eclipse.hyades.test.http.internal.reports.ReportGraph;
import org.eclipse.hyades.test.http.internal.reports.ReportGraphConfiguration;
import org.eclipse.hyades.test.http.internal.reports.responsetime.ResponseTimeData;
import org.eclipse.hyades.test.http.internal.reports.responsetime.ResponseTimeReport;
import org.eclipse.jface.viewers.ISelection;

public class ResponseTimeReportGenerator
extends HTTPReportGenerator {
    public InputStream generate(IFile iFile, ISelection iSelection) throws Exception {
        this.initResultSelection();
        if (this.result == null) {
            throw new Exception(TestHttpPlugin.getString("ResponseTimeReportGenerator.PROBLEM"));
        }
        ResponseTimeReport responseTimeReport = new ResponseTimeReport(this.result);
        ResponseTimeData.resetCumulativeValues();
        responseTimeReport.generate();
        ReportGraphConfiguration reportGraphConfiguration = this.setupConfiguration();
        ReportGraph reportGraph = new ReportGraph(responseTimeReport.getList(), reportGraphConfiguration);
        IPath iPath = iFile.getFullPath();
        iPath.removeFileExtension().addFileExtension("svg");
        return reportGraph.generate(iPath);
    }

    private ReportGraphConfiguration setupConfiguration() {
        ReportGraphConfiguration reportGraphConfiguration = new ReportGraphConfiguration();
        reportGraphConfiguration.setTitle(TestHttpPlugin.getString("ResponseTimeReportGenerator.RESPONSE_TIME"));
        reportGraphConfiguration.setXTitle(TestHttpPlugin.getString("ResponseTimeReportGenerator.PAGE"));
        reportGraphConfiguration.setYTitle(TestHttpPlugin.getString("ResponseTimeReportGenerator.TIME_S"));
        reportGraphConfiguration.setLegendTitle(TestHttpPlugin.getString("ResponseTimeReportGenerator.LEGEND"));
        reportGraphConfiguration.setTimeStampPrefix("");
        reportGraphConfiguration.setMinWidth(800);
        reportGraphConfiguration.setHeight(500);
        return reportGraphConfiguration;
    }
}

