/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.models.common.facades.behavioral.IMethod;
import org.eclipse.hyades.models.common.facades.behavioral.IProperty;
import org.eclipse.hyades.models.common.facades.behavioral.ITargetInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.http.runner.HttpHeader;
import org.eclipse.hyades.test.http.runner.HttpRequest;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.hyades.ui.util.IDisposable;

public class RequestHelper
implements IDisposable {
    public static final int ATT_HOST = 1;
    public static final int ATT_PORT = 2;
    public static final int ATT_ABS_PATH = 3;
    public static final int ATT_BODY = 4;
    public static final int ATT_METHOD = 5;
    public static final int ATT_VERSION = 6;
    public static final int ATT_THINK_TIME = 7;
    public static final int ATT_PAGE_NUM = 8;
    public static final int ATT_PAGE_ORDER = 9;
    public static final int ATT_CONN_ID = 10;
    public static final int ATT_CONN_ORDER = 11;
    public static final int ATT_IS_SSL = 12;
    private static final String PROPERTY_DESC_ATT = "DESC_ATT";
    private static final String PROPERTY_DESC_HEADER = "DESC_HEADER";
    private ITestCase testCase;
    private ITargetInvocation targetInvocation;
    private boolean testCaseModified = false;

    public void dispose() {
        this.testCase = null;
        this.targetInvocation = null;
        this.testCaseModified = false;
    }

    public void setTestCase(ITestCase iTestCase) {
        this.dispose();
        if ("org.eclipse.hyades.test.http.junit.testCase".equals(iTestCase.getType())) {
            this.testCase = iTestCase;
        }
    }

    public boolean isDirty() {
        return this.testCaseModified;
    }

    public void clearDirty() {
        this.testCaseModified = false;
    }

    public ITestCase getTestCase() {
        return this.testCase;
    }

    public ITargetInvocation getTargetInvocation() {
        if (this.targetInvocation != null) {
            return this.targetInvocation;
        }
        if (this.testCase != null && this.testCase.getImplementor() != null && this.testCase.getImplementor().getBlock() != null) {
            Iterator iterator = this.testCase.getImplementor().getBlock().getActions().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof ITargetInvocation)) continue;
                this.targetInvocation = (ITargetInvocation)e;
                break;
            }
        }
        return this.targetInvocation;
    }

    public ITargetInvocation createTargetInvocation() {
        if (this.testCase == null) {
            return null;
        }
        if (this.testCase.getImplementor() == null) {
            HyadesFactory.INSTANCE.createImplementor((ITest)this.testCase, false);
        }
        this.targetInvocation = HyadesFactory.INSTANCE.createTargetInvocation(null);
        this.testCase.getImplementor().getBlock().getActions().add(this.targetInvocation);
        this.testCaseModified = true;
        return this.targetInvocation;
    }

    public IMethod getMethod() {
        ITargetInvocation iTargetInvocation = this.getTargetInvocation();
        if (iTargetInvocation == null) {
            return null;
        }
        return iTargetInvocation.getInvocation();
    }

    public void setMethod(IMethod iMethod) {
        if (this.testCase == null) {
            return;
        }
        ITargetInvocation iTargetInvocation = this.getTargetInvocation();
        if (iTargetInvocation == null) {
            if (iMethod == null) {
                return;
            }
            iTargetInvocation = this.createTargetInvocation();
        } else {
            IMethod iMethod2 = this.getMethod();
            if (iMethod2 != null) {
                this.testCase.getImplementor().getMethods().remove(iMethod2);
            }
        }
        if (iMethod != null) {
            this.testCase.getImplementor().getMethods().add(iMethod);
        }
        iTargetInvocation.setInvocation(iMethod);
        this.testCaseModified = true;
    }

    public String getAttribute(int n) {
        ITargetInvocation iTargetInvocation = this.getTargetInvocation();
        if (iTargetInvocation == null) {
            return null;
        }
        String string = null;
        switch (n) {
            case 3: {
                string = "abs_path";
                break;
            }
            case 4: {
                string = "body";
                break;
            }
            case 1: {
                string = "host";
                break;
            }
            case 2: {
                string = "port";
                break;
            }
            case 6: {
                string = "version";
                break;
            }
            case 5: {
                IMethod iMethod = this.getMethod();
                if (iMethod != null) {
                    return iMethod.getName();
                }
                return null;
            }
            case 7: {
                string = "think_time";
                break;
            }
            case 8: {
                string = "page_num";
                break;
            }
            case 9: {
                string = "page_order";
                break;
            }
            case 10: {
                string = "conn_id";
                break;
            }
            case 11: {
                string = "conn_order";
                break;
            }
            case 12: {
                string = "is_ssl";
                break;
            }
            default: {
                return null;
            }
        }
        Iterator iterator = iTargetInvocation.getActionProperties().getProperties().iterator();
        while (iterator.hasNext()) {
            IProperty iProperty = (IProperty)iterator.next();
            if (!PROPERTY_DESC_ATT.equals(iProperty.getDescription()) || !string.equals(iProperty.getName())) continue;
            return iProperty.getValue();
        }
        return null;
    }

    public void setAttribute(int n, String string) {
        if (this.testCase == null) {
            return;
        }
        if ("".equals(string)) {
            string = null;
        }
        String string2 = null;
        switch (n) {
            case 3: {
                string2 = "abs_path";
                break;
            }
            case 4: {
                string2 = "body";
                break;
            }
            case 1: {
                string2 = "host";
                break;
            }
            case 2: {
                string2 = "port";
                int n2 = this.parseInteger(string);
                if (n2 > 0) break;
                string = null;
                break;
            }
            case 6: {
                string2 = "version";
                break;
            }
            case 5: {
                if (string == null) {
                    this.setMethod(null);
                } else {
                    IMethod iMethod = this.getMethod();
                    if (iMethod == null) {
                        iMethod = HyadesFactory.INSTANCE.createMethod();
                        this.setMethod(iMethod);
                    }
                    iMethod.setName(string);
                    this.testCaseModified = true;
                }
                return;
            }
            case 7: {
                string2 = "think_time";
                int n3 = this.parseInteger(string);
                if (n3 >= -1) break;
                string = "0";
                break;
            }
            case 8: {
                string2 = "page_num";
                int n4 = this.parseInteger(string);
                if (n4 >= 0) break;
                string = "0";
                break;
            }
            case 9: {
                string2 = "page_order";
                int n5 = this.parseInteger(string);
                if (n5 == 1 || n5 == 2 || n5 == 3 || n5 == 4) break;
                string = Integer.toString(0);
                break;
            }
            case 10: {
                string2 = "conn_id";
                int n6 = this.parseInteger(string);
                if (n6 >= 0) break;
                string = "0";
                break;
            }
            case 11: {
                string2 = "conn_order";
                int n7 = this.parseInteger(string);
                if (n7 == 1 || n7 == 2 || n7 == 3) break;
                string = Integer.toString(0);
                break;
            }
            case 12: {
                string2 = "is_ssl";
                break;
            }
            default: {
                return;
            }
        }
        ITargetInvocation iTargetInvocation = this.getTargetInvocation();
        if (iTargetInvocation == null) {
            if (string == null) {
                return;
            }
            iTargetInvocation = this.createTargetInvocation();
        }
        IProperty iProperty = null;
        IProperty iProperty2 = iTargetInvocation.getActionProperties().getProperties().iterator();
        while (iProperty2.hasNext()) {
            IProperty iProperty3 = (IProperty)iProperty2.next();
            if (!PROPERTY_DESC_ATT.equals(iProperty3.getDescription()) || !string2.equals(iProperty3.getName())) continue;
            iProperty = iProperty3;
            break;
        }
        if (iProperty != null) {
            if (string != null) {
                iProperty.setValue(string);
            } else {
                iTargetInvocation.getActionProperties().getProperties().remove(iProperty);
            }
            this.testCaseModified = true;
        } else if (string != null) {
            iProperty2 = HyadesFactory.INSTANCE.createProperty();
            iProperty2.setName(string2);
            iProperty2.setValue(string);
            iProperty2.setDescription(PROPERTY_DESC_ATT);
            iTargetInvocation.getActionProperties().getProperties().add(iProperty2);
            this.testCaseModified = true;
        }
    }

    public String getHeader(String string) {
        ITargetInvocation iTargetInvocation = this.getTargetInvocation();
        if (iTargetInvocation == null) {
            return null;
        }
        if (string != null) {
            Iterator iterator = iTargetInvocation.getActionProperties().getProperties().iterator();
            while (iterator.hasNext()) {
                IProperty iProperty = (IProperty)iterator.next();
                if (!PROPERTY_DESC_HEADER.equals(iProperty.getDescription()) || !string.equals(iProperty.getName())) continue;
                return iProperty.getValue();
            }
        }
        return null;
    }

    public IProperty[] getHeaders() {
        ITargetInvocation iTargetInvocation = this.getTargetInvocation();
        if (iTargetInvocation == null) {
            return new IProperty[0];
        }
        ArrayList<IProperty> arrayList = new ArrayList<IProperty>();
        Iterator iterator = iTargetInvocation.getActionProperties().getProperties().iterator();
        while (iterator.hasNext()) {
            IProperty iProperty = (IProperty)iterator.next();
            if (!PROPERTY_DESC_HEADER.equals(iProperty.getDescription())) continue;
            arrayList.add(iProperty);
        }
        return arrayList.toArray(new IProperty[arrayList.size()]);
    }

    public void swapHeaders(IProperty iProperty, IProperty iProperty2) {
        if (iProperty == null || iProperty2 == null) {
            return;
        }
        ITargetInvocation iTargetInvocation = this.getTargetInvocation();
        if (iTargetInvocation == null) {
            return;
        }
        List list = iTargetInvocation.getActionProperties().getProperties();
        int n = list.indexOf(iProperty);
        if (n < 0) {
            return;
        }
        int n2 = list.indexOf(iProperty2);
        if (n2 < 0) {
            return;
        }
        CoreUtil.swap((List)list, (int)n, (int)n2);
    }

    public void addHeader(IProperty iProperty) {
        if (iProperty == null) {
            return;
        }
        ITargetInvocation iTargetInvocation = this.getTargetInvocation();
        if (iTargetInvocation == null) {
            iTargetInvocation = this.createTargetInvocation();
        } else if (iTargetInvocation.getActionProperties().getProperties().contains(iProperty)) {
            return;
        }
        iProperty.setDescription(PROPERTY_DESC_HEADER);
        iTargetInvocation.getActionProperties().getProperties().add(iProperty);
        this.testCaseModified = true;
    }

    public void removeHeader(IProperty iProperty) {
        if (iProperty == null) {
            return;
        }
        ITargetInvocation iTargetInvocation = this.getTargetInvocation();
        if (iTargetInvocation == null) {
            return;
        }
        this.testCaseModified = iTargetInvocation.getActionProperties().getProperties().remove(iProperty);
    }

    public void setHeader(String string, String string2) {
        ITargetInvocation iTargetInvocation;
        if (string == null) {
            return;
        }
        if ("".equals(string2)) {
            string2 = null;
        }
        if ((iTargetInvocation = this.getTargetInvocation()) == null) {
            if (string == null) {
                return;
            }
            iTargetInvocation = this.createTargetInvocation();
        }
        IProperty iProperty = iTargetInvocation.getActionProperties().getProperties().iterator();
        while (iProperty.hasNext()) {
            IProperty iProperty2 = (IProperty)iProperty.next();
            if (!PROPERTY_DESC_HEADER.equals(iProperty2.getDescription()) || !string.equals(iProperty2.getName())) continue;
            iProperty2.setValue(string2);
            this.testCaseModified = true;
            return;
        }
        if (string2 != null) {
            iProperty = HyadesFactory.INSTANCE.createProperty();
            iProperty.setName(string);
            iProperty.setValue(string2);
            iProperty.setDescription(PROPERTY_DESC_HEADER);
            iTargetInvocation.getActionProperties().getProperties().add(iProperty);
            this.testCaseModified = true;
        }
    }

    public HttpRequest createHttpRequest() {
        if (this.getTargetInvocation() == null) {
            return null;
        }
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setAbsolutePath(this.getAttribute(3));
        httpRequest.setHost(this.getAttribute(1));
        httpRequest.setMethod(this.getAttribute(5));
        httpRequest.setBody(this.getAttribute(4));
        httpRequest.setVersion(this.getAttribute(6));
        try {
            httpRequest.setPort(Integer.parseInt(this.getAttribute(2)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            httpRequest.setThinkTime(Long.parseLong(this.getAttribute(7)));
        }
        catch (NumberFormatException numberFormatException) {
            httpRequest.setThinkTime(200L);
        }
        try {
            httpRequest.setPageNumber(Integer.parseInt(this.getAttribute(8)));
        }
        catch (NumberFormatException numberFormatException) {
            httpRequest.setPageNumber(0);
        }
        try {
            httpRequest.setPageOrder(Integer.parseInt(this.getAttribute(9)));
        }
        catch (NumberFormatException numberFormatException) {
            httpRequest.setPageOrder(0);
        }
        try {
            httpRequest.setConnID(Integer.parseInt(this.getAttribute(10)));
        }
        catch (NumberFormatException numberFormatException) {
            httpRequest.setConnID(0);
        }
        try {
            httpRequest.setConnOrder(Integer.parseInt(this.getAttribute(11)));
        }
        catch (NumberFormatException numberFormatException) {
            httpRequest.setConnOrder(0);
        }
        httpRequest.setSecure("true".equalsIgnoreCase(this.getAttribute(12)));
        IProperty[] iPropertyArray = this.getHeaders();
        int n = iPropertyArray.length;
        for (int i = 0; i < n; ++i) {
            HttpHeader httpHeader = new HttpHeader();
            httpHeader.setName(iPropertyArray[i].getName());
            httpHeader.setValue(iPropertyArray[i].getValue());
            httpRequest.addHeader(httpHeader);
        }
        return httpRequest;
    }

    protected int parseInteger(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MIN_VALUE;
        }
    }
}

