/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.IExpandableMessage;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceSyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ImageImpl;

public class TraceCollapsedSyncMessage
extends TraceSyncMessage
implements IExpandableMessage {
    static IImage image = new ImageImpl(TraceSDPlugin.getResourceImage("collapsed_message.gif"));

    static int deltaX(int width, BaseMessage m) {
        int ret = width;
        ret += width >= 0 ? -19 : 10;
        if (m.getEndLifeline() == null && m instanceof SyncMessageReturn) {
            ret -= 6;
        }
        if (m.getStartLifeline() == m.getEndLifeline()) {
            ret += 10;
        }
        return ret;
    }

    static int deltaY(BaseMessage m) {
        int ret = 2;
        if (m.getStartLifeline() == m.getEndLifeline()) {
            ret -= 14;
        }
        return ret;
    }

    public void draw(IGC context) {
        super.draw(context);
        if (image != null) {
            int x = this.getX();
            int y = this.getY();
            int width = this.getWidth();
            int height = this.getHeight();
            x += TraceCollapsedSyncMessage.deltaX(width, (BaseMessage)this);
            y += TraceCollapsedSyncMessage.deltaY((BaseMessage)this);
            if (this.isSelected()) {
                context.setForeground(Frame.getUserPref().getBackGroundColorSelection());
                context.setLineWidth(5);
                context.drawRectangle(x + 1, y + 1, 8, 8);
                context.setBackground(Frame.getUserPref().getBackGroundColorSelection());
                context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
                context.setLineWidth(1);
            }
            context.drawImage(image, x, y, 11, 11);
        }
    }
}

