/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.TestCase;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.impl.tests.Util;

public class ComponentIdentificationImplTest
extends TestCase {
    public ComponentIdentificationImplTest(String string) {
        super(string);
    }

    public void testGeneration() throws Exception {
        ComponentIdentification componentIdentification = Util.generateComponentIdentification();
    }

    public void testSerialization() throws Exception {
        ComponentIdentification componentIdentification = Util.generateComponentIdentification();
        Util.testSerialization(componentIdentification);
    }

    public void testValidationRequired() throws Exception {
        ComponentIdentification componentIdentification = Util.generateComponentIdentification();
        componentIdentification.validate();
        componentIdentification.setComponent(null);
        Util.assertMissingAttributes(componentIdentification, "component");
        componentIdentification = Util.generateComponentIdentification();
        componentIdentification.setComponentIdType(null);
        Util.assertMissingAttributes(componentIdentification, "componentIdType");
        componentIdentification = Util.generateComponentIdentification();
        componentIdentification.setSubComponent(null);
        Util.assertMissingAttributes(componentIdentification, "subComponent");
        componentIdentification = Util.generateComponentIdentification();
        componentIdentification.setComponentIdType(null);
        Util.assertMissingAttributes(componentIdentification, "componentIdType");
        componentIdentification = Util.generateComponentIdentification();
        componentIdentification.setLocation(null);
        Util.assertMissingAttributes(componentIdentification, "location");
        componentIdentification = Util.generateComponentIdentification();
        componentIdentification.setLocationType(null);
        Util.assertMissingAttributes(componentIdentification, "locationType");
    }

    public void testValidationBoundaries() throws Exception {
        ComponentIdentification componentIdentification = Util.generateComponentIdentification();
        componentIdentification.validate();
        componentIdentification.setApplication(Util.getPaddedString(256));
        componentIdentification.setComponent(Util.getPaddedString(256));
        componentIdentification.setSubComponent(Util.getPaddedString(512));
        componentIdentification.setComponentIdType(Util.getPaddedString(32));
        componentIdentification.setExecutionEnvironment(Util.getPaddedString(256));
        componentIdentification.setInstanceId(Util.getPaddedString(128));
        componentIdentification.setLocation(Util.getPaddedString(128));
        componentIdentification.setProcessId(Util.getPaddedString(64));
        componentIdentification.setThreadId(Util.getPaddedString(64));
        componentIdentification.validate();
        componentIdentification = Util.generateComponentIdentification();
        componentIdentification.setApplication(Util.getPaddedString(257));
        Util.assertInvalidBoundaries(componentIdentification, "application");
        componentIdentification = Util.generateComponentIdentification();
        componentIdentification.setComponent(Util.getPaddedString(257));
        Util.assertInvalidBoundaries(componentIdentification, "component");
        componentIdentification = Util.generateComponentIdentification();
        componentIdentification.setSubComponent(Util.getPaddedString(513));
        Util.assertInvalidBoundaries(componentIdentification, "subComponent");
        componentIdentification = Util.generateComponentIdentification();
        componentIdentification.setComponentIdType(Util.getPaddedString(33));
        Util.assertInvalidBoundaries(componentIdentification, "componentIdType");
        componentIdentification = Util.generateComponentIdentification();
        componentIdentification.setExecutionEnvironment(Util.getPaddedString(257));
        Util.assertInvalidBoundaries(componentIdentification, "executionEnvironment");
        componentIdentification = Util.generateComponentIdentification();
        componentIdentification.setInstanceId(Util.getPaddedString(129));
        Util.assertInvalidBoundaries(componentIdentification, "instanceId");
        componentIdentification = Util.generateComponentIdentification();
        componentIdentification.setLocation(Util.getPaddedString(257));
        Util.assertInvalidBoundaries(componentIdentification, "location");
        componentIdentification = Util.generateComponentIdentification();
        componentIdentification.setLocationType(Util.getPaddedString(33));
        Util.assertInvalidBoundaries(componentIdentification, "locationType");
        componentIdentification = Util.generateComponentIdentification();
        componentIdentification.setProcessId(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(componentIdentification, "processId");
        componentIdentification = Util.generateComponentIdentification();
        componentIdentification.setThreadId(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(componentIdentification, "threadId");
    }
}

