/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.tests.MockEmfAdapter;

public class Util {
    static String getPaddedString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = "0123456789".length();
        int n3 = 0;
        while (n3 < n / n2) {
            stringBuffer.append("0123456789");
            ++n3;
        }
        stringBuffer.append("0123456789".substring(0, n % n2));
        return stringBuffer.toString();
    }

    static String getAlphaString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".length();
        int n3 = 0;
        while (n3 < n / n2) {
            stringBuffer.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
            ++n3;
        }
        stringBuffer.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ".substring(0, n % n2));
        return stringBuffer.toString();
    }

    static void testSerialization(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object2 = objectInputStream.readObject();
            Assert.assertEquals((String)"objects do not match", (Object)object, (Object)object2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.fail((String)(classNotFoundException.getClass() + " " + classNotFoundException.getMessage()));
        }
    }

    public static CommonBaseEvent generateEvent() {
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        commonBaseEvent.setCreationTime("1999-05-31T13:20:00-05:00");
        commonBaseEvent.setGlobalInstanceId("CE123456789012345678901234567890");
        ComponentIdentification componentIdentification = EventFactory.eINSTANCE.createComponentIdentification();
        componentIdentification.setLocation("My Location");
        componentIdentification.setLocationType("Unknown");
        componentIdentification.setComponent("My Component");
        componentIdentification.setSubComponent("My sub component");
        componentIdentification.setComponentIdType("My Component ID Type");
        componentIdentification.setComponentType("My Component Type");
        commonBaseEvent.setReporterComponentId(componentIdentification);
        ComponentIdentification componentIdentification2 = EventFactory.eINSTANCE.createComponentIdentification();
        componentIdentification2.setLocation("My Location 2");
        componentIdentification2.setLocationType("Unknown");
        componentIdentification2.setComponent("My Component 2");
        componentIdentification2.setSubComponent("My sub component 2");
        componentIdentification2.setComponentIdType("My Component ID Type 2");
        componentIdentification2.setComponentType("My Component Type 2");
        commonBaseEvent.setSourceComponentId(componentIdentification2);
        Situation situation = EventFactory.eINSTANCE.createSituation();
        AvailableSituation availableSituation = EventFactory.eINSTANCE.createAvailableSituation();
        availableSituation.setAvailabilityDisposition("NOT AVAILABLE");
        availableSituation.setOperationDisposition("STARTABLE");
        availableSituation.setProcessingDisposition("MGMTTASK_PROCESS");
        availableSituation.setReasoningScope("EXTERNAL");
        situation.setCategoryName("AvailableSituation");
        situation.setSituationType(availableSituation);
        commonBaseEvent.setSituation(situation);
        return commonBaseEvent;
    }

    static CommonBaseEvent generateEventWithoutRequiredPrimitives() {
        CommonBaseEvent commonBaseEvent = EventFactory.eINSTANCE.createCommonBaseEvent();
        ComponentIdentification componentIdentification = EventFactory.eINSTANCE.createComponentIdentification();
        componentIdentification.setLocation("My Location 2");
        componentIdentification.setLocationType("Unknown");
        componentIdentification.setComponent("My Component 2");
        componentIdentification.setSubComponent("My sub component 2");
        componentIdentification.setComponentIdType("My Component ID Type 2");
        componentIdentification.setComponentType("My Component Type 2");
        commonBaseEvent.setSourceComponentId(componentIdentification);
        Situation situation = EventFactory.eINSTANCE.createSituation();
        AvailableSituation availableSituation = EventFactory.eINSTANCE.createAvailableSituation();
        availableSituation.setAvailabilityDisposition("NOT AVAILABLE");
        availableSituation.setOperationDisposition("STARTABLE");
        availableSituation.setProcessingDisposition("MGMTTASK_PROCESS");
        availableSituation.setReasoningScope("EXTERNAL");
        situation.setCategoryName("AvailableSituation");
        situation.setSituationType(availableSituation);
        commonBaseEvent.setSituation(situation);
        return commonBaseEvent;
    }

    static ComponentIdentification generateComponentIdentification() {
        ComponentIdentification componentIdentification = EventFactory.eINSTANCE.createComponentIdentification();
        componentIdentification.setApplication("A");
        componentIdentification.setComponent("A");
        componentIdentification.setComponentType("A");
        componentIdentification.setComponentIdType("A");
        componentIdentification.setExecutionEnvironment("A");
        componentIdentification.setInstanceId("A");
        componentIdentification.setLocation("A");
        componentIdentification.setLocationType("FQHostname");
        componentIdentification.setProcessId("A");
        componentIdentification.setSubComponent("A");
        componentIdentification.setThreadId("A");
        return componentIdentification;
    }

    static MsgDataElement generateMsgDataElement() {
        MsgDataElement msgDataElement = EventFactory.eINSTANCE.createMsgDataElement();
        msgDataElement.getMsgCatalogTokens();
        msgDataElement.setMsgCatalog("A");
        msgDataElement.setMsgCatalogId("A");
        msgDataElement.setMsgId("A");
        msgDataElement.setMsgLocale("A");
        return msgDataElement;
    }

    static boolean testEObjectSerialization(EObject eObject) {
        String string = "abc123";
        boolean bl = true;
        EClass eClass = eObject.eClass();
        try {
            Util.testSerialization(eObject);
            EList eList = eClass.getEAllAttributes();
            int n = 0;
            while (n < eList.size()) {
                EAttribute eAttribute = (EAttribute)eList.get(n);
                if (eAttribute.getEAttributeType().getName().equals("EString")) {
                    if (eAttribute.getUpperBound() > 0) {
                        eObject.eSet((EStructuralFeature)eAttribute, (Object)string);
                    } else {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(string);
                        eObject.eSet((EStructuralFeature)eAttribute, arrayList);
                    }
                } else {
                    Assert.fail((String)("assertion type: " + eAttribute.eClass()));
                }
                ++n;
            }
            Util.testSerialization(eObject);
            int n2 = 0;
            while (n2 < eList.size()) {
                int n3 = 0;
                while (n3 < eList.size()) {
                    EAttribute eAttribute = (EAttribute)eList.get(n2);
                    if (n2 == n3) {
                        if (eAttribute.getEAttributeType().getName().equals("EString")) {
                            if (eAttribute.getUpperBound() > 0) {
                                eObject.eSet((EStructuralFeature)eAttribute, (Object)string);
                            } else {
                                ArrayList<String> arrayList = new ArrayList<String>();
                                arrayList.add(string);
                                eObject.eSet((EStructuralFeature)eAttribute, arrayList);
                            }
                        } else {
                            Assert.fail((String)("assertion type: " + eAttribute.eClass()));
                        }
                    } else {
                        eObject.eUnset((EStructuralFeature)eAttribute);
                    }
                    Util.testSerialization(eObject);
                    ++n3;
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            Assert.fail((String)(iOException.getClass() + " " + iOException.getMessage()));
        }
        return bl;
    }

    static void assertMissingAttributes(Object object, String string) {
        try {
            Method method = object.getClass().getMethod("validate", null);
            method.invoke(object, null);
            Assert.fail((String)("Should not accept, this attribute is missing: [" + string + "]"));
        }
        catch (SecurityException securityException) {
            Assert.fail((String)securityException.getLocalizedMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.fail((String)illegalArgumentException.getLocalizedMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Assert.fail((String)noSuchMethodException.getLocalizedMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.fail((String)illegalAccessException.getLocalizedMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (!(invocationTargetException.getTargetException() instanceof ValidationException)) {
                Assert.fail((String)invocationTargetException.getLocalizedMessage());
            }
            Util.assertExceptionId("IWAT0203E", (Exception)invocationTargetException.getTargetException());
        }
    }

    public static EObject clone(EObject eObject) {
        EObject eObject2 = null;
        if (eObject != null) {
            EList eList;
            EClass eClass = eObject.eClass();
            eObject2 = EventFactory.eINSTANCE.create(eClass);
            EList eList2 = eClass.getEAllAttributes();
            int n = 0;
            while (n < eList2.size()) {
                eList = (EAttribute)eList2.get(n);
                Object object = eObject.eGet((EStructuralFeature)eList);
                eObject2.eSet((EStructuralFeature)eList, object);
                ++n;
            }
            eList = eClass.getEAllContainments();
            int n2 = 0;
            while (n2 < eList.size()) {
                List list;
                EReference eReference = (EReference)eList.get(n2);
                Object object = eObject.eGet((EStructuralFeature)eReference);
                if (object instanceof List) {
                    list = (List)object;
                    ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
                    int n3 = 0;
                    while (n3 < list.size()) {
                        Object e = list.get(n3);
                        if (e instanceof EObject) {
                            arrayList.add(Util.clone((EObject)e));
                        } else {
                            arrayList.add(e);
                        }
                        ++n3;
                    }
                    eObject2.eSet((EStructuralFeature)eReference, arrayList);
                } else {
                    list = Util.clone((EObject)object);
                    eObject2.eSet((EStructuralFeature)eReference, (Object)list);
                }
                ++n2;
            }
        }
        return eObject2;
    }

    static void assertValidBoundaries(Object object) {
        try {
            Method method = object.getClass().getMethod("validate", null);
            method.invoke(object, null);
        }
        catch (SecurityException securityException) {
            Assert.fail((String)securityException.getLocalizedMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.fail((String)illegalArgumentException.getLocalizedMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Assert.fail((String)noSuchMethodException.getLocalizedMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.fail((String)illegalAccessException.getLocalizedMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof ValidationException) {
                Assert.fail((String)"String lengths are within the proper size");
            }
            Assert.fail((String)invocationTargetException.getLocalizedMessage());
        }
    }

    static void assertInvalidBoundaries(Object object, String string) {
        try {
            Method method = object.getClass().getMethod("validate", null);
            method.invoke(object, null);
            Assert.fail((String)("Should not accept oversized attribute: [" + string + "]"));
        }
        catch (SecurityException securityException) {
            Assert.fail((String)securityException.getLocalizedMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.fail((String)illegalArgumentException.getLocalizedMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Assert.fail((String)noSuchMethodException.getLocalizedMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.fail((String)illegalAccessException.getLocalizedMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (!(invocationTargetException.getTargetException() instanceof ValidationException)) {
                Assert.fail((String)invocationTargetException.getLocalizedMessage());
            }
            Util.assertExceptionId("IWAT0207E", (Exception)invocationTargetException.getTargetException());
        }
    }

    static void assertExceptionId(String string, Exception exception) {
        String string2 = exception.getLocalizedMessage().substring(0, 10).trim();
        Assert.assertEquals((String)string, (String)string2);
        Assert.assertEquals((int)-1, (int)exception.getLocalizedMessage().indexOf("{"));
    }

    static void assertAdapterNotification(EObject eObject) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("EString", "zyxabc");
        hashMap.put("ELong", new Long(812L));
        hashMap.put("EShort", new Short(1));
        MockEmfAdapter mockEmfAdapter = new MockEmfAdapter((Notifier)eObject);
        eObject.eAdapters().add(mockEmfAdapter);
        EClass eClass = eObject.eClass();
        EList eList = eClass.getEAllAttributes();
        int n = 0;
        while (n < eList.size()) {
            EAttribute eAttribute = (EAttribute)eList.get(n);
            String string = eAttribute.getEAttributeType().getName();
            Object v = hashMap.get(string);
            if (v != null) {
                if (eAttribute.getUpperBound() > 0) {
                    eObject.eSet((EStructuralFeature)eAttribute, v);
                    Assert.assertEquals(v, (Object)mockEmfAdapter.getLastNotification().getNewValue());
                } else {
                    ArrayList arrayList = new ArrayList();
                    arrayList.add(v);
                    eObject.eSet((EStructuralFeature)eAttribute, arrayList);
                    Assert.assertEquals(v, (Object)mockEmfAdapter.getLastNotification().getNewValue());
                }
            } else {
                Assert.fail((String)("assertion type: " + eAttribute.getEAttributeType().getName()));
            }
            ++n;
        }
    }

    static void assertUnsupportedFeature(EObject eObject) {
        EventPackage eventPackage = EventPackage.eINSTANCE;
        EAttribute eAttribute = eventPackage.getAssociatedEvent_ResolvedEvents();
        if (eObject.eClass().equals(eventPackage.getAssociatedEvent())) {
            eAttribute = eventPackage.getCommonBaseEvent_ElapsedTime();
        }
        try {
            eObject.eGet((EStructuralFeature)eAttribute);
            Assert.fail((String)"Non-existent feature for eGet");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            eObject.eSet((EStructuralFeature)eAttribute, null);
            Assert.fail((String)"Non-existent feature for eSet");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            eObject.eIsSet((EStructuralFeature)eAttribute);
            Assert.fail((String)"Non-existent feature for eIsSet");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            eObject.eUnset((EStructuralFeature)eAttribute);
            Assert.fail((String)"Non-existent feature for eUnset");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

