/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.SQLType;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.impl.RDBHelper;

public class ClassMetadata {
    protected EAttribute[] singleAttributes;
    protected EAttribute[] manyAttributes;
    protected EClass[] rootSuperclasses;
    protected EClass[] nonRootSuperclasses;
    protected EClass[] allSuperclasses;
    protected EClass[] allSubclasses;
    protected EReference[] containReferences;
    protected EReference[] notContainReferences;
    protected EReference[] manyReferences;
    protected EReference[] classTableReferences;
    protected EReference containerReference;
    protected Map classesToData;
    protected DBMap dbMap;
    protected EClass eClass;
    protected RDBHelper helper;
    protected Table table;
    protected Column primaryKey;
    protected DBMap.ClassData classData;
    protected List classTableColumns;
    protected List referenceClassTableColumns;
    protected int[] classTableSQLTypes;
    protected int[] manyAttributeSQLTypes;
    protected EFactory[] typeFactories;
    protected EFactory classFactory;

    public ClassMetadata(EClass eClass, DBMap dbMap, RDBHelper helper) {
        this.eClass = eClass;
        this.dbMap = dbMap;
        this.helper = helper;
    }

    public Table getTable() {
        if (this.table == null) {
            this.table = this.computeTable();
        }
        return this.table;
    }

    protected Table computeTable() {
        if (this.classData == null) {
            this.classData = this.computeClassData();
        }
        return this.classData.getTable();
    }

    protected DBMap.ClassData computeClassData() {
        return (DBMap.ClassData)this.dbMap.getDBRepresentation((EModelElement)this.eClass);
    }

    public Column getPrimaryKey() {
        if (this.primaryKey == null) {
            this.primaryKey = this.computePrimaryKey();
        }
        return this.primaryKey;
    }

    protected Column computePrimaryKey() {
        if (this.table == null) {
            this.getTable();
        }
        return this.helper.getPrimaryKey(this.table);
    }

    protected void processAttributes() {
        EList attributes = this.eClass.getEAttributes();
        ArrayList<EAttribute> single = new ArrayList<EAttribute>();
        ArrayList<EAttribute> many = new ArrayList<EAttribute>();
        int l = attributes.size();
        for (int i = 0; i < l; ++i) {
            EAttribute attribute = (EAttribute)attributes.get(i);
            if (attribute.isTransient()) continue;
            if (attribute.isMany()) {
                many.add(attribute);
                continue;
            }
            single.add(attribute);
        }
        this.singleAttributes = single.toArray(new EAttribute[single.size()]);
        this.manyAttributes = many.toArray(new EAttribute[many.size()]);
    }

    public EAttribute[] getSingleAttributes() {
        if (this.singleAttributes == null) {
            this.processAttributes();
        }
        return this.singleAttributes;
    }

    public EAttribute[] getManyAttributes() {
        if (this.manyAttributes == null) {
            this.processAttributes();
        }
        return this.manyAttributes;
    }

    public EFactory[] getTypeFactories() {
        if (this.typeFactories == null) {
            this.typeFactories = this.computeTypeFactories();
        }
        return this.typeFactories;
    }

    protected EFactory[] computeTypeFactories() {
        if (this.singleAttributes == null) {
            this.processAttributes();
        }
        EFactory[] factories = new EFactory[this.singleAttributes.length];
        for (int i = 0; i < this.singleAttributes.length; ++i) {
            EFactory factory;
            EDataType datatype = this.singleAttributes[i].getEAttributeType();
            EPackage pkg = (EPackage)datatype.eContainer();
            factories[i] = factory = pkg.getEFactoryInstance();
        }
        return factories;
    }

    public EFactory getClassFactory() {
        if (this.classFactory == null) {
            this.classFactory = this.computeClassFactory();
        }
        return this.classFactory;
    }

    protected EFactory computeClassFactory() {
        EPackage pkg = (EPackage)this.eClass.eContainer();
        return pkg.getEFactoryInstance();
    }

    public List getClassTableColumns() {
        if (this.classTableColumns == null) {
            this.classTableColumns = this.computeClassTableColumns();
        }
        return this.classTableColumns;
    }

    protected List computeClassTableColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        if (this.singleAttributes == null) {
            this.processAttributes();
        }
        for (int i = 0; i < this.singleAttributes.length; ++i) {
            DBMap.AttributeData data = (DBMap.AttributeData)this.dbMap.getDBRepresentation((EModelElement)this.singleAttributes[i]);
            columns.add(data.getValueColumn());
        }
        return columns;
    }

    public List getReferenceClassTableColumns() {
        if (this.referenceClassTableColumns == null) {
            this.processClassTableReferences();
        }
        return this.referenceClassTableColumns;
    }

    public EReference[] getClassTableReferences() {
        if (this.classTableReferences == null) {
            this.processClassTableReferences();
        }
        return this.classTableReferences;
    }

    protected void processClassTableReferences() {
        Table classTable = this.getTable();
        EList columns = classTable.getColumns();
        ArrayList<EReference> references = new ArrayList<EReference>();
        this.referenceClassTableColumns = new ArrayList();
        int l = columns.size();
        for (int i = 0; i < l; ++i) {
            Column column = (Column)columns.get(i);
            EReference reference = this.dbMap.getReference(column);
            if (reference == null) continue;
            references.add(reference);
            this.referenceClassTableColumns.add(column);
            if (!reference.isMany()) continue;
            DBMap.ReferenceData data = (DBMap.ReferenceData)this.dbMap.getDBRepresentation((EModelElement)reference);
            this.referenceClassTableColumns.add(data.getOrderColumn());
        }
        this.classTableReferences = references.toArray(new EReference[references.size()]);
    }

    public int[] getClassTableSQLTypes() {
        if (this.classTableSQLTypes == null) {
            this.classTableSQLTypes = this.computeClassTableSQLTypes();
        }
        return this.classTableSQLTypes;
    }

    protected int[] computeClassTableSQLTypes() {
        if (this.classTableColumns == null) {
            this.classTableColumns = this.computeClassTableColumns();
        }
        int[] types = new int[this.classTableColumns.size()];
        int l = this.classTableColumns.size();
        for (int i = 0; i < l; ++i) {
            SQLType type = ((Column)this.classTableColumns.get(i)).getType();
            types[i] = type.getSqlType();
        }
        return types;
    }

    public boolean isComputeId() {
        if (this.classData == null) {
            this.classData = this.computeClassData();
        }
        return this.classData.isComputeId();
    }

    protected void processSuperclasses() {
        if (this.allSuperclasses == null) {
            this.allSuperclasses = this.computeAllSuperclasses();
        }
        ArrayList<EClass> roots = new ArrayList<EClass>();
        ArrayList<EClass> other = new ArrayList<EClass>();
        for (int i = 0; i < this.allSuperclasses.length; ++i) {
            EClass superclass = this.allSuperclasses[i];
            if (superclass.getESuperTypes().isEmpty()) {
                roots.add(superclass);
                continue;
            }
            other.add(superclass);
        }
        this.rootSuperclasses = roots.toArray(new EClass[roots.size()]);
        this.nonRootSuperclasses = other.toArray(new EClass[other.size()]);
    }

    protected EClass[] computeAllSuperclasses() {
        EList superclasses = this.eClass.getEAllSuperTypes();
        return superclasses.toArray(new EClass[superclasses.size()]);
    }

    public EClass[] getRootSuperclasses() {
        if (this.rootSuperclasses == null) {
            this.processSuperclasses();
        }
        return this.rootSuperclasses;
    }

    public EClass[] getNonRootSuperclasses() {
        if (this.nonRootSuperclasses == null) {
            this.processSuperclasses();
        }
        return this.nonRootSuperclasses;
    }

    public EClass[] getAllSuperclasses() {
        if (this.allSuperclasses == null) {
            this.allSuperclasses = this.computeAllSuperclasses();
        }
        return this.allSuperclasses;
    }

    public int[] getManyAttributeSQLTypes() {
        if (this.manyAttributeSQLTypes == null) {
            this.manyAttributeSQLTypes = this.computeManyAttributeSQLTypes();
        }
        return this.manyAttributeSQLTypes;
    }

    protected int[] computeManyAttributeSQLTypes() {
        if (this.manyAttributes == null) {
            this.processAttributes();
        }
        int[] types = new int[this.manyAttributes.length];
        for (int i = 0; i < this.manyAttributes.length; ++i) {
            EAttribute attrib = this.manyAttributes[i];
            DBMap.AttributeData attributeData = (DBMap.AttributeData)this.dbMap.getDBRepresentation((EModelElement)attrib);
            Column value = attributeData.getValueColumn();
            types[i] = value.getType().getSqlType();
        }
        return types;
    }

    public EClass[] getAllSubclasses() {
        if (this.allSubclasses == null) {
            List subclasses = this.dbMap.getAllSubclasses(this.eClass);
            this.allSubclasses = subclasses.toArray(new EClass[subclasses.size()]);
        }
        return this.allSubclasses;
    }

    public EReference[] getReferences() {
        if (this.notContainReferences == null) {
            this.processReferences();
        }
        return this.notContainReferences;
    }

    public EReference[] getContainmentReferences() {
        if (this.containReferences == null) {
            this.processReferences();
        }
        return this.containReferences;
    }

    public EReference[] getManyReferences() {
        if (this.manyReferences == null) {
            this.processReferences();
        }
        return this.manyReferences;
    }

    public EReference getContainerReference() {
        if (this.manyReferences == null) {
            this.processReferences();
        }
        return this.containerReference;
    }

    protected void processReferences() {
        ArrayList<EReference> notContain = new ArrayList<EReference>();
        ArrayList<EReference> contain = new ArrayList<EReference>();
        ArrayList<EReference> many = new ArrayList<EReference>();
        EList references = this.eClass.getEAllReferences();
        int l = references.size();
        for (int i = 0; i < l; ++i) {
            EReference reference = (EReference)references.get(i);
            if (reference.isContainer()) {
                this.containerReference = reference;
            }
            if (reference.isTransient() || reference.isContainer()) continue;
            if (reference.isContainment()) {
                contain.add(reference);
            } else {
                notContain.add(reference);
            }
            EReference opposite = reference.getEOpposite();
            if (reference.isMany() && (opposite == null || opposite.isMany())) {
                many.add(reference);
                continue;
            }
            if (!reference.isMany() || reference.isUnique()) continue;
            many.add(reference);
        }
        this.containReferences = contain.toArray(new EReference[contain.size()]);
        this.notContainReferences = notContain.toArray(new EReference[notContain.size()]);
        this.manyReferences = many.toArray(new EReference[many.size()]);
    }

    public DBMap getDbMap() {
        return this.dbMap;
    }
}

