/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.Date;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataPoint;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputProcessingExceptionCodes;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.eclipse.hyades.ui.sample.svg.generator.SVGLineChart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGAreaChart
extends SVGLineChart
implements IGraphicDocumentStyle,
IDataInputProcessingExceptionCodes,
Serializable {
    public SVGAreaChart() {
        this.graphicType = "area";
    }

    public Document generateGraphicDocument(GraphicDocumentProperties input) throws DataInputProcessingException {
        double maxAlloableLegendWidth;
        double maxLengthOfLegendLableWidth;
        double maxAllowableYMarkerWidth;
        GraphicAttributes graphicAttrs = this.createGraphicAttributes(input);
        Document newDataDocument = graphicAttrs.getDataDocument();
        int numberOfDatasets = 0;
        String[] legendFlyOverLabels = null;
        try {
            numberOfDatasets = this.dataRetriever.getNumberOfDatasets(newDataDocument);
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.graphicType);
            throw e;
        }
        String rangeMaxValue = null;
        int gridXOffset = 60;
        int halfGridXOffset = gridXOffset / 2;
        int gridYOffset = 50;
        int xAxisLength = 0;
        try {
            this.xAxis = this.dataRetriever.getDataRange(newDataDocument, "S");
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.getGraphicType());
            throw e;
        }
        try {
            this.yAxis = this.dataRetriever.getDataRange(newDataDocument, "W");
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.getGraphicType());
            throw e;
        }
        if (this.xAxis == null || this.yAxis == null) {
            throw new DataInputProcessingException("", 126, "dataRange", this.getGraphicType());
        }
        if (this.xAxis.getType() != 0 || this.yAxis.getType() != 0) {
            throw new DataInputProcessingException("", 129, "dataRange", this.getGraphicType());
        }
        this.xMarkers = this.xAxis.getSegmentMarkers();
        this.yMarkers = this.yAxis.getSegmentMarkers();
        if (this.yMarkers != null && this.yMarkers.length > 0) {
            rangeMaxValue = this.yMarkers[this.yMarkers.length - 1].getValueString();
        }
        this.dataSets = new DataSet[numberOfDatasets];
        for (int i = 0; i < numberOfDatasets; ++i) {
            this.dataSets[i] = this.dataRetriever.getDatasetWithPosition(newDataDocument, Integer.toString(i));
        }
        legendFlyOverLabels = this.getLegendFlyOverLabels(this.dataSets);
        double maxLengthOfYmarkerWidth = this.getMaxLengthOfYmarker(this.yMarkers, graphicAttrs);
        if (maxLengthOfYmarkerWidth > (maxAllowableYMarkerWidth = (double)(graphicAttrs.getGraphicWidth() / 4))) {
            maxLengthOfYmarkerWidth = maxAllowableYMarkerWidth;
        }
        if ((maxLengthOfLegendLableWidth = this.getMaxLengthOfLegendLabel(graphicAttrs, this.dataSets)) > (maxAlloableLegendWidth = (double)(graphicAttrs.getGraphicWidth() / 3))) {
            maxLengthOfLegendLableWidth = maxAlloableLegendWidth;
        }
        if (graphicAttrs.isLegendSuppressed()) {
            maxLengthOfLegendLableWidth = 0.0;
        }
        xAxisLength = (int)((double)graphicAttrs.getGraphicWidth() - (maxLengthOfLegendLableWidth + maxLengthOfYmarkerWidth + (double)gridXOffset));
        int xLabelRowCount = this.getNumberOfAxisLabels(graphicAttrs, xAxisLength, this.xAxis);
        int yAxisLength = (int)((double)graphicAttrs.getGraphicHeight() - (double)gridYOffset * 2.5 - (double)(xLabelRowCount * 10));
        Document generatedDocument = this.createSvgDocument(newDataDocument.getImplementation(), Short.toString(graphicAttrs.getGraphicWidth()), Short.toString(graphicAttrs.getGraphicHeight()));
        Element svgRoot = generatedDocument.getDocumentElement();
        this.registerEventHandler(svgRoot, "onload", "init(evt)");
        this.addDefinitions(generatedDocument, graphicAttrs, numberOfDatasets);
        this.addJavaScriptFunctions(generatedDocument, graphicAttrs, numberOfDatasets, gridXOffset, gridYOffset, xAxisLength, yAxisLength);
        if (!graphicAttrs.isOutlineSuppressed()) {
            this.addOutline(generatedDocument, graphicAttrs);
        }
        if (!graphicAttrs.isTimestampSuppressed()) {
            try {
                String timestamp = this.dataRetriever.getTimestamp(newDataDocument);
                Date date = GraphicAttributes.parseISO8601Date(timestamp);
                this.addTimeStamp(generatedDocument, graphicAttrs, date == null ? timestamp : graphicAttrs.formatDate(date));
            }
            catch (DataInputProcessingException e) {
                e.setWidgetType(this.graphicType);
                throw e;
            }
        }
        if (!graphicAttrs.isTitlebarSuppressed()) {
            this.addTitleBar(generatedDocument, graphicAttrs);
        } else {
            gridYOffset = super.resetGridOffsetForCenter(graphicAttrs.getGraphicHeight(), yAxisLength, 3.0);
        }
        if (!graphicAttrs.isUserPreferencesSuppressed() && graphicAttrs.getSvgFormatOnly()) {
            this.addPreferenceIcon(generatedDocument, graphicAttrs);
        }
        gridXOffset = halfGridXOffset + (int)maxLengthOfYmarkerWidth;
        this.addGrid(generatedDocument, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis);
        this.addAxisLabels(generatedDocument, graphicAttrs, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis);
        this.addTitles(generatedDocument, graphicAttrs, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis, xLabelRowCount, rangeMaxValue);
        Element gTextBoxElement = generatedDocument.createElement("g");
        this.addDataSets(generatedDocument, graphicAttrs, svgRoot, gTextBoxElement, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis, this.dataSets);
        if (!graphicAttrs.isLegendSuppressed()) {
            try {
                String[] legendLabels = this.dataRetriever.getLegendLabels(newDataDocument);
                this.addLegend(generatedDocument, graphicAttrs, gTextBoxElement, legendLabels, legendFlyOverLabels, (int)maxLengthOfYmarkerWidth + xAxisLength + halfGridXOffset, gridYOffset);
            }
            catch (DataInputProcessingException e) {
                e.setWidgetType(this.graphicType);
                throw e;
            }
        }
        svgRoot.appendChild(gTextBoxElement);
        return generatedDocument;
    }

    protected Element addLegendItemGraphic(Document generatedDocument, Element parent, int index, int fontSize, int x, int y) {
        String[] legendShapeType = new String[]{"#legendcircleshape", "#legendsquareshape", "#legendhorizontalrectshape", "#legendverticalrectshape", "#legendtriangleshape", "#legenddiamondshape"};
        Element useElementShape = generatedDocument.createElement("use");
        useElementShape.setAttribute("xlink:href", "#legendsquareshapeWithoutLine");
        useElementShape.setAttribute("x", Integer.toString(x));
        useElementShape.setAttribute("y", Integer.toString(y + fontSize - 9));
        Element gColourElement = generatedDocument.createElement("g");
        gColourElement.setAttribute("id", "legendsquareshapeWithoutLine" + index);
        gColourElement.setAttribute("class", "shape" + index);
        if (this.graphicType.equals("area")) {
            gColourElement.setAttribute("onclick", "toggleVisibility('dataColour" + index + "');");
            gColourElement.setAttribute("onmouseover", "ChangeOpacity('poly" + index + "', '0.6');");
            gColourElement.setAttribute("onmouseout", "ChangeOpacity('poly" + index + "', '0.1');");
        }
        gColourElement.appendChild(useElementShape);
        parent.appendChild(gColourElement);
        useElementShape = generatedDocument.createElement("use");
        useElementShape.setAttribute("xlink:href", legendShapeType[index % legendShapeType.length]);
        useElementShape.setAttribute("x", Integer.toString(x));
        useElementShape.setAttribute("y", Integer.toString(y + fontSize - 8));
        gColourElement = generatedDocument.createElement("g");
        gColourElement.setAttribute("id", "shape" + index);
        gColourElement.setAttribute("onclick", "toggleVisibility('dataColour" + index + "');");
        gColourElement.setAttribute("onmouseover", "ChangeOpacity('poly" + index + "', '0.6');");
        gColourElement.setAttribute("onmouseout", "ChangeOpacity('poly" + index + "', '0.1');");
        gColourElement.setAttribute("class", "shape" + index);
        gColourElement.appendChild(useElementShape);
        return gColourElement;
    }

    private void addDataSets(Document generatedDocument, GraphicAttributes attrs, Element parent, Element gTextBoxElement, int xAxisLength, int yAxisLength, int gridXOffset, int gridYOffset, DataRange xAxis, DataRange yAxis, DataSet[] dataSets) throws DataInputProcessingException {
        double xMin = xAxis.getMinValue();
        double xMax = xAxis.getMaxValue();
        double yMin = yAxis.getMinValue();
        double yMax = yAxis.getMaxValue();
        if (xMin == xMax || yMin == yMax) {
            return;
        }
        for (int i = 0; i < dataSets.length; ++i) {
            DataSet dataset = dataSets[i];
            DataPoint[] dps = dataset.getDataPoints();
            double[] yPositions = new double[dps.length];
            double[] xPositions = new double[dps.length];
            for (int j = 0; j < dps.length; ++j) {
                xPositions[j] = (double)xAxisLength * (dps[j].getValue1() - xMin) / (xMax - xMin);
                yPositions[j] = (double)yAxisLength * (yMax - dps[j].getValue2()) / (yMax - yMin);
            }
            this.addArea(generatedDocument, parent, dps, i, xPositions, yPositions, xAxisLength, yAxisLength, gridXOffset, gridYOffset);
            String stylesheetClass = "dataValues anchorAtMiddle";
            Element gToggleElement = generatedDocument.createElement("g");
            gToggleElement.setAttribute("id", "textbox" + i);
            gToggleElement.setAttribute("class", stylesheetClass);
            gToggleElement.setAttribute("transform", "translate(" + gridXOffset + "," + gridYOffset + ")");
            gToggleElement.setAttribute("visibility", "hidden");
            gToggleElement.setAttribute("onclick", "toggleVisibility('textbox" + i + "');");
            gTextBoxElement.appendChild(gToggleElement);
            this.addTextBoxes(generatedDocument, attrs, gToggleElement, i, xPositions, yPositions, dps, xAxisLength, yAxisLength);
        }
    }

    private void addArea(Document generatedDocument, Element parent, DataPoint[] dps, int linesetNumber, double[] xPositions, double[] yPositions, int xAxisLength, int yAxisLength, int gridXOffset, int gridYOffset) {
        double yNext;
        double xNext;
        String[] shapeType = new String[]{"#circleshape", "#squareshape", "#horizontalrectshape", "#verticalrectshape", "#triangleshape", "#diamondshape"};
        double[] shapeWidth = new double[]{5.6, 5.6, 5.6, 2.8, 5.6, 5.6};
        double[] shapeHeight = new double[]{5.6, 5.6, 2.8, 5.6, 4.85, 5.6};
        double BOX_HEIGHT = 18.0;
        int length = xPositions.length;
        double xPrevious = 0.0;
        double yPrevious = 0.0;
        Element gColourElement = generatedDocument.createElement("g");
        String pointAttribute = xPositions[0] + " " + yAxisLength;
        for (int i = 0; i < length; ++i) {
            xNext = xPositions[i];
            yNext = yPositions[i];
            pointAttribute = pointAttribute + ", " + xNext + " " + yNext;
        }
        pointAttribute = pointAttribute + ", " + xPositions[length - 1] + " " + yAxisLength;
        Element polygonElement = generatedDocument.createElement("polygon");
        polygonElement.setAttribute("id", "poly" + linesetNumber);
        polygonElement.setAttribute("points", pointAttribute);
        polygonElement.setAttribute("style", "fill-opacity: 0.1; stroke: black; stroke-width: 0;");
        polygonElement.setAttribute("transform", "translate(" + gridXOffset + "," + gridYOffset + ")");
        gColourElement.appendChild(polygonElement);
        gColourElement.setAttribute("id", "dataColour" + linesetNumber);
        gColourElement.setAttribute("class", "dataset" + linesetNumber);
        gColourElement.setAttribute("visibility", "visible");
        gColourElement.setAttribute("onclick", "toggleVisibility('textbox" + linesetNumber + "');");
        parent.appendChild(gColourElement);
        int shapeNumber = linesetNumber % shapeType.length;
        for (int i = 0; i < length; ++i) {
            double shapeX;
            xNext = xPositions[i];
            yNext = yPositions[i];
            if (i > 0) {
                Element newElement = generatedDocument.createElement("polyline");
                String points = xPrevious + " " + yPrevious + "," + xNext + " " + yNext;
                newElement.setAttribute("points", points);
                if (dps[i].getType() == 1 || dps[i - 1].getType() == 1) {
                    newElement.setAttribute("style", "stroke-dasharray: 9, 5; stroke-width: 2;");
                }
                newElement.setAttribute("transform", "translate(" + gridXOffset + "," + gridYOffset + ")");
                gColourElement.appendChild(newElement);
            }
            if ((shapeX = xNext - shapeWidth[shapeNumber] / 2.0) <= 0.0) {
                shapeX = 0.0;
            } else if (shapeX + shapeWidth[shapeNumber] > (double)xAxisLength) {
                shapeX = (double)xAxisLength - shapeWidth[shapeNumber];
            }
            double shapeY = yNext - shapeHeight[shapeNumber] / 2.0;
            if (shapeY + shapeHeight[shapeNumber] > (double)yAxisLength) {
                shapeY = (double)yAxisLength - shapeHeight[shapeNumber];
            }
            Element shapeElement = generatedDocument.createElement("use");
            if (dps[i].getType() == 1) {
                shapeElement.setAttribute("xlink:href", "#holeshape");
            } else {
                shapeElement.setAttribute("xlink:href", shapeType[shapeNumber]);
            }
            shapeElement.setAttribute("transform", "translate(" + ((double)gridXOffset + shapeX) + "," + ((double)gridYOffset + shapeY) + ")");
            shapeElement.setAttribute("visibility", "visible");
            gColourElement.appendChild(shapeElement);
            xPrevious = xNext;
            yPrevious = yNext;
        }
    }

    protected GraphicAttributes createGraphicAttributes(GraphicDocumentProperties input) throws DataInputProcessingException {
        GraphicAttributes graphicAttrs = new GraphicAttributes();
        graphicAttrs.setGraphicWidth("450");
        graphicAttrs.setPreferencesPage("prefs_area.htm");
        graphicAttrs.setPreferencesPageWidth("430");
        graphicAttrs.setPreferencesPageHeight("495");
        graphicAttrs.setConfigDocument(input.getConfigDocument());
        graphicAttrs.setDataDocument(input.getDataDocument());
        this.getConfigAttributes(graphicAttrs);
        graphicAttrs.setAttributesFrom(input);
        return graphicAttrs;
    }
}

