/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ColumnData;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.LogAnalyzerUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class CBEFilterUI
extends LogAnalyzerUI {
    private Button _sevOne;
    private Button _sevTwo;
    private Button _sevThree;
    private String _filter;
    private String _sevFilter;
    private String _title;
    private Composite result;

    public Control createControl(Composite parent) {
        this.result = (Composite)super.createControl(parent);
        this.setDescription(LogUIPlugin.getResourceString("STR_COL_DLG_TEXT"));
        Composite sevText = new Composite(this.result, 0);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        sevText.setLayoutData((Object)data);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 1;
        sevText.setLayout((Layout)blayout);
        Label label = new Label(sevText, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        label.setText(LogUIPlugin.getResourceString("STR_SHOW_LOG_FILTER_TEXT"));
        Composite sevWidget = new Composite(sevText, 0);
        data = new GridData();
        data.horizontalSpan = 3;
        sevWidget.setLayoutData((Object)data);
        blayout = new GridLayout();
        blayout.numColumns = 3;
        sevWidget.setLayout((Layout)blayout);
        this._sevOne = new Button(sevWidget, 32);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._sevOne.setLayoutData((Object)data);
        this._sevOne.setText(LogUIPlugin.getResourceString("STR_FILTER_ERROR"));
        this._sevOne.addSelectionListener((SelectionListener)this);
        this._sevTwo = new Button(sevWidget, 32);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._sevTwo.setLayoutData((Object)data);
        this._sevTwo.setText(LogUIPlugin.getResourceString("STR_FILTER_WARNING"));
        this._sevTwo.addSelectionListener((SelectionListener)this);
        this._sevThree = new Button(sevWidget, 32);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._sevThree.setLayoutData((Object)data);
        this._sevThree.setText(LogUIPlugin.getResourceString("STR_FILTER_INFO"));
        this._sevThree.addSelectionListener((SelectionListener)this);
        this.populateList();
        this.populateSeverity();
        WorkbenchHelp.setHelp((Control)this._sevOne, (String)ContextIds.ACTLOG_VIEW_DIALOG_FILTER_ERROR);
        WorkbenchHelp.setHelp((Control)this._sevTwo, (String)ContextIds.ACTLOG_VIEW_DIALOG_FILTER_WARNING);
        WorkbenchHelp.setHelp((Control)this._sevThree, (String)ContextIds.ACTLOG_VIEW_DIALOG_FILTER_INFORMATION);
        return this.result;
    }

    protected void populateList() {
        this._pdList.removeAll();
        for (int idx = 0; idx < this._pdData.size(); ++idx) {
            ColumnData data = (ColumnData)this._pdData.get(idx);
            TableItem item = new TableItem(this._pdList, 0);
            item.setText(data.name());
            item.setChecked(data.visible());
            item.setData((Object)data);
        }
        if (this._pdList.getItemCount() > 0) {
            this._pdList.select(0);
            this._moveDown.setEnabled(true);
        }
    }

    private void populateSeverity() {
        this._sevOne.setSelection(true);
        this._sevTwo.setSelection(true);
        this._sevThree.setSelection(true);
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        String filters = store.getString("pd_sev_options");
        if (filters != null) {
            String data;
            int idx = filters.indexOf(" ");
            if (idx != -1) {
                data = filters.substring(0, 1);
                this._sevOne.setSelection(data.equals("1"));
                filters = filters.substring(idx + 1);
            }
            if ((idx = filters.indexOf(" ")) != -1) {
                data = filters.substring(0, 1);
                this._sevTwo.setSelection(data.equals("1"));
                filters = filters.substring(idx + 1);
            }
            if ((idx = filters.indexOf(" ")) != -1) {
                data = filters.substring(0, 1);
                this._sevThree.setSelection(data.equals("1"));
                filters = filters.substring(idx + 1);
            }
        }
    }

    public void initializeValues(boolean defaultValue) {
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        String pdFilters = defaultValue ? store.getDefaultString("pd_filter_options") : store.getString("pd_filter_options");
        String filterSev = defaultValue ? store.getDefaultString("pd_sev_options") : store.getString("pd_sev_options");
        this.createColumnDataFromString(pdFilters, this._pdData);
        this.populateList();
        if (filterSev.length() > 0) {
            if (filterSev.substring(0, 1).equals("1")) {
                this._sevOne.setSelection(true);
            } else {
                this._sevOne.setSelection(false);
            }
            if (filterSev.substring(2, 3).equals("1")) {
                this._sevTwo.setSelection(true);
            } else {
                this._sevTwo.setSelection(false);
            }
            if (filterSev.substring(4, 5).equals("1")) {
                this._sevThree.setSelection(true);
            } else {
                this._sevThree.setSelection(false);
            }
        } else {
            this._sevOne.setSelection(true);
            this._sevTwo.setSelection(true);
            this._sevThree.setSelection(true);
        }
        if (defaultValue) {
            Event e = new Event();
            e.widget = this.result;
            e.type = 13;
            this.notifyListeners(new SelectionEvent(e));
        }
    }

    public boolean storeValues(IPreferenceStore store) {
        if (!this.validate(this._pdList)) {
            String title = LogUIPlugin.getResourceString("LOGGING_MESSAGE");
            String msg = LogUIPlugin.getResourceString("ERR_SELECT_COLS");
            MessageDialog.openError((Shell)this._sevOne.getShell(), (String)title, (String)msg);
            this._pdData.clear();
            return false;
        }
        this.loadColumnData("pd_filter_options", this._pdData, this._pdList, store);
        String sevFilters = "";
        sevFilters = this._sevOne.getSelection() ? "1 " : "0 ";
        sevFilters = this._sevTwo.getSelection() ? sevFilters + "1 " : sevFilters + "0 ";
        sevFilters = this._sevThree.getSelection() ? sevFilters + "1 " : sevFilters + "0 ";
        LogUIPlugin.getDefault().getPreferenceStore().setValue("pd_sev_options", sevFilters);
        this._pdData.clear();
        return true;
    }

    private boolean validate(Table _list) {
        boolean valid = false;
        for (int idx = 0; idx < _list.getItemCount(); ++idx) {
            TableItem item = _list.getItem(idx);
            if (!item.getChecked()) continue;
            return true;
        }
        return valid;
    }

    public Composite getControl() {
        return this.result;
    }
}

