/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class CTree {
    protected ArrayList fAgentTypeList;
    protected Label _label;
    protected Tree _tree;
    protected Composite groupWidget;

    public CTree(Composite parent, String text) {
        this.groupWidget = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.groupWidget.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        data.heightHint = 200;
        data.widthHint = 250;
        this.groupWidget.setLayoutData((Object)data);
        this._label = new Label(this.groupWidget, 0);
        this._label.setText(text);
        this._tree = new Tree(this.groupWidget, 2818);
    }

    public TreeItem addItem(TreeItem item, boolean select) {
        if (item.getParentItem() != null) {
            TreeItem agent;
            TreeItem pItem = this.getItem(item.getParentItem().getData());
            if (pItem == null) {
                pItem = new TreeItem(this._tree, 0);
                this.setItemData(pItem, item.getParentItem().getData());
            }
            if ((agent = this.getItem(pItem, item.getText())) == null) {
                agent = new TreeItem(pItem, 0);
                this.setItemData(agent, item.getData());
            }
            if (select) {
                this._tree.setSelection(new TreeItem[]{agent});
            }
            return pItem;
        }
        TreeItem pItem = this.getItemEntry(item);
        if (pItem == null) {
            pItem = new TreeItem(this._tree, 0);
            this.setItemData(pItem, item.getData());
        }
        TreeItem[] agents = item.getItems();
        for (int idx = 0; idx < agents.length; ++idx) {
            TreeItem agent = this.getItem(pItem, agents[idx].getText());
            if (agent != null) continue;
            agent = new TreeItem(pItem, 0);
            this.setItemData(agent, agents[idx].getData());
        }
        if (select) {
            this._tree.setSelection(new TreeItem[]{pItem});
        }
        return pItem;
    }

    public void clearSelection() {
        this._tree.deselectAll();
    }

    public boolean contains(String item) {
        TreeItem[] items = this._tree.getItems();
        for (int idx = 0; idx < items.length; ++idx) {
            if (!items[idx].getData().equals(item)) continue;
            return true;
        }
        return false;
    }

    public TreeItem createItem(TreeItem parent, Object data, boolean select) {
        TreeItem item = null;
        if (parent == null) {
            String name = ((Process)data).getName();
            if (name == null) {
                name = ((Process)data).getExecutable();
            }
            if ((item = this.getItem(name)) == null) {
                item = new TreeItem(this._tree, 0);
            }
        } else {
            item = new TreeItem(parent, 0);
        }
        this.setItemData(item, data);
        return item;
    }

    public void enable(boolean enable) {
        this._tree.setEnabled(enable);
        this._label.setEnabled(enable);
    }

    public int getItemCount() {
        if (this._tree != null) {
            return this._tree.getItemCount();
        }
        return 0;
    }

    public TreeItem getItem(int position) {
        TreeItem[] items = this._tree.getItems();
        if (position < items.length) {
            return items[position];
        }
        return null;
    }

    protected TreeItem getItemEntry(Object item) {
        if (item == null) {
            return null;
        }
        TreeItem[] items = this._tree.getItems();
        for (int idx = 0; idx < items.length; ++idx) {
            if (!items[idx].getData().equals(((TreeItem)item).getData())) continue;
            return items[idx];
        }
        return null;
    }

    protected TreeItem getItem(Object data) {
        if (data == null) {
            return null;
        }
        TreeItem[] items = this._tree.getItems();
        for (int idx = 0; idx < items.length; ++idx) {
            if (!items[idx].getData().toString().equals(data.toString())) continue;
            return items[idx];
        }
        return null;
    }

    protected TreeItem getItem(TreeItem parent, Object data) {
        if (parent == null) {
            return this.getItem(data);
        }
        TreeItem[] items = parent.getItems();
        for (int idx = 0; idx < items.length; ++idx) {
            if (!items[idx].getData().toString().equals(data.toString())) continue;
            return items[idx];
        }
        return null;
    }

    public TreeItem[] getSelectedItems() {
        return this._tree.getSelection();
    }

    public Tree getTree() {
        return this._tree;
    }

    public Composite getWidget() {
        return this.groupWidget;
    }

    public void addProcessToTree(Process process, boolean showAll, boolean showAttached) {
        Enumeration agents = process.listAgents();
        boolean logAgentsEnabled = UIPlugin.getDefault().getPreferenceStore().getBoolean("log_option");
        boolean profileAgentsEnabled = UIPlugin.getDefault().getPreferenceStore().getBoolean("prof_option");
        if (showAll || agents.hasMoreElements()) {
            TreeItem item = null;
            while (agents.hasMoreElements()) {
                Agent agent = (Agent)agents.nextElement();
                if (!agent.isActive() || !showAttached && agent.isAttached()) continue;
                if (logAgentsEnabled && agent.getType().equals("Logging")) {
                    if (item == null) {
                        item = this.createItem(null, process, false);
                    }
                    this.createItem(item, agent, false);
                    continue;
                }
                if (profileAgentsEnabled && agent.getType().equals("Profiler")) {
                    if (item == null) {
                        item = this.createItem(null, process, false);
                    }
                    this.createItem(item, agent, false);
                    continue;
                }
                ArrayList agentList = this.getAgentTypeList();
                for (int i = 0; i < agentList.size(); ++i) {
                    if (agent.getType().equals("Logging") || !agent.getType().equals((String)agentList.get(i))) continue;
                    if (item == null) {
                        item = this.createItem(null, process, false);
                    }
                    this.createItem(item, agent, false);
                }
            }
        }
    }

    public void initializeTree(Enumeration processes, boolean showAll, boolean showAttached) {
        this.removeAll();
        if (processes == null) {
            return;
        }
        this._tree.setRedraw(false);
        while (processes.hasMoreElements()) {
            this.addProcessToTree((Process)processes.nextElement(), showAll, showAttached);
        }
        this._tree.setRedraw(true);
    }

    public void refreshTree(Vector list) {
        if (list.size() < 2) {
            return;
        }
        this._tree.setRedraw(false);
        for (int idx = 0; idx < list.size(); ++idx) {
            TreeItem item = (TreeItem)list.elementAt(idx);
            TreeItem newItem = new TreeItem(this._tree, 0);
            this.setItemData(newItem, item.getData());
            TreeItem[] agents = item.getItems();
            for (int i = 0; i < agents.length; ++i) {
                TreeItem newAgent = new TreeItem(newItem, 0);
                this.setItemData(newAgent, agents[i].getData());
            }
            item.dispose();
        }
        this._tree.setRedraw(true);
    }

    public void remove(TreeItem item) {
        TreeItem parent = item.getParentItem();
        item.dispose();
        if (parent != null && parent.getItemCount() == 0) {
            parent.dispose();
        }
    }

    public void removeAll() {
        this._tree.removeAll();
    }

    protected void setItemData(TreeItem item, Object data) {
        item.setData(data);
        if (item.getParentItem() == null) {
            String text = ((Process)data).getName();
            if (text == null) {
                text = ((Process)data).getExecutable();
            }
            try {
                text = text + "[PID:" + ((Process)data).getProcessId() + "]";
            }
            catch (InactiveProcessException exc) {
                // empty catch block
            }
            item.setText(text);
            item.setImage(PDPluginImages.getImage("process_obj.gif"));
        } else {
            item.setText(((Agent)data).getName());
            item.setImage(PDPluginImages.getImage("agent_detach_obj.gif"));
        }
    }

    public void setToolTipText(String text) {
        this._tree.setToolTipText(text);
    }

    public void sortSubItem(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            TreeItem ti = (TreeItem)v.elementAt(i);
            TreeItem[] _c = ti.getItems();
            if (_c == null || _c.length == 0) {
                return;
            }
            Vector<TreeItem> c = new Vector<TreeItem>(_c.length);
            for (int idx = 0; idx < _c.length; ++idx) {
                c.addElement(_c[idx]);
            }
            this.refreshAgents(c, ti);
        }
    }

    public void refreshAgents(Vector list, TreeItem parent) {
        if (list.size() < 2) {
            return;
        }
        this._tree.setRedraw(false);
        for (int idx = 0; idx < list.size(); ++idx) {
            TreeItem item = (TreeItem)list.elementAt(idx);
            TreeItem newItem = new TreeItem(parent, 0);
            this.setItemData(newItem, item.getData());
            item.dispose();
        }
        this._tree.setRedraw(true);
    }

    protected ArrayList getAgentTypeList() {
        if (this.fAgentTypeList == null) {
            this.fAgentTypeList = new ArrayList();
            this.fAgentTypeList.add("Logging");
        }
        return this.fAgentTypeList;
    }
}

