/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.extensions;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.ClassMetadata;
import org.eclipse.hyades.resources.database.internal.impl.InsertStatement;
import org.eclipse.hyades.resources.database.internal.impl.ReferenceInfo;
import org.eclipse.hyades.resources.database.internal.impl.TypeConverter;
import org.eclipse.hyades.resources.database.internal.impl.WeakObjectCache;

public class InsertObjects
extends InsertStatement {
    protected ClassMetadata metadata;
    protected TypeConverter converter;
    protected Map manyReferenceValues;
    protected WeakObjectCache cache;

    public InsertObjects(DatabaseType type, ClassMetadata metadata, TypeConverter converter, Map objectsToIds, Map manyReferenceValues, WeakObjectCache cache) {
        super(null, type, objectsToIds);
        this.cache = cache;
        this.metadata = metadata;
        this.converter = converter;
        this.manyReferenceValues = manyReferenceValues;
    }

    protected StringBuffer createRow(EObject object) throws Exception {
        EAttribute[] attribs = this.metadata.getSingleAttributes();
        int[] sqlTypes = this.metadata.getClassTableSQLTypes();
        StringBuffer row = new StringBuffer();
        row.append("(");
        boolean valueAppended = false;
        for (int i = 0; i < attribs.length; ++i) {
            if (valueAppended) {
                row.append(", ");
            }
            Object value = this.converter.getValue(object, attribs[i]);
            this.appendValue(row, value, sqlTypes[i]);
            valueAppended = true;
        }
        if (this.metadata.isComputeId()) {
            if (valueAppended) {
                row.append(", ");
            }
            valueAppended = true;
            this.appendValue(row, this.objectsToIds.get(object), 4);
        }
        if (valueAppended) {
            row.append(", ");
        }
        this.appendValue(row, this.getParentPath(object), 12);
        EReference[] references = this.metadata.getClassTableReferences();
        for (int i = 0; i < references.length; ++i) {
            EReference reference = references[i];
            if (reference.isMany()) {
                Map referenceMap = (Map)this.manyReferenceValues.get(object);
                if (referenceMap == null) {
                    row.append(", NULL, NULL");
                    continue;
                }
                ReferenceInfo info = (ReferenceInfo)referenceMap.get(reference);
                if (info == null) {
                    row.append(", NULL, NULL");
                    continue;
                }
                Object id = this.objectsToIds.get(info.getSource());
                if (id != null) {
                    row.append(", " + id.toString());
                } else {
                    row.append(", NULL");
                }
                row.append(", " + info.getPosition());
                continue;
            }
            EObject value = (EObject)object.eGet((EStructuralFeature)reference, false);
            row.append(", ");
            if (value == null) {
                row.append("NULL");
                continue;
            }
            Object id = this.objectsToIds.get(value);
            if (id != null) {
                row.append(id.toString());
                continue;
            }
            row.append("NULL");
        }
        row.append(")");
        return row;
    }

    protected Table getTable() {
        return this.metadata.getTable();
    }

    protected List getColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.addAll(this.metadata.getClassTableColumns());
        if (this.metadata.isComputeId()) {
            columns.add(this.metadata.getPrimaryKey());
        }
        columns.add(this.getColumn("p_p"));
        List referenceColumns = this.metadata.getReferenceClassTableColumns();
        columns.addAll(referenceColumns);
        return columns;
    }

    private Column getColumn(String columnName) {
        Iterator iter = this.getTable().getColumns().iterator();
        while (iter.hasNext()) {
            Column element = (Column)iter.next();
            if (!element.getName().equals(columnName)) continue;
            return element;
        }
        return null;
    }

    protected String getParentPath(EObject object) {
        String parentPath = "/";
        boolean first = true;
        for (object = object.eContainer(); object != null; object = object.eContainer()) {
            if (first) {
                first = false;
            } else {
                parentPath = "/" + parentPath;
            }
            Integer id = (Integer)this.objectsToIds.get(object);
            if (id == null) {
                id = this.cache.getId(object);
            }
            parentPath = id + parentPath;
        }
        return parentPath;
    }

    protected void addBatchedRow(PreparedStatement ps, EObject object) throws Exception {
        EAttribute[] attribs = this.metadata.getSingleAttributes();
        int[] sqlTypes = this.metadata.getClassTableSQLTypes();
        int colPos = 1;
        for (int i = 0; i < attribs.length; ++i) {
            Object value = this.converter.getValue(object, attribs[i]);
            this.appendBatchedValue(ps, colPos++, value, sqlTypes[i]);
        }
        if (this.metadata.isComputeId()) {
            this.appendBatchedValue(ps, colPos++, this.objectsToIds.get(object), 4);
        }
        this.appendBatchedValue(ps, colPos++, this.getParentPath(object), 12);
        EReference[] references = this.metadata.getClassTableReferences();
        for (int i = 0; i < references.length; ++i) {
            EReference reference = references[i];
            if (reference.isMany()) {
                Map referenceMap = (Map)this.manyReferenceValues.get(object);
                if (referenceMap == null) {
                    this.appendBatchedValue(ps, colPos++, null, 4);
                    this.appendBatchedValue(ps, colPos++, null, 4);
                    continue;
                }
                ReferenceInfo info = (ReferenceInfo)referenceMap.get(reference);
                if (info == null) {
                    this.appendBatchedValue(ps, colPos++, null, 4);
                    this.appendBatchedValue(ps, colPos++, null, 4);
                    continue;
                }
                Object id = this.objectsToIds.get(info.getSource());
                if (id != null) {
                    this.appendBatchedValue(ps, colPos++, id, 4);
                } else {
                    this.appendBatchedValue(ps, colPos++, null, 4);
                }
                this.appendBatchedValue(ps, colPos++, new Integer(info.getPosition()), 4);
                continue;
            }
            EObject value = (EObject)object.eGet((EStructuralFeature)reference, false);
            if (value == null) {
                this.appendBatchedValue(ps, colPos++, null, 4);
                continue;
            }
            Object id = this.objectsToIds.get(value);
            if (id != null) {
                this.appendBatchedValue(ps, colPos++, id, 4);
                continue;
            }
            this.appendBatchedValue(ps, colPos++, null, 4);
        }
        ps.addBatch();
    }
}

