/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.RDBHelper;
import org.eclipse.hyades.resources.database.internal.impl.SQLStatement;

public class DeleteStatement
extends SQLStatement {
    protected EClass eClass;
    protected List ids;
    protected DBMap.ClassData data;
    protected Column primaryKey;
    protected String[] statements;
    protected List statementList;
    protected StringBuffer header;

    public DeleteStatement(DBMap map, DatabaseType dbType, EClass eClass, List ids) {
        super(dbType, map);
        this.eClass = eClass;
        this.ids = ids;
        this.data = (DBMap.ClassData)this.dbMap.getDBRepresentation((EModelElement)eClass);
        RDBHelper helper = new RDBHelper();
        this.primaryKey = helper.getPrimaryKey(this.data.getTable());
    }

    public String getStatement() {
        StringBuffer buffer = new StringBuffer();
        if (this.header == null) {
            this.createHeader();
        }
        buffer = buffer.append(this.header);
        this.appendIds(buffer, 0);
        if (this.statementList == null) {
            return buffer.toString();
        }
        this.statements = this.statementList.toArray(new String[this.statementList.size()]);
        return null;
    }

    public String[] getStatements() {
        return this.statements;
    }

    protected void createHeader() {
        this.header = new StringBuffer();
        this.header.append("DELETE FROM ");
        this.header.append(this.addQuotes(this.data.getTable().getName()));
        this.header.append(" WHERE ");
        this.header.append(this.addQuotes(this.primaryKey.getName()));
        this.header.append(" IN (");
    }

    protected void appendIds(StringBuffer buffer, int position) {
        int l = this.ids.size();
        for (int i = position; i < l; ++i) {
            StringBuffer currentId = new StringBuffer();
            if (i != position) {
                currentId.append(", ");
            }
            currentId.append((Integer)this.ids.get(i));
            if (buffer.length() + currentId.length() > this.dbType.getMaximumSQLLength()) {
                buffer.append(")");
                this.addToStatementList(buffer);
                StringBuffer nextStatement = this.createNextStatement();
                this.appendIds(nextStatement, i);
                return;
            }
            buffer.append(currentId);
        }
        buffer.append(")");
        if (this.statementList != null) {
            this.addToStatementList(buffer);
        }
    }

    protected void addToStatementList(StringBuffer statement) {
        if (this.statementList == null) {
            this.statementList = new ArrayList();
        }
        this.statementList.add(statement.toString());
    }

    protected StringBuffer createNextStatement() {
        StringBuffer next = new StringBuffer();
        next.append(this.header);
        return next;
    }
}

