/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.http.TestHttpImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.ResourceBundleManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TestHttpPlugin
extends AbstractUIPlugin {
    private static TestHttpPlugin instance;
    private ResourceBundleManager resourceBundleManager;

    public TestHttpPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        instance = this;
    }

    public static TestHttpPlugin getInstance() {
        return instance;
    }

    public void startup() throws CoreException {
        this.resourceBundleManager = new ResourceBundleManager();
        this.resourceBundleManager.add(this.getDescriptor().getResourceBundle());
        this.resourceBundleManager.add(HyadesUIPlugin.getInstance().getResourceBundle());
        this.resourceBundleManager.add(TestUIPlugin.getInstance().getResourceBundle());
        this.resourceBundleManager.add(TestCommonPlugin.getInstance().getResourceBundle());
        super.startup();
        try {
            TestHttpImages.INSTANCE.initialize(new URL(this.getDescriptor().getInstallURL(), "icons/full/"), this.getImageRegistry());
        }
        catch (Exception exception) {
            TestHttpPlugin.logError(exception);
        }
    }

    public void shutdown() throws CoreException {
        this.resourceBundleManager.dispose();
        instance = null;
        super.shutdown();
    }

    public ResourceBundle getResourceBundle() {
        return this.getDescriptor().getResourceBundle();
    }

    public static String getID() {
        return instance.getDescriptor().getUniqueIdentifier();
    }

    public static void logError(Throwable throwable) {
        Status status = new Status(1, TestHttpPlugin.getID(), 0, throwable.toString(), throwable);
        TestHttpPlugin.getInstance().getLog().log((IStatus)status);
    }

    public static void logError(String string) {
        TestHttpPlugin.logError(new Throwable(string));
    }

    public static void logInfo(String string) {
        Status status = new Status(3, TestHttpPlugin.getID(), 0, string, new Throwable(string));
        TestHttpPlugin.getInstance().getLog().log((IStatus)status);
    }

    public static String getString(String string) throws NullPointerException, MissingResourceException {
        return TestHttpPlugin.instance.resourceBundleManager.getString(string);
    }

    public static String getString(String string, String string2) throws NullPointerException, MissingResourceException {
        return TestHttpPlugin.instance.resourceBundleManager.getString(string, string2);
    }

    public static String getString(String string, String[] stringArray) throws NullPointerException, MissingResourceException {
        return TestHttpPlugin.instance.resourceBundleManager.getString(string, stringArray);
    }
}

