/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class RunAction
extends Action
implements IDisposable {
    private IStructuredSelection structuredSelection;
    private IAssociationDescriptor wizardDescriptor;
    static /* synthetic */ Class class$org$eclipse$ui$IWorkbenchWizard;

    public RunAction() {
        super(TestUIPlugin.getString("RUN_TEXT"));
        WorkbenchHelp.setHelp((IAction)this, (String)(TestUIPlugin.getID() + ".tnav0005"));
    }

    public void dispose() {
        this.structuredSelection = null;
        this.wizardDescriptor = null;
    }

    protected IStructuredSelection getStructuredSelection() {
        return this.structuredSelection;
    }

    public void selectionChanged(IStructuredSelection structuredSelection) {
        this.wizardDescriptor = null;
        this.structuredSelection = structuredSelection;
    }

    protected IAssociationDescriptor getWizardDescriptor() {
        return this.wizardDescriptor;
    }

    public void run() {
        if (this.getWizardDescriptor() == null) {
            return;
        }
        IWorkbenchWizard workbenchWizard = (IWorkbenchWizard)this.getWizardDescriptor().createImplementationClassInstance();
        workbenchWizard.init(PlatformUI.getWorkbench(), this.getStructuredSelection());
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)workbenchWizard);
        dialog.open();
        workbenchWizard.dispose();
        this.wizardDescriptor = null;
        this.structuredSelection = null;
    }

    public boolean isApplicableForSelection() {
        String type;
        this.wizardDescriptor = null;
        if (this.structuredSelection == null || this.structuredSelection.size() != 1) {
            return false;
        }
        Object selection = this.structuredSelection.getFirstElement();
        if (selection instanceof ITest && (type = ((ITest)selection).getType()) != null) {
            IAssociationDescriptor descriptor = null;
            if (selection instanceof ITestSuite) {
                descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("runWizards").getDefaultAssociationDescriptor(type);
            } else if (selection instanceof ITestCase) {
                descriptor = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("runWizards").getDefaultAssociationDescriptor(type);
            }
            if (descriptor != null && descriptor.getImplementationClass() != null && (class$org$eclipse$ui$IWorkbenchWizard == null ? (class$org$eclipse$ui$IWorkbenchWizard = RunAction.class$("org.eclipse.ui.IWorkbenchWizard")) : class$org$eclipse$ui$IWorkbenchWizard).isAssignableFrom(descriptor.getImplementationClass())) {
                this.wizardDescriptor = descriptor;
            }
        }
        return this.wizardDescriptor != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

