/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.report.ReportDescription;
import org.eclipse.hyades.ui.internal.report.ReportManager;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

class ReportWizardPage
extends WizardPage
implements Listener {
    private IReportGenerator reportGenerator;
    private IStructuredSelection selection;
    private Table reportTable;
    private Button openEditorCheckBox;

    public ReportWizardPage(String name, IStructuredSelection sel) {
        super(name);
        this.selection = sel;
        this.setTitle(TestUIPlugin.getString("WIZ_TST_REPP_PG_TTL"));
        this.setDescription(TestUIPlugin.getString("wizard.Report.NoDataPoolDefinition.Page"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        IPreferenceStore store = TestUIPlugin.getInstance().getPreferenceStore();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.reportTable = new Table(composite, 2308);
        this.reportTable.setLayoutData((Object)GridDataUtil.createFill());
        this.openEditorCheckBox = new Button(composite, 32);
        this.openEditorCheckBox.setText(TestUIPlugin.getString("REPORT_OPEN_EDITOR"));
        this.openEditorCheckBox.setSelection(store.getBoolean("OpenReportEditor"));
        this.openEditorCheckBox.setSelection(true);
        this.populateReportsTable();
        this.reportTable.addListener(13, (Listener)this);
        if (this.reportTable.getItemCount() > 0) {
            String reportName = this.getDialogSettings().get("LAST_REPORT");
            if (reportName != null) {
                TableItem[] items = this.reportTable.getItems();
                int maxi = items.length;
                for (int i = 0; i < maxi; ++i) {
                    if (!reportName.equals(items[i].getText())) continue;
                    this.reportTable.select(i);
                    break;
                }
            }
            if (this.reportTable.getSelectionIndex() < 0) {
                this.reportTable.select(0);
            }
            Event event = new Event();
            event.widget = this.reportTable;
            event.item = this.reportTable.getSelection()[0];
            event.type = 13;
            this.handleEvent(event);
        }
        this.reportTable.setFocus();
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)(TestUIPlugin.getID() + ".rwiz0001"));
        WorkbenchHelp.setHelp((Control)this.openEditorCheckBox, (String)(TestUIPlugin.getID() + ".rwiz0002"));
        WorkbenchHelp.setHelp((Control)this.reportTable, (String)(TestUIPlugin.getID() + ".rwiz0003"));
    }

    public IReportGenerator getReportGenerator() {
        return this.reportGenerator;
    }

    public boolean openEditor() {
        return this.openEditorCheckBox.getSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void handleEvent(Event event) {
        this.setErrorMessage(null);
        switch (event.type) {
            case 13: {
                rep = this.getReportDescription();
                v0 = selectionOk = rep != null;
                if (!selectionOk) ** GOTO lbl34
                try {
                    this.reportGenerator = rep.getReportGenerator();
                    var6_4 = null;
                    ** if (this.reportGenerator != null) goto lbl-1000
                }
                catch (Throwable var5_8) {
                    var6_6 = null;
                    if (this.reportGenerator == null) {
                        this.setErrorMessage(TestUIPlugin.getString("NO_INSTANCE_ERROR_"));
                        selectionOk = false;
                    }
                    throw var5_8;
                }
lbl-1000:
                // 1 sources

                {
                    this.setErrorMessage(TestUIPlugin.getString("NO_INSTANCE_ERROR_"));
                    selectionOk = false;
                }
lbl-1000:
                // 2 sources

                {
                    ** GOTO lbl32
                    catch (Exception e) {
                        this.reportGenerator = null;
                        TestUIPlugin.logError(e);
                        var6_5 = null;
                        if (this.reportGenerator == null) {
                            this.setErrorMessage(TestUIPlugin.getString("NO_INSTANCE_ERROR_"));
                            selectionOk = false;
                        }
                    }
                }
lbl32:
                // 2 sources

                this.setMessage(null);
                ** GOTO lbl35
lbl34:
                // 1 sources

                this.setMessage(TestUIPlugin.getString("NO_REPORT_SEL"));
lbl35:
                // 2 sources

                this.setPageComplete(selectionOk);
            }
        }
    }

    public static boolean isInternalWebBrowserAvailable() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorDescriptor[] editors = workbench.getEditorRegistry().getEditors("foo.html");
        for (int i = 0; i < editors.length; ++i) {
            if (!"com.ibm.etools.webbrowser".equals(editors[i].getId())) continue;
            return true;
        }
        return false;
    }

    protected ReportDescription getReportDescription() {
        int idx = this.reportTable.getSelectionIndex();
        if (idx == -1) {
            return null;
        }
        Object obj = this.reportTable.getItem(idx).getData();
        if (obj instanceof ReportDescription) {
            return (ReportDescription)obj;
        }
        return null;
    }

    private void populateReportsTable() {
        this.reportTable.removeAll();
        ReportManager manager = TestUI.getReportManager();
        IReportDescription[] list = manager.getReportDescriptions();
        for (int idx = 0; idx < list.length; ++idx) {
            ReportDescription data = (ReportDescription)list[idx];
            IReportGenerator gen = null;
            try {
                gen = data.getReportGenerator();
            }
            catch (Exception exc) {
                // empty catch block
            }
            if (gen == null || !gen.isAvailable((ISelection)this.selection)) continue;
            TableItem item = new TableItem(this.reportTable, 0);
            item.setText(data.getName());
            item.setData((Object)data);
            item.setImage(TestUIImages.INSTANCE.getImage("report_obj.gif"));
        }
    }
}

