/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import java.util.ArrayList;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphHighlighter;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSelectionSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.TextGraph;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class GraphCanvas
extends Canvas
implements PaintListener {
    ArrayList graphs = new ArrayList();
    private static final boolean PAINT_BUFFERED = true;
    int buffer_w = -1;
    int buffer_h = -1;
    Image buffer = null;
    GC buffer_gc = null;
    Color bgcol;
    GraphHighlighter highlighter = null;
    GraphSelectionSource selection_source = null;

    public GraphCanvas(Composite parent, int style) {
        super(parent, style | 0x40000);
        this.addPaintListener(this);
        this.setBackground(this.getDisplay().getSystemColor(25));
    }

    public void addGraph(Graph graph) {
        this.graphs.add(graph);
    }

    public void removeGraph(Graph graph) {
        this.graphs.remove(graph);
    }

    public void removeAllGraphs() {
        this.graphs.clear();
    }

    public void dispose() {
        super.dispose();
        if (this.buffer != null) {
            this.buffer.dispose();
            this.buffer_gc.dispose();
            if (this.bgcol != null) {
                this.bgcol.dispose();
            }
        }
    }

    public void setBackground(RGB rgb) {
        if (this.bgcol != null) {
            this.bgcol.dispose();
        }
        this.bgcol = new Color((Device)this.getDisplay(), rgb);
        super.setBackground(this.bgcol);
    }

    public void setGraphHighlighter(GraphHighlighter h) {
        this.highlighter = h;
    }

    public void setGraphSelectionSource(GraphSelectionSource source) {
        this.selection_source = source;
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        int x = e.x;
        int y = e.y;
        int w = e.width;
        int h = e.height;
        if (w < 1 || h < 1) {
            return;
        }
        if ((this.buffer_w < w || this.buffer_h < h) && this.buffer != null) {
            this.buffer.dispose();
            this.buffer_gc.dispose();
            this.buffer = null;
            this.buffer_gc = null;
        }
        if (this.buffer == null) {
            if (this.getDisplay() == null) {
                return;
            }
            this.buffer_w = Math.max(this.buffer_w, w);
            this.buffer_h = Math.max(this.buffer_h, h);
            this.buffer = new Image((Device)this.getDisplay(), this.buffer_w, this.buffer_h);
            this.buffer_gc = new GC((Drawable)this.buffer);
        }
        this.paintUnbuffered(this.buffer_gc, x, y, w, h);
        gc.drawImage(this.buffer, 0, 0);
    }

    public void paintUnbuffered(GC gc, int x, int y, int w, int h) {
        Graph highlighted = null;
        if (this.highlighter != null && this.selection_source != null) {
            highlighted = this.selection_source.getSelectedGraph();
        }
        Color c = this.getBackground();
        gc.setBackground(c);
        gc.fillRectangle(x, y, w, h);
        int offset = 0;
        for (int i = 0; i < this.graphs.size(); ++i) {
            Graph g = (Graph)this.graphs.get(i);
            if (g == highlighted) {
                this.highlighter.setHighlight(g);
            }
            if (g instanceof TextGraph) {
                offset = ((TextGraph)g).paintGraph(gc, x, y, w, h, offset);
            } else {
                g.paintGraph(gc, x, y, w, h);
            }
            if (g != highlighted) continue;
            this.highlighter.unsetHighlight(g);
        }
    }
}

