/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import java.math.BigDecimal;

public class ZoomSliderUtilities {
    public static int calculateOOM(double n) {
        double old;
        int oom = 0;
        if (n == 0.0) {
            return 1;
        }
        while (n >= 10.0) {
            ++oom;
            old = n;
            if (old != (n /= 10.0)) continue;
        }
        while (n < 1.0) {
            --oom;
            old = n;
            if (old != (n *= 10.0)) continue;
            break;
        }
        return oom;
    }

    public static double round(double roundee, double rounder) {
        BigDecimal biggy = new BigDecimal(roundee / rounder);
        biggy = biggy.setScale(0, 4);
        biggy = biggy.multiply(new BigDecimal(rounder));
        int scale = 0;
        if (rounder < 1.0) {
            scale = Math.abs(ZoomSliderUtilities.calculateOOM(rounder));
        }
        biggy = biggy.setScale(scale, 4);
        return biggy.doubleValue();
    }

    public static String double2String(double n) {
        String string = String.valueOf(n);
        String whole = "";
        String fraction = "";
        int eIndex = string.indexOf(69);
        if (eIndex == -1) {
            int pointIndex = string.indexOf(46);
            whole = string.substring(0, pointIndex);
            fraction = string.substring(pointIndex + 1);
        } else {
            String base = string.substring(0, eIndex);
            int exponent = Integer.valueOf(string.substring(eIndex + 1));
            int pointIndex = base.indexOf(46);
            whole = base.substring(0, pointIndex);
            fraction = base.substring(pointIndex + 1);
            if (fraction.endsWith("0")) {
                fraction = fraction.substring(0, fraction.length() - 1);
            }
            if (exponent < 0) {
                if ((exponent = Math.abs(exponent)) <= whole.length()) {
                    whole = whole.substring(0, exponent);
                    fraction = whole.substring(exponent) + fraction;
                } else {
                    int zeroCount = exponent - whole.length();
                    fraction = whole + fraction;
                    whole = "0";
                    for (int i = 0; i < zeroCount; ++i) {
                        fraction = "0" + fraction;
                    }
                }
            } else if (exponent <= fraction.length()) {
                whole = whole + fraction.substring(0, exponent);
                fraction = fraction.substring(exponent);
            } else {
                int zeroCount = exponent - fraction.length();
                whole = whole + fraction;
                fraction = "0";
                for (int i = 0; i < zeroCount; ++i) {
                    whole = whole + "0";
                }
            }
        }
        if (fraction.equals("") || fraction.equals("0")) {
            return whole;
        }
        return whole + "." + fraction;
    }
}

