/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.util.EventObject;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.ChooseElementComposite;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ChooseElementDialog
extends Dialog
implements IDisposable,
IDoubleClickListener,
ISelectionChangedListener {
    private static final int HEIGHT = 300;
    private ChooseElementComposite chooseElementComposite;
    private Object[] elements;
    private IContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private Object initialSelection;
    private Object selection;
    private String selectionWidgetLabel;
    private String descriptionLabel;
    private String dialogTitle;

    public ChooseElementDialog(Shell parentShell, Object[] elements, ILabelProvider labelProvider, IContentProvider contentProvider) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.elements = elements;
        this.labelProvider = labelProvider;
        this.contentProvider = contentProvider == null ? new ArrayContentProvider() : contentProvider;
    }

    public static Object open(Shell parentShell, Object[] elements, ILabelProvider labelProvider) {
        return ChooseElementDialog.open(parentShell, HyadesUIPlugin.getString("DLG_CHOOSE_TTL"), elements, labelProvider);
    }

    public static Object open(Shell parentShell, String dialogTitle, Object[] elements, ILabelProvider labelProvider) {
        ChooseElementDialog dialog = new ChooseElementDialog(parentShell, elements, labelProvider, null);
        dialog.setDialogTitle(dialogTitle);
        dialog.setDescriptionLabel(HyadesUIPlugin.getString("LBL_DESC"));
        int ret = dialog.open();
        dialog.dispose();
        if (ret == 1) {
            return null;
        }
        return dialog.getSelection();
    }

    public void dispose() {
        this.contentProvider = null;
        this.labelProvider = null;
        this.initialSelection = null;
        this.chooseElementComposite.removeSelectionChangedListener(this);
        this.chooseElementComposite.removeDoubleClickListener(this);
        if (!this.chooseElementComposite.isDisposed()) {
            this.chooseElementComposite.dispose();
        }
        this.chooseElementComposite = null;
    }

    public void setInitialSelection(Object selection) {
        this.initialSelection = selection;
    }

    public void setDescriptionLabel(String label) {
        this.descriptionLabel = label;
    }

    public void setSelectionWidgetLabel(String label) {
        if (this.chooseElementComposite != null) {
            this.chooseElementComposite.setStructuredViewerLabel(label);
        } else {
            this.selectionWidgetLabel = label;
        }
    }

    public void setDialogTitle(String newTitle) {
        if (this.getShell() == null) {
            this.dialogTitle = newTitle;
        } else {
            this.getShell().setText(newTitle);
        }
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.contentProvider = contentProvider != null ? contentProvider : new ArrayContentProvider();
    }

    public Object getSelection() {
        return this.selection;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.chooseElementComposite.setContentProvider(this.contentProvider);
        this.chooseElementComposite.setInput(this.elements);
        if (this.initialSelection != null) {
            this.chooseElementComposite.setSelection((ISelection)new StructuredSelection(this.initialSelection), true, true);
        } else {
            this.chooseElementComposite.setSelection(0, true);
        }
        if (this.chooseElementComposite.getSelection().isEmpty()) {
            this.getButton(0).setEnabled(false);
        }
        this.chooseElementComposite.getControl().setFocus();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite superComposite = (Composite)super.createDialogArea(parent);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 300;
        gridData.widthHint = 300;
        superComposite.setLayoutData((Object)gridData);
        this.chooseElementComposite = new ChooseElementComposite(superComposite, 0);
        this.chooseElementComposite.setLayoutData(GridDataUtil.createFill());
        this.chooseElementComposite.createContents(this.labelProvider);
        this.chooseElementComposite.addSelectionChangedListener(this);
        this.chooseElementComposite.addDoubleClickListener(this);
        if (this.descriptionLabel == null) {
            this.descriptionLabel = HyadesUIPlugin.getString("LBL_DESC");
        }
        this.chooseElementComposite.setDescriptionLabel(this.descriptionLabel);
        if (this.selectionWidgetLabel != null) {
            this.chooseElementComposite.setStructuredViewerLabel(this.selectionWidgetLabel);
        }
        if (this.dialogTitle != null) {
            this.setDialogTitle(this.dialogTitle);
        }
        return superComposite;
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.chooseElementComposite.fired((EventObject)event)) {
            this.selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            this.okPressed();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.chooseElementComposite.fired((EventObject)event)) {
            this.getButton(0).setEnabled(true);
            this.selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
        }
    }
}

