/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.control;

import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DatapoolTableUtil {
    private static final String TAG_DATA = "data";
    private static final String TAG_RECORD = "record";
    private static final String TAG_VARIABLE = "variable";
    private static final String TAG_VARIABLE_INDEX = "variableIndex";
    private static final String TAG_EQUIVALENCE_CLASS = "equivalenceClass";
    private DatapoolTable dpTable = null;
    private Table table = null;

    public DatapoolTableUtil(DatapoolTable table) {
        this.dpTable = table;
        this.table = (Table)this.dpTable.getViewer().getControl();
    }

    public int getColumnCount() {
        int counter = 0;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tableColumn = this.table.getColumn(i);
            if (tableColumn.getWidth() == 0) continue;
            ++counter;
        }
        return counter;
    }

    public void insertColumn(TableColumn tableColumn, int insertionIndex) {
        int sourceIndex = this.findColumnIndex(tableColumn);
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            TableItem tableItem = this.table.getItem(i);
            IDatapoolCell[] rowData = (IDatapoolCell[])tableItem.getData(TAG_DATA);
            IDatapoolCell[] newRowData = new IDatapoolCell[this.table.getColumnCount() - 1];
            String[] newRowContext = new String[this.table.getColumnCount()];
            newRowContext[0] = tableItem.getText(0);
            for (int j = 0; j < newRowData.length; ++j) {
                if (j < insertionIndex) {
                    newRowData[j] = rowData[j];
                    newRowContext[j + 1] = tableItem.getText(j + 1);
                }
                if (j > insertionIndex) {
                    try {
                        newRowData[j] = rowData[j - 1];
                        newRowContext[j] = tableItem.getText(j);
                    }
                    catch (IndexOutOfBoundsException e) {
                        // empty catch block
                    }
                }
                if (j != insertionIndex) continue;
                IDatapoolRecord record = (IDatapoolRecord)tableItem.getData(TAG_RECORD);
                newRowData[j] = (IDatapoolCell)record.getCell(j);
            }
            tableItem.setData(TAG_DATA, (Object)newRowData);
            tableItem.setText(newRowContext);
        }
        if (sourceIndex >= 0) {
            if (sourceIndex != insertionIndex + 1) {
                this.moveColumn(sourceIndex, insertionIndex + 1);
                TableColumn sourceColumn = this.table.getColumn(sourceIndex);
                TableColumn insertedColumn = this.table.getColumn(insertionIndex + 1);
                sourceColumn.setWidth(100);
                sourceColumn.setResizable(true);
                insertedColumn.setWidth(100);
                insertedColumn.setResizable(true);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void deleteColumn(int columnIndex) {
        TableColumn tableColumn = null;
        if (columnIndex + 1 == this.getColumnCount() || columnIndex == 0) {
            tableColumn = this.table.getColumn(columnIndex);
        } else {
            this.moveColumn(columnIndex, this.getColumnCount() - 1);
            tableColumn = this.table.getColumn(this.getColumnCount() - 1);
        }
        if (tableColumn != null) {
            tableColumn.setText(new String());
            int movedColumnIndex = this.findColumnIndex(tableColumn);
            for (int i = 0; i < this.table.getItemCount(); ++i) {
                TableItem tableItem = this.table.getItem(i);
                IDatapoolCell[] rowData = (IDatapoolCell[])tableItem.getData(TAG_DATA);
                rowData[movedColumnIndex - 1] = null;
                tableItem.setText(movedColumnIndex, new String());
            }
            tableColumn.removeControlListener(this.dpTable.resizeColumnListener);
            tableColumn.removeSelectionListener(this.dpTable.headerListener);
            try {
                tableColumn.setWidth(0);
            }
            catch (Exception e) {
                // empty catch block
            }
            tableColumn.setResizable(false);
        }
    }

    private int findColumnIndex(TableColumn column) {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if (!this.table.getColumn(i).equals(column)) continue;
            return i;
        }
        return -1;
    }

    private void replaceColumn(int sourceColumnIndex, int targetColumnIndex) {
        TableColumn sourceColumn = this.table.getColumn(sourceColumnIndex);
        String sourceName = sourceColumn.getText();
        IDatapoolVariable sourceVariable = (IDatapoolVariable)sourceColumn.getData(TAG_VARIABLE);
        TableColumn targetColumn = this.table.getColumn(targetColumnIndex);
        targetColumn.setText(sourceName);
        targetColumn.setData(TAG_VARIABLE, (Object)sourceVariable);
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            IDatapoolCell sourceCell;
            TableItem tableItem = this.table.getItem(i);
            IDatapoolCell[] rowData = (IDatapoolCell[])tableItem.getData(TAG_DATA);
            String[] newRowContext = new String[this.table.getColumnCount()];
            newRowContext[0] = tableItem.getText(0);
            for (int j = 0; j < rowData.length; ++j) {
                newRowContext[j + 1] = tableItem.getText(j);
            }
            newRowContext[targetColumnIndex + 1] = tableItem.getText(sourceColumnIndex + 1);
            rowData[targetColumnIndex] = sourceCell = rowData[sourceColumnIndex];
            tableItem.setData(TAG_DATA, (Object)rowData);
            tableItem.setText(newRowContext);
        }
    }

    public void swapColumn(int sourceColumnIndex, int targetColumnIndex) {
        TableColumn sourceColumn = this.table.getColumn(sourceColumnIndex);
        String sourceName = sourceColumn.getText();
        IDatapoolVariable sourceVariable = (IDatapoolVariable)sourceColumn.getData(TAG_VARIABLE);
        TableColumn targetColumn = this.table.getColumn(targetColumnIndex);
        String targetName = targetColumn.getText();
        IDatapoolVariable targetVariable = (IDatapoolVariable)targetColumn.getData(TAG_VARIABLE);
        sourceColumn.setText(targetName);
        sourceColumn.setData(TAG_VARIABLE, (Object)targetVariable);
        targetColumn.setText(sourceName);
        targetColumn.setData(TAG_VARIABLE, (Object)sourceVariable);
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            IDatapoolCell targetCell;
            TableItem tableItem = this.table.getItem(i);
            IDatapoolCell[] rowData = (IDatapoolCell[])tableItem.getData(TAG_DATA);
            String[] newRowContext = new String[this.table.getColumnCount()];
            newRowContext[0] = tableItem.getText(0);
            for (int j = 0; j < rowData.length; ++j) {
                newRowContext[j + 1] = tableItem.getText(j + 1);
            }
            newRowContext[sourceColumnIndex] = tableItem.getText(targetColumnIndex);
            newRowContext[targetColumnIndex] = tableItem.getText(sourceColumnIndex);
            IDatapoolCell sourceCell = rowData[sourceColumnIndex - 1];
            rowData[sourceColumnIndex - 1] = targetCell = rowData[targetColumnIndex - 1];
            rowData[targetColumnIndex - 1] = sourceCell;
            tableItem.setData(TAG_DATA, (Object)rowData);
            tableItem.setText(newRowContext);
        }
    }

    public void moveColumn(int sourceColumnIndex, int targetColumnIndex) {
        int numToSwap = 0;
        numToSwap = sourceColumnIndex < targetColumnIndex ? targetColumnIndex - sourceColumnIndex : sourceColumnIndex - targetColumnIndex;
        TableColumn sourceColumn = this.table.getColumn(sourceColumnIndex);
        String sourceName = sourceColumn.getText();
        IDatapoolVariable sourceVariable = (IDatapoolVariable)sourceColumn.getData(TAG_VARIABLE);
        for (int i = 0; i < numToSwap; ++i) {
            TableColumn shiftColumn = null;
            TableColumn targetColumn = null;
            if (sourceColumnIndex < targetColumnIndex) {
                shiftColumn = this.table.getColumn(sourceColumnIndex + i + 1);
                targetColumn = this.table.getColumn(sourceColumnIndex + i);
            } else {
                shiftColumn = this.table.getColumn(sourceColumnIndex - i - 1);
                targetColumn = this.table.getColumn(sourceColumnIndex - i);
            }
            String shiftName = shiftColumn.getText();
            IDatapoolVariable shiftVariable = (IDatapoolVariable)shiftColumn.getData(TAG_VARIABLE);
            String targetName = targetColumn.getText();
            IDatapoolVariable targetVariable = (IDatapoolVariable)targetColumn.getData(TAG_VARIABLE);
            targetColumn.setText(shiftName);
            targetColumn.setData(TAG_VARIABLE, (Object)shiftVariable);
        }
        TableColumn targetColumn = this.table.getColumn(targetColumnIndex);
        targetColumn.setText(sourceName);
        targetColumn.setData(TAG_VARIABLE, (Object)sourceVariable);
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            TableItem tableItem = this.table.getItem(i);
            IDatapoolCell[] rowData = (IDatapoolCell[])tableItem.getData(TAG_DATA);
            IDatapoolCell sourceCell = rowData[sourceColumnIndex - 1];
            String sourceText = tableItem.getText(sourceColumnIndex);
            for (int j = 0; j < numToSwap; ++j) {
                String shiftText;
                IDatapoolCell shiftCell;
                if (sourceColumnIndex < targetColumnIndex) {
                    shiftCell = rowData[sourceColumnIndex + j];
                    shiftText = tableItem.getText(sourceColumnIndex + j + 1);
                    rowData[sourceColumnIndex + j - 1] = shiftCell;
                    tableItem.setText(sourceColumnIndex + j, shiftText);
                    continue;
                }
                shiftCell = rowData[sourceColumnIndex - j - 2];
                shiftText = tableItem.getText(sourceColumnIndex - j - 1);
                rowData[sourceColumnIndex - j - 1] = shiftCell;
                tableItem.setText(sourceColumnIndex - j, shiftText);
            }
            tableItem.setText(targetColumnIndex, sourceText);
            rowData[targetColumnIndex - 1] = sourceCell;
            tableItem.setData(TAG_DATA, (Object)rowData);
        }
    }

    public void swapRow(int sourceRowIndex, int targetRowIndex) {
        TableItem sourceItem = this.table.getItem(sourceRowIndex);
        String[] sourceRowContext = new String[this.table.getColumnCount()];
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            sourceRowContext[i] = sourceItem.getText(i);
        }
        IDatapoolCell[] sourceRowData = (IDatapoolCell[])sourceItem.getData(TAG_DATA);
        IDatapoolRecord sourceRecord = (IDatapoolRecord)sourceItem.getData(TAG_RECORD);
        IDatapoolEquivalenceClass sourceEquivalenceClass = (IDatapoolEquivalenceClass)sourceItem.getData(TAG_EQUIVALENCE_CLASS);
        TableItem targetItem = this.table.getItem(targetRowIndex);
        String[] targetRowContext = new String[this.table.getColumnCount()];
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            targetRowContext[i] = targetItem.getText(i);
        }
        IDatapoolCell[] targetRowData = (IDatapoolCell[])targetItem.getData(TAG_DATA);
        IDatapoolRecord targetRecord = (IDatapoolRecord)targetItem.getData(TAG_RECORD);
        IDatapoolEquivalenceClass targetEquivalenceClass = (IDatapoolEquivalenceClass)targetItem.getData(TAG_EQUIVALENCE_CLASS);
        sourceItem.setText(targetRowContext);
        sourceItem.setData(TAG_DATA, (Object)targetRowData);
        sourceItem.setData(TAG_RECORD, (Object)targetRecord);
        sourceItem.setData(TAG_EQUIVALENCE_CLASS, (Object)targetEquivalenceClass);
        targetItem.setText(sourceRowContext);
        targetItem.setData(TAG_DATA, (Object)sourceRowData);
        targetItem.setData(TAG_RECORD, (Object)sourceRecord);
        targetItem.setData(TAG_EQUIVALENCE_CLASS, (Object)sourceEquivalenceClass);
    }

    public void moveRow(int sourceRowIndex, int targetRowIndex) {
        int numToSwap = 0;
        numToSwap = sourceRowIndex < targetRowIndex ? targetRowIndex - sourceRowIndex : sourceRowIndex - targetRowIndex;
        TableItem sourceItem = this.table.getItem(sourceRowIndex);
        String[] sourceRowContext = new String[this.table.getColumnCount()];
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            sourceRowContext[i] = sourceItem.getText(i);
        }
        IDatapoolCell[] sourceRowData = (IDatapoolCell[])sourceItem.getData(TAG_DATA);
        IDatapoolRecord sourceRecord = (IDatapoolRecord)sourceItem.getData(TAG_RECORD);
        IDatapoolEquivalenceClass sourceEquivalenceClass = (IDatapoolEquivalenceClass)sourceItem.getData(TAG_EQUIVALENCE_CLASS);
        for (int i = 0; i < numToSwap; ++i) {
            TableItem shiftItem = null;
            TableItem targetItem = null;
            if (sourceRowIndex < targetRowIndex) {
                shiftItem = this.table.getItem(sourceRowIndex + i + 1);
                targetItem = this.table.getItem(sourceRowIndex + i);
            } else {
                shiftItem = this.table.getItem(sourceRowIndex - i - 1);
                targetItem = this.table.getItem(sourceRowIndex - i);
            }
            String[] shiftRowContext = new String[this.table.getColumnCount()];
            for (int j = 0; j < this.table.getColumnCount(); ++j) {
                shiftRowContext[j] = shiftItem.getText(j);
            }
            IDatapoolCell[] shiftRowData = (IDatapoolCell[])shiftItem.getData(TAG_DATA);
            IDatapoolRecord shiftRecord = (IDatapoolRecord)shiftItem.getData(TAG_RECORD);
            IDatapoolEquivalenceClass shiftEquivalenceClass = (IDatapoolEquivalenceClass)shiftItem.getData(TAG_EQUIVALENCE_CLASS);
            targetItem.setText(shiftRowContext);
            targetItem.setData(TAG_DATA, (Object)shiftRowData);
            targetItem.setData(TAG_RECORD, (Object)shiftRecord);
            targetItem.setData(TAG_EQUIVALENCE_CLASS, (Object)shiftEquivalenceClass);
        }
        TableItem targetItem = this.table.getItem(targetRowIndex);
        targetItem.setText(sourceRowContext);
        targetItem.setData(TAG_DATA, (Object)sourceRowData);
        targetItem.setData(TAG_RECORD, (Object)sourceRecord);
        targetItem.setData(TAG_EQUIVALENCE_CLASS, (Object)sourceEquivalenceClass);
    }
}

