/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.FilterCriteria;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.SearchFilterDialog;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.help.WorkbenchHelp;

public class FilterListDialog
extends Dialog {
    private IViewPart viewer = null;
    private ISDFilterProvider provider = null;
    private ArrayList filters;
    private Button add;
    private Button remove;
    private Button edit;
    private Table table;

    private void addCriteria(Criteria c, boolean checked) {
        CriteriaTableItem cti = new CriteriaTableItem(this.table, checked);
        cti.setCriteria(c);
    }

    private void replaceSelectedCriteria(Criteria new_) {
        CriteriaTableItem cti = (CriteriaTableItem)this.table.getSelection()[0].getData();
        cti.setCriteria(new_);
    }

    private void handleTableSelectionCount() {
        int count = this.table.getSelectionCount();
        this.edit.setEnabled(count == 1);
        this.remove.setEnabled(count > 0);
    }

    public Control createDialogArea(Composite parent) {
        Group ret = new Group(parent, 0);
        ret.setText(SDViewerPlugin.getResourceString("FILTER_LIST_GROUP_TITLE"));
        WorkbenchHelp.setHelp((Control)ret, (String)(SDViewerPlugin.getId() + ".UML2SDFILTER"));
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.pack = true;
        rowLayout.justify = false;
        rowLayout.type = 256;
        rowLayout.marginLeft = 4;
        rowLayout.marginTop = 4;
        rowLayout.marginRight = 4;
        rowLayout.marginBottom = 4;
        rowLayout.spacing = 8;
        ret.setLayout((Layout)rowLayout);
        this.table = new Table((Composite)ret, 34);
        this.table.setLayoutData((Object)new RowData(180, 84));
        this.table.setHeaderVisible(false);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Criteria c;
                int count = FilterListDialog.this.table.getSelectionCount();
                if (count == 1 && (c = FilterListDialog.this.openFilterDialog(((CriteriaTableItem)FilterListDialog.this.table.getSelection()[0].getData()).getCriteria(), SDViewerPlugin.getResourceString("FILTER_LIST_UPDATE"))) != null) {
                    FilterListDialog.this.replaceSelectedCriteria(c);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                FilterListDialog.this.handleTableSelectionCount();
            }
        });
        if (this.filters != null) {
            Iterator i = this.filters.iterator();
            while (i.hasNext()) {
                FilterCriteria tf = (FilterCriteria)i.next();
                this.addCriteria(tf.getCriteria(), tf.isActive());
            }
        }
        Composite commands = new Composite((Composite)ret, 0);
        RowLayout rowLayoutCommands = new RowLayout();
        rowLayoutCommands.wrap = false;
        rowLayoutCommands.pack = false;
        rowLayoutCommands.justify = true;
        rowLayoutCommands.type = 512;
        rowLayoutCommands.marginLeft = 0;
        rowLayoutCommands.marginTop = 4;
        rowLayoutCommands.marginRight = 0;
        rowLayoutCommands.marginBottom = 4;
        rowLayoutCommands.spacing = 8;
        commands.setLayout((Layout)rowLayoutCommands);
        this.add = new Button(commands, 0);
        this.add.setText(SDViewerPlugin.getResourceString("FILTER_LIST_ADD"));
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Criteria init = new Criteria();
                Criteria c = FilterListDialog.this.openFilterDialog(init, SDViewerPlugin.getResourceString("FILTER_LIST_CREATE"));
                if (c != null) {
                    FilterListDialog.this.addCriteria(c, true);
                }
            }
        });
        this.edit = new Button(commands, 0);
        this.edit.setText(SDViewerPlugin.getResourceString("FILTER_LIST_EDIT"));
        this.edit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Criteria c = FilterListDialog.this.openFilterDialog(((CriteriaTableItem)FilterListDialog.this.table.getSelection()[0].getData()).getCriteria(), SDViewerPlugin.getResourceString("FILTER_LIST_UPDATE"));
                if (c != null) {
                    FilterListDialog.this.replaceSelectedCriteria(c);
                }
            }
        });
        this.edit.setEnabled(false);
        this.remove = new Button(commands, 0);
        this.remove.setText(SDViewerPlugin.getResourceString("FILTER_LIST_REMOVE"));
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FilterListDialog.this.table.remove(FilterListDialog.this.table.getSelectionIndices());
                FilterListDialog.this.handleTableSelectionCount();
            }
        });
        this.remove.setEnabled(false);
        this.getShell().setText(SDViewerPlugin.getResourceString("FILTER_LIST_TITLE"));
        return ret;
    }

    public FilterListDialog(IViewPart view_, ISDFilterProvider loader_) {
        super(view_.getSite().getShell());
        this.viewer = view_;
        this.provider = loader_;
        this.filters = this.provider.getCurrentFilters();
        this.setShellStyle(67680);
    }

    private Criteria openFilterDialog(Criteria criteria, String action) {
        SearchFilterDialog filter = new SearchFilterDialog((SDView)this.viewer, this.provider, true, 65536);
        filter.setCriteria(criteria);
        filter.setOkText(action);
        filter.setTitle(SDViewerPlugin.getResourceString("FILTER_LIST_CRITERIA_DIALOG"));
        filter.open();
        return filter.getCriteria();
    }

    public int open() {
        this.create();
        this.getShell().pack();
        this.getShell().setLocation(this.getShell().getDisplay().getCursorLocation());
        return super.open();
    }

    public void okPressed() {
        this.filters = this.table.getItemCount() > 0 ? new ArrayList() : null;
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            TableItem item = this.table.getItem(i);
            this.filters.add(new FilterCriteria(((CriteriaTableItem)item.getData()).getCriteria(), item.getChecked()));
        }
        super.close();
        this.provider.filter(this.filters);
    }

    public void setFilters(ArrayList filters_) {
        this.filters = filters_;
    }

    public ArrayList getFilters() {
        return this.filters;
    }

    private class CriteriaTableItem {
        private Criteria criteria;
        private TableItem tableItem;

        public CriteriaTableItem(Table parent, boolean checked_) {
            this.tableItem = new TableItem(parent, 0);
            this.tableItem.setData((Object)this);
            this.tableItem.setChecked(checked_);
        }

        public CriteriaTableItem(Table parent, boolean checked_, int index) {
            this.tableItem = new TableItem(parent, 0, index);
            this.tableItem.setChecked(checked_);
        }

        public void setCriteria(Criteria criteria_) {
            this.criteria = criteria_;
            this.tableItem.setText(this.criteria.getExpression());
        }

        public Criteria getCriteria() {
            return this.criteria;
        }
    }
}

