/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import java.text.MessageFormat;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DrawableToolTip
implements PaintListener {
    private Composite parent = null;
    private Shell toolTipShell = null;
    private double min;
    private double max;
    private double currentValue;
    private static int H_MARGIN = 10;
    private static int V_MARGIN = 10;
    private static int TEXT_SCALE_MARGIN = 20;
    private static int SCALE_LENGTH = 100;
    private String unitName = null;
    protected String msg;
    private Color[] col;

    public DrawableToolTip(Composite _parent) {
        this.parent = _parent;
        this.toolTipShell = new Shell(this.parent.getShell(), 16384);
        this.toolTipShell.setLayout((Layout)new RowLayout());
        this.toolTipShell.setBackground(Display.getDefault().getSystemColor(29));
        this.toolTipShell.addPaintListener((PaintListener)this);
        this.toolTipShell.setSize(200, 50);
        this.col = new Color[10];
        this.col[0] = new Color((Device)Display.getDefault(), 255, 229, 229);
        this.col[1] = new Color((Device)Display.getDefault(), 255, 204, 204);
        this.col[2] = new Color((Device)Display.getDefault(), 255, 178, 178);
        this.col[3] = new Color((Device)Display.getDefault(), 255, 153, 153);
        this.col[4] = new Color((Device)Display.getDefault(), 255, 127, 127);
        this.col[5] = new Color((Device)Display.getDefault(), 255, 102, 102);
        this.col[6] = new Color((Device)Display.getDefault(), 255, 76, 76);
        this.col[7] = new Color((Device)Display.getDefault(), 255, 51, 51);
        this.col[8] = new Color((Device)Display.getDefault(), 255, 25, 25);
        this.col[9] = new Color((Device)Display.getDefault(), 255, 0, 0);
    }

    public void showToolTip(double _value, double _min, double _max, String unit) {
        this.min = _min;
        this.max = _max;
        this.currentValue = _value;
        this.unitName = unit;
        int w = this.toolTipShell.getBounds().width;
        int h = this.toolTipShell.getBounds().height;
        Point hr = Display.getDefault().getCursorLocation();
        this.toolTipShell.setBounds(hr.x, hr.y + 26, w, h);
        this.toolTipShell.setVisible(true);
    }

    public void hideToolTip() {
        this.toolTipShell.setVisible(false);
    }

    public void paintControl(PaintEvent event) {
        this.msg = null;
        Point size = event.gc.textExtent(Double.toString(this.currentValue));
        if (size.x < SCALE_LENGTH) {
            size.x = SCALE_LENGTH;
        }
        this.msg = DrawableToolTip.timeToString(this.currentValue);
        event.gc.drawText(this.msg, H_MARGIN, V_MARGIN, true);
        event.gc.drawLine(H_MARGIN, V_MARGIN + TEXT_SCALE_MARGIN + size.y, H_MARGIN + SCALE_LENGTH, V_MARGIN + TEXT_SCALE_MARGIN + size.y);
        int step = SCALE_LENGTH / 10;
        double gr = (this.max - this.min) / 10.0;
        double delta = Math.abs(this.currentValue + Math.abs(this.min));
        int colIndex = 0;
        if (delta <= Math.abs(this.max + Math.abs(this.min))) {
            colIndex = Math.round((float)(delta / gr));
            for (int i = 0; i <= 10; ++i) {
                if (i < 10) {
                    event.gc.setBackground(this.col[i]);
                }
                if (i < colIndex && i < 10) {
                    event.gc.fillRectangle(H_MARGIN + i * step, V_MARGIN + TEXT_SCALE_MARGIN + size.y - 5, step, 11);
                }
                if (i == 0) {
                    event.gc.drawText(SDViewerPlugin.getResourceString("MIN_LABEL"), H_MARGIN, size.y + 2 * V_MARGIN + TEXT_SCALE_MARGIN, true);
                }
                if (i == 0) {
                    int len = event.gc.textExtent((String)SDViewerPlugin.getResourceString((String)"MAX_LABEL")).x;
                    event.gc.drawText(SDViewerPlugin.getResourceString("MAX_LABEL"), H_MARGIN + SCALE_LENGTH - len + 1, size.y + 2 * V_MARGIN + TEXT_SCALE_MARGIN, true);
                }
                int lineWidth = 10;
                if (i == 0 || i == 10) {
                    lineWidth = 14;
                }
                event.gc.drawLine(H_MARGIN + i * step, V_MARGIN + TEXT_SCALE_MARGIN + size.y - lineWidth / 2, H_MARGIN + i * step, V_MARGIN + TEXT_SCALE_MARGIN + size.y + lineWidth / 2);
            }
        }
        this.toolTipShell.setSize(size.x + 2 * H_MARGIN + 2, 2 * size.y + 3 * V_MARGIN + TEXT_SCALE_MARGIN);
    }

    public String getText() {
        return this.msg;
    }

    public static String timeToString(double time) {
        String ret;
        if (time > 86400.0) {
            int days = (int)(time / 86400.0);
            int hours = (int)(time % 86400.0) / 3600;
            ret = days > 1 ? MessageFormat.format(SDViewerPlugin.getResourceString("STR_DAYS_HOURS"), new Integer(days), new Integer(hours)) : MessageFormat.format(SDViewerPlugin.getResourceString("STR_DAY_HOURS"), new Integer(days), new Integer(hours));
        } else if (time > 3600.0) {
            int hours = (int)(time / 3600.0);
            int mins = (int)(time % 3600.0) / 60;
            ret = MessageFormat.format(SDViewerPlugin.getResourceString("STR_HOURS_MINUTES"), new Integer(hours), new Integer(mins));
        } else if (time > 60.0) {
            int mins = (int)(time / 60.0);
            int s = (int)(time % 60.0);
            ret = MessageFormat.format(SDViewerPlugin.getResourceString("STR_MINUTES_SECONDS"), new Integer(mins), new Integer(s));
        } else {
            int s = (int)time;
            double us = (time - (double)s) * 1000000.0;
            ret = MessageFormat.format(SDViewerPlugin.getResourceString("STR_SECONDS_MICROSECONDS"), new Integer(s), new Double(us));
        }
        return ret;
    }

    public void dispose() {
        for (int i = 0; i < this.col.length; ++i) {
            this.col[i].dispose();
        }
    }
}

