/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness.util;

import java.util.HashMap;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.harness.IExecutableObjectAdapter;
import org.eclipse.hyades.execution.harness.IExecutionDeploymentAdapter;
import org.eclipse.hyades.execution.harness.IExecutionEnvironmentAdapter;
import org.eclipse.hyades.execution.harness.util.ISystemUtility;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;

public class ExecutionAdapterUtilities {
    public static Object getAdapterInstance(String executionComponentType, String testType, boolean bStandalone, HashMap testTypemap, ISystemUtility systemUtility) throws ClassNotFoundException {
        Object temp = testTypemap.get(executionComponentType);
        if (temp != null && temp instanceof HashMap) {
            HashMap execCompMap = (HashMap)temp;
            temp = execCompMap.get(testType);
            try {
                if (bStandalone) {
                    if (temp != null && temp instanceof String) {
                        return Class.forName((String)temp).newInstance();
                    }
                } else if (temp != null && temp instanceof ConfigurationElement) {
                    return ((ConfigurationElement)temp).createExecutableExtension("class");
                }
            }
            catch (Exception accessExc) {
                // empty catch block
            }
        }
        String msg = systemUtility.getString("EXEC_NOT_FOUND_ERR_");
        msg = StringUtil.change((String)msg, (String)"%1", (String)executionComponentType);
        msg = StringUtil.change((String)msg, (String)"%2", (String)testType);
        throw new ClassNotFoundException(msg);
    }

    public static boolean adaptExecutableObject(IExecutableObject executableObject, CFGClass rootResource, IImplementor theImplementor, boolean bStandalone, String testType, TPFDeployment deployment, StringBuffer bufError, ISystemUtility systemUtility, HashMap testTypeMap) {
        IExecutableObjectAdapter execObjAdapter = null;
        try {
            execObjAdapter = (IExecutableObjectAdapter)ExecutionAdapterUtilities.getAdapterInstance("EXECUTABLE_OBJECT_ADAPTER", testType, bStandalone, testTypeMap, systemUtility);
        }
        catch (Exception accessExc) {
            systemUtility.logError(accessExc);
            bufError.append(StringUtil.change((String)systemUtility.getString("EXEC_ENV_ERR_"), (String)"%1", (String)testType));
            return false;
        }
        if (execObjAdapter != null) {
            execObjAdapter.setupExecutableObject(executableObject, rootResource, theImplementor, deployment);
        }
        if (executableObject instanceof JavaProcessExecutableObjectStub) {
            JavaProcessExecutableObjectStub stub = (JavaProcessExecutableObjectStub)executableObject;
            String args = stub.getArgs();
            args = args + " org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor";
            stub.setArgs(args);
        }
        return true;
    }

    public static boolean adaptExecutionEnvironment(IExecutionEnvironment exeEnvironment, CFGClass rootResource, IImplementor theImplementor, boolean bStandalone, String testType, TPFDeployment deployment, StringBuffer bufError, ISystemUtility systemUtility, HashMap testTypeMap) {
        IExecutionEnvironmentAdapter envAdapter = null;
        try {
            envAdapter = (IExecutionEnvironmentAdapter)ExecutionAdapterUtilities.getAdapterInstance("EXECUTION_ENVIRONMENT_ADAPTER", testType, bStandalone, testTypeMap, systemUtility);
        }
        catch (Exception accessExc) {
            systemUtility.logError(accessExc);
            bufError.append(StringUtil.change((String)systemUtility.getString("EXEC_ENV_ERR_"), (String)"%1", (String)testType));
            return false;
        }
        if (envAdapter != null) {
            envAdapter.setupExecutionEnvironment(exeEnvironment, rootResource, theImplementor, deployment);
        }
        return true;
    }

    public static boolean adaptExecutionDeployment(INode node, TPFDeployment deployment, boolean bStandalone, String testType, StringBuffer bufError, ISystemUtility systemUtility, HashMap testTypeMap) {
        IExecutionDeploymentAdapter deployAdapter = null;
        try {
            deployAdapter = (IExecutionDeploymentAdapter)ExecutionAdapterUtilities.getAdapterInstance("EXECUTION_DEPLOYMENT_ADAPTER", testType, bStandalone, testTypeMap, systemUtility);
        }
        catch (Exception accessExc) {
            systemUtility.logError(accessExc);
            return false;
        }
        if (deployAdapter != null) {
            deployAdapter.deployTestAssets(node, deployment, bStandalone);
        }
        return true;
    }

    public static boolean adaptExecutionDeploymentCleanup(INode node, TPFDeployment deployment, boolean bStandalone, String testType, StringBuffer bufError, ISystemUtility systemUtility, HashMap testTypeMap) {
        IExecutionDeploymentAdapter deployAdapter = null;
        try {
            deployAdapter = (IExecutionDeploymentAdapter)ExecutionAdapterUtilities.getAdapterInstance("EXECUTION_DEPLOYMENT_ADAPTER", testType, bStandalone, testTypeMap, systemUtility);
        }
        catch (Exception accessExc) {
            systemUtility.logError(accessExc);
            return false;
        }
        if (deployAdapter != null) {
            deployAdapter.cleanUpTestAssets(node, deployment, bStandalone);
        }
        return true;
    }
}

