/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.perfmon.PerfmonModuleTrace;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class PerfmonLauncher
implements ILaunchConfigurationDelegate {
    private void openProfilingView() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
    }

    public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().syncExec((Runnable)new StatConRun(conf, monitor));
    }

    private Resource createResource(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(uri, false);
        if (resource == null) {
            return resourceSet.createResource(uri);
        }
        return resource;
    }

    class StatConRun
    implements Runnable {
        IProgressMonitor monitor;
        ILaunchConfiguration conf;

        public StatConRun(ILaunchConfiguration conf, IProgressMonitor monitor) {
            this.monitor = monitor;
            this.conf = conf;
        }

        public void run() {
            try {
                this.monitor.setTaskName(PerfmonPlugin.getString("PROGRESS_GETCONFIGS"));
                Path smodel_path = new Path(this.conf.getAttribute("smodel_container", ""));
                PerfmonPlugin.DBG.info("PERFMON SMODEL PATH = " + smodel_path);
                String spath = smodel_path.toString().replaceFirst("platform:/resource/", "");
                URI smodel_uri = URI.createPlatformResourceURI((String)spath);
                PerfmonPlugin.DBG.info("PERFMON plat SMODEL URI = " + smodel_uri);
                String rac_host = this.conf.getAttribute("host_rac", "");
                String reg_host = this.conf.getAttribute("host_reg", "");
                if (!this.conf.getAttribute("hosts_same", false)) {
                    reg_host = rac_host;
                }
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                String project = smodel_uri.toString().replaceFirst("platform:/resource/", "");
                PerfmonPlugin.DBG.info("profiling project = " + project);
                if (project.indexOf(47) != -1) {
                    project = project.substring(0, project.indexOf(47) + 1);
                }
                PerfmonPlugin.DBG.info("profiling project = " + project);
                IProject pproject = workspaceRoot.getProject(project);
                if (!pproject.exists()) {
                    pproject.create(null);
                    PerfmonPlugin.DBG.info("created project OK");
                }
                pproject.open(null);
                try {
                    String folderpath = smodel_uri.toString().replaceFirst("platform:/resource/", "/");
                    PerfmonPlugin.DBG.info("profiling project Folder path = " + folderpath);
                    Path path = new Path(folderpath);
                    PerfmonPlugin.DBG.info("profiling project IPath = " + path);
                    if (path.segmentCount() > 1) {
                        PerfmonPlugin.DBG.info("profiling container is subfolder within project - creating if necessary now");
                        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
                        if (!folder.exists()) {
                            folder.create(true, true, null);
                            PerfmonPlugin.DBG.info("created subfolder ok");
                        }
                    } else {
                        PerfmonPlugin.DBG.info("profiling container is top level project");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String tmonitor = this.conf.getAttribute("monitor", PerfmonPlugin.getString("DEFAULT_MONITOR"));
                URI monitor_uri = null;
                if (tmonitor.indexOf(47) != -1 || tmonitor.indexOf(92) != -1) {
                    if (!tmonitor.toLowerCase().endsWith(".trcmxmi")) {
                        tmonitor = tmonitor + ".trcmxmi";
                    }
                    monitor_uri = URI.createPlatformResourceURI((String)tmonitor);
                } else {
                    tmonitor = smodel_uri.toString() + "/" + tmonitor;
                    if (!tmonitor.toLowerCase().endsWith(".trcmxmi")) {
                        tmonitor = tmonitor + ".trcmxmi";
                    }
                    monitor_uri = URI.createURI((String)tmonitor);
                }
                PerfmonPlugin.DBG.info("MONITOR PATH = " + monitor_uri);
                IProgressMonitor pmonitor = Platform.getJobManager().createProgressGroup();
                pmonitor.beginTask(PerfmonPlugin.getString("PROGRESS_LAUNCHING"), -1);
                PerfmonLaunchJob job = new PerfmonLaunchJob(rac_host, reg_host, smodel_uri, monitor_uri);
                job.setProgressGroup(pmonitor, -1);
                job.schedule();
                PerfmonLauncher.this.openProfilingView();
            }
            catch (Throwable t) {
                PerfmonPlugin.DBG.logVisibleError(t, PerfmonPlugin.getString("ERROR_LAUNCH_VIEW"), true);
            }
        }
    }

    class PerfmonLaunchJob
    extends Job {
        String rac_host;
        String reg_host;
        URI smodel_uri;
        URI monitor_uri;

        public PerfmonLaunchJob(String rac_host, String reg_host, URI smodel_uri, URI monitor_uri) {
            super(PerfmonPlugin.getString("PROGRESS_LAUNCHING"));
            this.rac_host = rac_host;
            this.reg_host = reg_host;
            this.smodel_uri = smodel_uri;
            this.monitor_uri = monitor_uri;
        }

        public IStatus run(IProgressMonitor monitor) {
            PerfmonModuleTrace trace = new PerfmonModuleTrace(monitor, this.rac_host, this.reg_host, this.smodel_uri, this.monitor_uri);
            return new Status(0, "org.eclipse.hyades.perfmon", 0, "", null);
        }
    }
}

