/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.util.Messages;

public class TimeParser {
    private String format = null;
    private SimpleDateFormat formatter = null;

    private void setFormat(String _format) throws AdapterException {
        if (_format != null && !_format.equals(this.format)) {
            this.format = _format.trim();
            try {
                this.formatter = new SimpleDateFormat(this.format);
            }
            catch (IllegalArgumentException e) {
                throw new AdapterException(e);
            }
        }
    }

    public TimeParser(String timeFormat) throws AdapterException {
        this.setFormat(timeFormat);
    }

    public long parse(String strTime) throws AdapterException {
        long ret = 0L;
        try {
            Date dt;
            if (this.formatter != null && this.format != null && (dt = this.formatter.parse(strTime.trim())) != null) {
                ret = dt.getTime();
            }
        }
        catch (Exception ex) {
            throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Run_TimeParser_Exception_ERROR_", strTime.trim(), this.format), ex);
        }
        return ret;
    }
}

