/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;

public class PerftraceUtil {
    private static NumberFormat _decimalFormat = null;
    private static NumberFormat _percentFormat = null;
    private static ArrayList tmpList = new ArrayList();

    public static int getActiveInstances(EObject mofObject) {
        int inst = 0;
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                TRCProcess proces;
                if (((TRCAgentProxy)mofObject).getAgent() != null && (proces = (TRCProcess)((TRCAgentProxy)mofObject).getAgent().getProcess()) != null) {
                    inst = proces.getTotalInstances() - proces.getCollectedInstances();
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                for (int idx = 0; idx < agents.length; ++idx) {
                    TRCProcess proces;
                    if (((TRCAgentProxy)agents[idx]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[idx]).getAgent().getProcess()) == null) continue;
                    inst += proces.getTotalInstances() - proces.getCollectedInstances();
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                for (int idx = 0; idx < processes.length; ++idx) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    for (int i = 0; i < agents.length; ++i) {
                        TRCProcess proces;
                        if (((TRCAgentProxy)agents[i]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[i]).getAgent().getProcess()) == null) continue;
                        inst += proces.getTotalInstances() - proces.getCollectedInstances();
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                for (int k = 0; k < nodes.length; ++k) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    for (int idx = 0; idx < processes.length; ++idx) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        for (int i = 0; i < agents.length; ++i) {
                            TRCProcess proces;
                            if (((TRCAgentProxy)agents[i]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[i]).getAgent().getProcess()) == null) continue;
                            inst += proces.getTotalInstances() - proces.getCollectedInstances();
                        }
                    }
                }
            }
        }
        if (inst == 0) {
            inst = 1;
        }
        return inst;
    }

    public static long getActiveSize(EObject mofObject) {
        long size = 0L;
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                TRCProcess proces;
                if (((TRCAgentProxy)mofObject).getAgent() != null && (proces = (TRCProcess)((TRCAgentProxy)mofObject).getAgent().getProcess()) != null) {
                    size = proces.getTotalSize() - proces.getCollectedSize();
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                for (int idx = 0; idx < agents.length; ++idx) {
                    TRCProcess proces;
                    if (((TRCAgentProxy)agents[idx]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[idx]).getAgent().getProcess()) == null) continue;
                    size += (long)(proces.getTotalSize() - proces.getCollectedSize());
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                for (int idx = 0; idx < processes.length; ++idx) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    for (int i = 0; i < agents.length; ++i) {
                        TRCProcess proces;
                        if (((TRCAgentProxy)agents[i]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[i]).getAgent().getProcess()) == null) continue;
                        size += (long)(proces.getTotalSize() - proces.getCollectedSize());
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                for (int k = 0; k < nodes.length; ++k) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    for (int idx = 0; idx < processes.length; ++idx) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        for (int i = 0; i < agents.length; ++i) {
                            TRCProcess proces;
                            if (((TRCAgentProxy)agents[i]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[i]).getAgent().getProcess()) == null) continue;
                            size += (long)(proces.getTotalSize() - proces.getCollectedSize());
                        }
                    }
                }
            }
        }
        if (size == 0L) {
            size = 1L;
        }
        return size;
    }

    public static Object[] getAllClasses(EObject mofObject) {
        tmpList.clear();
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentClasses((TRCAgentProxy)mofObject, tmpList);
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                for (int idx = 0; idx < agents.length; ++idx) {
                    PerftraceUtil.getAgentClasses((TRCAgentProxy)agents[idx], tmpList);
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                for (int idx = 0; idx < processes.length; ++idx) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    for (int i = 0; i < agents.length; ++i) {
                        PerftraceUtil.getAgentClasses((TRCAgentProxy)agents[i], tmpList);
                    }
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                for (int k = 0; k < nodes.length; ++k) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    for (int idx = 0; idx < processes.length; ++idx) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        for (int i = 0; i < agents.length; ++i) {
                            PerftraceUtil.getAgentClasses((TRCAgentProxy)agents[i], tmpList);
                        }
                    }
                }
                return PerftraceUtil.getObjectArray();
            }
        }
        return PerftraceUtil.getObjectArray();
    }

    public static Object[] getAllGc(EObject mofObject) {
        tmpList.clear();
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentGc((TRCAgentProxy)mofObject, tmpList);
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                for (int idx = 0; idx < agents.length; ++idx) {
                    PerftraceUtil.getAgentGc((TRCAgentProxy)agents[idx], tmpList);
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                for (int idx = 0; idx < processes.length; ++idx) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    for (int i = 0; i < agents.length; ++i) {
                        PerftraceUtil.getAgentGc((TRCAgentProxy)agents[i], tmpList);
                    }
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                for (int k = 0; k < nodes.length; ++k) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    for (int idx = 0; idx < processes.length; ++idx) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        for (int i = 0; i < agents.length; ++i) {
                            PerftraceUtil.getAgentGc((TRCAgentProxy)agents[i], tmpList);
                        }
                    }
                }
                return PerftraceUtil.getObjectArray();
            }
        }
        return PerftraceUtil.getObjectArray();
    }

    public static Object[] getAllHeapDump(EObject mofObject) {
        tmpList.clear();
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentHeapDump((TRCAgentProxy)mofObject, tmpList);
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                for (int idx = 0; idx < agents.length; ++idx) {
                    PerftraceUtil.getAgentHeapDump((TRCAgentProxy)agents[idx], tmpList);
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                for (int idx = 0; idx < processes.length; ++idx) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    for (int i = 0; i < agents.length; ++i) {
                        PerftraceUtil.getAgentHeapDump((TRCAgentProxy)agents[i], tmpList);
                    }
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                for (int k = 0; k < nodes.length; ++k) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    for (int idx = 0; idx < processes.length; ++idx) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        for (int i = 0; i < agents.length; ++i) {
                            PerftraceUtil.getAgentHeapDump((TRCAgentProxy)agents[i], tmpList);
                        }
                    }
                }
                return PerftraceUtil.getObjectArray();
            }
        }
        return PerftraceUtil.getObjectArray();
    }

    public static Object[] getAllPackages(EObject mofObject) {
        tmpList.clear();
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentPackages((TRCAgentProxy)mofObject, tmpList);
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                for (int idx = 0; idx < agents.length; ++idx) {
                    PerftraceUtil.getAgentPackages((TRCAgentProxy)agents[idx], tmpList);
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                for (int idx = 0; idx < processes.length; ++idx) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    for (int i = 0; i < agents.length; ++i) {
                        PerftraceUtil.getAgentPackages((TRCAgentProxy)agents[i], tmpList);
                    }
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                for (int k = 0; k < nodes.length; ++k) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    for (int idx = 0; idx < processes.length; ++idx) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        for (int i = 0; i < agents.length; ++i) {
                            PerftraceUtil.getAgentPackages((TRCAgentProxy)agents[i], tmpList);
                        }
                    }
                }
                return PerftraceUtil.getObjectArray();
            }
        }
        return PerftraceUtil.getObjectArray();
    }

    public static Object[] getAllReferences(EObject mofObject) {
        tmpList.clear();
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentObjReferences((TRCAgentProxy)mofObject, tmpList);
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                for (int idx = 0; idx < agents.length; ++idx) {
                    PerftraceUtil.getAgentObjReferences((TRCAgentProxy)agents[idx], tmpList);
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                for (int idx = 0; idx < processes.length; ++idx) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    for (int i = 0; i < agents.length; ++i) {
                        PerftraceUtil.getAgentObjReferences((TRCAgentProxy)agents[i], tmpList);
                    }
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                for (int k = 0; k < nodes.length; ++k) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    for (int idx = 0; idx < processes.length; ++idx) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        for (int i = 0; i < agents.length; ++i) {
                            PerftraceUtil.getAgentObjReferences((TRCAgentProxy)agents[i], tmpList);
                        }
                    }
                }
                return PerftraceUtil.getObjectArray();
            }
        }
        return PerftraceUtil.getObjectArray();
    }

    public static Object[] getAllThreads(EObject mofObject) {
        tmpList.clear();
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                PerftraceUtil.getAgentThreads((TRCAgentProxy)mofObject, tmpList);
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                for (int idx = 0; idx < agents.length; ++idx) {
                    PerftraceUtil.getAgentThreads((TRCAgentProxy)agents[idx], tmpList);
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                for (int idx = 0; idx < processes.length; ++idx) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    for (int i = 0; i < agents.length; ++i) {
                        PerftraceUtil.getAgentThreads((TRCAgentProxy)agents[i], tmpList);
                    }
                }
                return PerftraceUtil.getObjectArray();
            }
            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                for (int k = 0; k < nodes.length; ++k) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    for (int idx = 0; idx < processes.length; ++idx) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        for (int i = 0; i < agents.length; ++i) {
                            PerftraceUtil.getAgentThreads((TRCAgentProxy)agents[i], tmpList);
                        }
                    }
                }
                return PerftraceUtil.getObjectArray();
            }
        }
        return PerftraceUtil.getObjectArray();
    }

    public static TRCClass getClass(TRCMethodInvocation invocation) {
        TRCTraceObject o = invocation.getOwningObject();
        if (o.getIsA() != invocation.getProcess().getClassClass()) {
            return o.getIsA();
        }
        return invocation.getMethod().getDefiningClass();
    }

    public static TRCClass getClass(TRCObject object) {
        TRCClass clas = object.getIsA();
        if (clas == object.getProcess().getClassClass()) {
            TRCPackage[] packages = (TRCPackage[])object.getProcess().getPackages().toArray();
            for (int i = 0; i < packages.length; ++i) {
                TRCClass[] classes = (TRCClass[])packages[i].getClasses().toArray();
                for (int j = 0; j < classes.length; ++j) {
                    Object[] objects = classes[j].getClassObjects().toArray();
                    for (int k = 0; k < objects.length; ++k) {
                        if (objects[k] != object) continue;
                        return classes[j];
                    }
                }
            }
        }
        return clas;
    }

    public static double getMaximumTime(EObject mofObject) {
        double time = 0.0;
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                TRCProcess proces;
                if (((TRCAgentProxy)mofObject).getAgent() != null && (proces = (TRCProcess)((TRCAgentProxy)mofObject).getAgent().getProcess()) != null) {
                    time = proces.getLastEventTime();
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                for (int idx = 0; idx < agents.length; ++idx) {
                    double tmp;
                    TRCProcess proces;
                    if (((TRCAgentProxy)agents[idx]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[idx]).getAgent().getProcess()) == null || !((tmp = proces.getLastEventTime()) > time)) continue;
                    time = tmp;
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                for (int idx = 0; idx < processes.length; ++idx) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    for (int i = 0; i < agents.length; ++i) {
                        double tmp;
                        TRCProcess proces;
                        if (((TRCAgentProxy)agents[i]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[i]).getAgent().getProcess()) == null || !((tmp = proces.getLastEventTime()) > time)) continue;
                        time = tmp;
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                for (int k = 0; k < nodes.length; ++k) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    for (int idx = 0; idx < processes.length; ++idx) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        for (int i = 0; i < agents.length; ++i) {
                            double tmp;
                            TRCProcess proces;
                            if (((TRCAgentProxy)agents[i]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[i]).getAgent().getProcess()) == null || !((tmp = proces.getLastEventTime()) > time)) continue;
                            time = tmp;
                        }
                    }
                }
            }
        }
        if (time == 0.0) {
            time = 1.0;
        }
        return time;
    }

    public static String getPackageName(TRCPackage pack, Object mofObject) {
        StringBuffer buff = new StringBuffer(pack.getName());
        if (buff.length() == 0) {
            buff.append(TraceUIPlugin.getString("DEFAULT_PACKAGE"));
        }
        if (mofObject instanceof TRCAgentProxy || mofObject instanceof TRCProcessProxy) {
            return buff.toString();
        }
        return buff.append(" [").append(pack.getProcess().getPid()).append("]").toString();
    }

    public static TRCProcess getProcess(TRCAgent agent) {
        if (agent.getProcess() instanceof TRCProcess) {
            return (TRCProcess)agent.getProcess();
        }
        return null;
    }

    public static String getThreadName(TRCThread thread) {
        StringBuffer tmpBuffer = new StringBuffer(thread.getName());
        return tmpBuffer.append("[").append(thread.getProcess().getPid()).append("]").toString();
    }

    public static long getTime(double etime) {
        return (long)(etime * 1000000.0);
    }

    public static int getTotalCalls(EObject mofObject) {
        int calls = 0;
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                TRCProcess proces;
                if (((TRCAgentProxy)mofObject).getAgent() != null && (proces = (TRCProcess)((TRCAgentProxy)mofObject).getAgent().getProcess()) != null) {
                    calls = proces.getCalls();
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                for (int idx = 0; idx < agents.length; ++idx) {
                    TRCProcess proces;
                    if (((TRCAgentProxy)agents[idx]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[idx]).getAgent().getProcess()) == null) continue;
                    calls += proces.getCalls();
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                for (int idx = 0; idx < processes.length; ++idx) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    for (int i = 0; i < agents.length; ++i) {
                        TRCProcess proces;
                        if (((TRCAgentProxy)agents[i]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[i]).getAgent().getProcess()) == null) continue;
                        calls += proces.getCalls();
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                for (int k = 0; k < nodes.length; ++k) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    for (int idx = 0; idx < processes.length; ++idx) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        for (int i = 0; i < agents.length; ++i) {
                            TRCProcess proces;
                            if (((TRCAgentProxy)agents[i]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[i]).getAgent().getProcess()) == null) continue;
                            calls += proces.getCalls();
                        }
                    }
                }
            }
        }
        if (calls == 0) {
            calls = 1;
        }
        return calls;
    }

    public static int getTotalInstances(EObject mofObject) {
        int inst = 0;
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                TRCProcess proces;
                if (((TRCAgentProxy)mofObject).getAgent() != null && (proces = (TRCProcess)((TRCAgentProxy)mofObject).getAgent().getProcess()) != null) {
                    inst = proces.getTotalInstances();
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                for (int idx = 0; idx < agents.length; ++idx) {
                    TRCProcess proces;
                    if (((TRCAgentProxy)agents[idx]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[idx]).getAgent().getProcess()) == null) continue;
                    inst += proces.getTotalInstances();
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                for (int idx = 0; idx < processes.length; ++idx) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    for (int i = 0; i < agents.length; ++i) {
                        TRCProcess proces;
                        if (((TRCAgentProxy)agents[i]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[i]).getAgent().getProcess()) == null) continue;
                        inst += proces.getTotalInstances();
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                for (int k = 0; k < nodes.length; ++k) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    for (int idx = 0; idx < processes.length; ++idx) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        for (int i = 0; i < agents.length; ++i) {
                            TRCProcess proces;
                            if (((TRCAgentProxy)agents[i]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[i]).getAgent().getProcess()) == null) continue;
                            inst += proces.getTotalInstances();
                        }
                    }
                }
            }
        }
        if (inst == 0) {
            inst = 1;
        }
        return inst;
    }

    public static long getTotalSize(EObject mofObject) {
        long size = 0L;
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                TRCProcess proces;
                if (((TRCAgentProxy)mofObject).getAgent() != null && (proces = (TRCProcess)((TRCAgentProxy)mofObject).getAgent().getProcess()) != null) {
                    size = proces.getTotalSize();
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                for (int idx = 0; idx < agents.length; ++idx) {
                    TRCProcess proces;
                    if (((TRCAgentProxy)agents[idx]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[idx]).getAgent().getProcess()) == null) continue;
                    size += (long)proces.getTotalSize();
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                for (int idx = 0; idx < processes.length; ++idx) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    for (int i = 0; i < agents.length; ++i) {
                        TRCProcess proces;
                        if (((TRCAgentProxy)agents[i]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[i]).getAgent().getProcess()) == null) continue;
                        size += (long)proces.getTotalSize();
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                for (int k = 0; k < nodes.length; ++k) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    for (int idx = 0; idx < processes.length; ++idx) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        for (int i = 0; i < agents.length; ++i) {
                            TRCProcess proces;
                            if (((TRCAgentProxy)agents[i]).getAgent() == null || (proces = (TRCProcess)((TRCAgentProxy)agents[i]).getAgent().getProcess()) == null) continue;
                            size += (long)proces.getTotalSize();
                        }
                    }
                }
            }
        }
        if (size == 0L) {
            size = 1L;
        }
        return size;
    }

    public static boolean collectInstanceInformation(TRCAgentProxy agent) {
        TRCConfiguration config;
        EList options;
        if (agent.getName().equals("J2EE Request Profiler")) {
            return true;
        }
        TRCCollectionMode type = agent.getCollectionMode();
        if (type == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL || type == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || type == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL) {
            return false;
        }
        Iterator configs = agent.getConfigurations().iterator();
        if (configs.hasNext() && (options = (config = (TRCConfiguration)configs.next()).getOptions()) != null) {
            Iterator i = options.iterator();
            while (i.hasNext()) {
                TRCOption option = (TRCOption)i.next();
                if (!option.getKey().equals("TRACE_MODE") || !option.getValue().equals("noObjectCorrelation")) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean collectStatisticInfo(EObject mofObject) {
        if (mofObject != null) {
            int idx;
            if (mofObject instanceof TRCAgentProxy) {
                TRCAgentProxy agent = (TRCAgentProxy)mofObject;
                return agent.getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || agent.getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || agent.getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL || agent.getCollectionMode() == TRCCollectionMode.HEAP_FULL_LITERAL || agent.getCollectionMode() == TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL;
            }
            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)mofObject).getAgentProxies().toArray();
                for (idx = 0; idx < agents.length; ++idx) {
                    boolean collectStatistic;
                    boolean bl = collectStatistic = ((TRCAgentProxy)agents[idx]).getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)agents[idx]).getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)agents[idx]).getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)agents[idx]).getCollectionMode() == TRCCollectionMode.HEAP_FULL_LITERAL || ((TRCAgentProxy)agents[idx]).getCollectionMode() == TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL;
                    if (collectStatistic) continue;
                    return false;
                }
            }
            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)mofObject).getProcessProxies().toArray();
                for (idx = 0; idx < processes.length; ++idx) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    for (int i = 0; i < agents.length; ++i) {
                        boolean collectStatistic;
                        boolean bl = collectStatistic = ((TRCAgentProxy)agents[i]).getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL;
                        if (collectStatistic) continue;
                        return false;
                    }
                }
            }
            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)mofObject).getNodes().toArray();
                for (int k = 0; k < nodes.length; ++k) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    for (int idx2 = 0; idx2 < processes.length; ++idx2) {
                        Object[] agents = ((TRCProcessProxy)processes[idx2]).getAgentProxies().toArray();
                        for (int i = 0; i < agents.length; ++i) {
                            boolean collectStatistic;
                            boolean bl = collectStatistic = ((TRCAgentProxy)agents[i]).getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL || ((TRCAgentProxy)agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL;
                            if (collectStatistic) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    public static String formatAsPercentage(double d) {
        if (_percentFormat == null) {
            _percentFormat = NumberFormat.getPercentInstance();
            _percentFormat.setMaximumIntegerDigits(3);
            _percentFormat.setMaximumFractionDigits(2);
            _percentFormat.setMinimumFractionDigits(2);
        }
        return _percentFormat.format(d);
    }

    public static String formatTimeValue(double d) {
        if (_decimalFormat == null) {
            _decimalFormat = NumberFormat.getNumberInstance();
            _decimalFormat.setMaximumFractionDigits(6);
            _decimalFormat.setMinimumFractionDigits(6);
        }
        return _decimalFormat.format(d);
    }

    private static void getAgentClasses(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals("Profiler") || agent.getAgent() == null || PerftraceUtil.getProcess(agent.getAgent()) == null) {
            return;
        }
        Object[] packages = PerftraceUtil.getProcess(agent.getAgent()).getPackages().toArray();
        for (int idx = 0; idx < packages.length; ++idx) {
            list.addAll(((TRCPackage)packages[idx]).getClasses());
        }
    }

    private static void getAgentGc(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals("Profiler") || agent.getAgent() == null || PerftraceUtil.getProcess(agent.getAgent()) == null) {
            return;
        }
    }

    private static void getAgentHeapDump(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals("Profiler") || agent.getAgent().getProcess() == null) {
            return;
        }
        list.addAll(((TRCProcess)agent.getAgent().getProcess()).getHeapDumps());
    }

    private static void getAgentObjReferences(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals("Profiler") || agent.getAgent() == null || PerftraceUtil.getProcess(agent.getAgent()) == null) {
            return;
        }
    }

    private static void getAgentPackages(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals("Profiler") || agent.getAgent() == null || PerftraceUtil.getProcess(agent.getAgent()) == null) {
            return;
        }
        list.addAll(PerftraceUtil.getProcess(agent.getAgent()).getPackages());
    }

    private static void getAgentThreads(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals("Profiler") || agent.getAgent().getProcess() == null) {
            return;
        }
        Object[] threads = ((TRCProcess)agent.getAgent().getProcess()).getThreads().toArray();
        for (int idx = 0; idx < threads.length; ++idx) {
            TRCThread thread = (TRCThread)threads[idx];
            if (thread.getInitialInvocations().size() <= 0) continue;
            if (thread.getName() == null) {
                thread.setName(String.valueOf(idx + 1));
            }
            list.add(thread);
        }
    }

    private static Object[] getObjectArray() {
        Object[] ret = tmpList.toArray();
        tmpList.clear();
        return ret;
    }
}

