/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.SDbPluginImages;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DBLabelProvider
extends LabelProvider {
    public Image getImage(Object element) {
        if (element instanceof SDBRuntime) {
            return SDbPluginImages.getImage("symptomdb_obj.gif");
        }
        if (element instanceof SDBSymptom) {
            return SDbPluginImages.getImage("symptomdb_desc_obj.gif");
        }
        if (element instanceof SDBSolution) {
            return SDbPluginImages.getImage("symptomdb_solution_obj.gif");
        }
        if (element instanceof SDBDirective) {
            return SDbPluginImages.getImage("trcdirective_obj.gif");
        }
        return null;
    }

    public String getText(Object element) {
        String name = SDbPlugin.getResourceString("STR_DEFAULT_NAME_LABEL");
        if (element instanceof SDBRuntime) {
            name = ((SDBRuntime)element).getName();
        } else if (element instanceof SDBSymptom) {
            name = ((SDBSymptom)element).getDescription();
            name = this.truncateString(name);
        } else if (element instanceof SDBSolution) {
            name = ((SDBSolution)element).getDescription();
            name = this.truncateString(name);
        } else if (element instanceof SDBDirective) {
            name = ((SDBDirective)element).getDescription();
            name = this.truncateString(name);
        }
        return name;
    }

    private String truncateString(String name) {
        int idx = name.indexOf("\r\n", 0);
        if (idx != -1) {
            name = name.substring(0, idx);
        } else {
            idx = name.indexOf("\n");
            if (idx != -1) {
                name = name.substring(0, idx);
            }
        }
        return name;
    }
}

