/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileDetailsUI;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserItem;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogParserUI
implements SelectionListener {
    private Table _list;
    private Label _description;
    private ArrayList _images;
    private ArrayList _parserTable = new ArrayList();
    private LogParserItem _parser;
    private int _max = 1;
    private LogFileDetailsUI _detailsUI;

    public LogParserUI(LogFileDetailsUI detailsUI) {
        this._detailsUI = detailsUI;
        this._images = new ArrayList();
    }

    public Composite createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayoutData((Object)GridUtil.createFill());
        result.setLayout((Layout)new GridLayout());
        Label desc = new Label(result, 0);
        desc.setLayoutData((Object)GridUtil.createHorizontalFill());
        desc.setText(LogUIPlugin.getResourceString("STR_LOG_PDESC"));
        this._list = new Table(result, 68356);
        GridData data = GridUtil.createHorizontalFill();
        data.widthHint = 400;
        data.heightHint = 70;
        this._list.setLayoutData((Object)data);
        this._description = new Label(result, 64);
        data = GridUtil.createHorizontalFill();
        data.heightHint = 30;
        data.widthHint = 400;
        this._description.setLayoutData((Object)data);
        this._list.addSelectionListener((SelectionListener)this);
        this.initializeValues();
        WorkbenchHelp.setHelp((Control)this._list, (String)(LogUIPlugin.getPluginId() + ".parserlist"));
        return result;
    }

    private void initializeValues() {
        Collection parsers = this._detailsUI.getParserRegistry().values();
        Iterator iter = parsers.iterator();
        while (iter.hasNext()) {
            this._parserTable.add(iter.next());
        }
        this.initializeUI();
    }

    private void initializeUI() {
        Collections.sort(this._parserTable, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((LogParserItem)o1).getDescription().compareToIgnoreCase(((LogParserItem)o2).getDescription());
            }
        });
        for (int idx = 0; idx < this._parserTable.size(); ++idx) {
            LogParserItem parser = (LogParserItem)this._parserTable.get(idx);
            TableItem item = new TableItem(this._list, 0);
            item.setText(parser.getUIName());
            item.setData((Object)parser);
            if (parser.getImageDescriptor() == null) continue;
            Image image = parser.getImageDescriptor().createImage();
            item.setImage(image);
            this._images.add(image);
        }
        if (this._parserTable.size() > 0) {
            LogParserItem item = this._detailsUI.getLogFileElement().getParser();
            if (item == null) {
                this._parser = (LogParserItem)this._parserTable.get(0);
                this._list.setSelection(0);
            } else {
                this._parser = item;
                this._list.setSelection(this._detailsUI.indexOf(this._parser));
            }
            this._detailsUI.setSelectedParser(this._parser);
            this._description.setText(this._parser.getDescription());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        TableItem[] selected;
        if (e.widget == this._list && (selected = this._list.getSelection()).length > 0) {
            this._parser = (LogParserItem)selected[0].getData();
            this._detailsUI.setSelectedParser(this._parser);
            this._description.setText(this._parser.getDescription());
        }
    }

    public LogParserItem getParser() {
        return this._parser;
    }

    public int getMaximumFields() {
        return this._max;
    }

    public int getParserCount() {
        return this._list.getItemCount();
    }

    public int indexOf(LogParserItem parser) {
        TableItem[] items = this._list.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!((LogParserItem)items[i].getData()).getDescription().equals(parser.getDescription())) continue;
            return i;
        }
        return -1;
    }

    public void dispose() {
        for (int idx = 0; idx < this._images.size(); ++idx) {
            Image image = (Image)this._images.get(idx);
            if (image == null || image.isDisposed()) continue;
            image.dispose();
        }
        this._images.clear();
    }

    public boolean finish() {
        TableItem[] sel = this._list.getSelection();
        return sel.length != 0;
    }
}

