/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.provider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.ui.util.ILabelAndDescriptionProvider;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class LabelProviderPicker
implements ILabelAndDescriptionProvider {
    private ListenerList listenerList = new ListenerList();
    private List providers = new ArrayList();
    private int currentProvider = -1;

    public void dispose() {
        this.currentProvider = -1;
        Iterator i = this.providers.iterator();
        while (i.hasNext()) {
            ILabelProvider treeContentProvider = (ILabelProvider)i.next();
            treeContentProvider.dispose();
        }
        this.providers.clear();
    }

    public void addProvider(ILabelProvider provider) {
        if (this.providers.add(provider)) {
            if (this.currentProvider < 0) {
                this.currentProvider = this.providers.size() - 1;
            }
            Object[] listeners = this.listenerList.getListeners();
            int maxi = listeners.length;
            for (int i = 0; i < maxi; ++i) {
                provider.addListener((ILabelProviderListener)listeners[i]);
            }
        }
    }

    public void clearProviders() {
        Object[] listeners = this.listenerList.getListeners();
        Iterator i = this.providers.iterator();
        while (i.hasNext()) {
            ILabelProvider provider = (ILabelProvider)i.next();
            int maxj = listeners.length;
            for (int j = 0; j < maxj; ++j) {
                provider.addListener((ILabelProviderListener)listeners[j]);
            }
        }
        this.currentProvider = -1;
        this.listenerList.clear();
        this.providers.clear();
    }

    public void removeProvider(int index) {
        if (index == this.currentProvider) {
            this.currentProvider = -1;
        } else if (index < this.currentProvider) {
            --this.currentProvider;
        }
        ILabelProvider provider = (ILabelProvider)this.providers.remove(index);
        if (provider != null) {
            Object[] listeners = this.listenerList.getListeners();
            int maxi = listeners.length;
            for (int i = 0; i < maxi; ++i) {
                provider.removeListener((ILabelProviderListener)listeners[i]);
            }
        }
    }

    public boolean setCurrentProvider(int index) {
        if (index < 0 || index >= this.providers.size()) {
            return false;
        }
        if (index == this.currentProvider) {
            return true;
        }
        this.currentProvider = index;
        return true;
    }

    public ILabelProvider getCurrentProvider() {
        if (this.currentProvider < 0) {
            return null;
        }
        return (ILabelProvider)this.providers.get(this.currentProvider);
    }

    public int getCurrentProviderIndex() {
        return this.currentProvider;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listenerList.add((Object)listener);
        Iterator i = this.providers.iterator();
        while (i.hasNext()) {
            ((ILabelProvider)i.next()).addListener(listener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listenerList.remove((Object)listener);
        Iterator i = this.providers.iterator();
        while (i.hasNext()) {
            ((ILabelProvider)i.next()).removeListener(listener);
        }
    }

    public String getDescription(Object element) {
        if (this.getCurrentProviderIndex() < 0) {
            return null;
        }
        ILabelProvider labelProvider = this.getCurrentProvider();
        if (labelProvider instanceof ILabelAndDescriptionProvider) {
            return ((ILabelAndDescriptionProvider)labelProvider).getDescription(element);
        }
        return null;
    }

    public Image getImage(Object element) {
        if (this.getCurrentProviderIndex() < 0) {
            return null;
        }
        return this.getCurrentProvider().getImage(element);
    }

    public String getText(Object element) {
        if (this.getCurrentProviderIndex() < 0) {
            return null;
        }
        return this.getCurrentProvider().getText(element);
    }

    public boolean isLabelProperty(Object element, String property) {
        if (this.getCurrentProviderIndex() < 0) {
            return false;
        }
        return this.getCurrentProvider().isLabelProperty(element, property);
    }
}

