/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.SinglePatternPage;
import org.eclipse.hyades.trace.views.internal.JCanvas;
import org.eclipse.hyades.trace.views.internal.SinglePatternDrawStrategy;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.GraphColorDialog;
import org.eclipse.hyades.trace.views.util.internal.ITimeChangedListener;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SinglePattern
implements ITimeChangedListener,
ControlListener,
ISelectionProvider,
IViewSelectionChangedListener {
    protected final float MAG_STEP = 2.0f;
    private Label _status;
    private JCanvas _canvas;
    private SinglePatternDrawStrategy _curDS;
    private SinglePatternDrawStrategy _singlePatDS;
    private boolean _initialized = false;
    protected SinglePatternPage _page;
    protected Composite viewContainer;
    protected ViewForm dataPane;
    protected Composite viewComp;
    private Action _showNextAction;
    private Action _showPrevAction;
    private Action _showCallerAction;
    private Action _showCalleeAction;
    private Action _updateAction;
    private Action _openColorDialog;
    protected Separator fSeparator;

    public SinglePattern(Composite parent, SinglePatternPage page) {
        this._page = page;
        this.createControl(parent);
        this._showNextAction = new ShowNextAction(TraceUIPlugin.getString("STR_NEXT"));
        this._showPrevAction = new ShowPreviousAction(TraceUIPlugin.getString("STR_PREVIOUS"));
        this._showCallerAction = new ShowCallerAction(TraceUIPlugin.getString("STR_CALLER"));
        this._showCalleeAction = new ShowCalleeAction(TraceUIPlugin.getString("STR_CALLEE"));
        this._updateAction = new UpdateAction(UIPlugin.getResourceString((String)"REFRESH_VIEWS"));
        this._openColorDialog = new OpenColorDialog(TraceUIPlugin.getString("OPEN_COLOR_DLG"));
        TraceUIPlugin.getDefault().addTimeChangedEventListener(this);
        UIPlugin.getDefault().addViewSelectionChangedListener((IViewSelectionChangedListener)this);
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent event) {
        this.resizeContent();
    }

    public void createControl(Composite parent) {
        this.viewContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.viewContainer.setLayout((Layout)layout);
        this.viewContainer.setLayoutData((Object)GridUtil.createFill());
        this.viewComp = new Composite(this.viewContainer, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        this.viewComp.setLayout((Layout)layout);
        this.viewComp.setLayoutData((Object)GridUtil.createFill());
        this.dataPane = new ViewForm(this.viewComp, 0);
        this.dataPane.setLayoutData((Object)GridUtil.createFill());
        this._canvas = new JCanvas((Composite)this.dataPane, 768, 10);
        this.dataPane.setContent((Control)this._canvas.canvas());
        this.viewContainer.addControlListener((ControlListener)this);
        this._status = new Label(this.viewContainer, 2048);
        this._status.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.dataPane.setTopLeft((Control)new CLabel((Composite)this.dataPane, 0));
    }

    public void dispose() {
        TraceUIPlugin.getDefault().removeTimeChangedEventListener(this);
        UIPlugin.getDefault().removeViewSelectionChangedListener((IViewSelectionChangedListener)this);
        if (this._singlePatDS != null) {
            this._singlePatDS.shutdown();
        }
        if (this._canvas != null) {
            this._canvas.dispose();
        }
        this._canvas = null;
        if (this.dataPane != null) {
            this.dataPane.dispose();
        }
        this.dataPane = null;
        if (this.viewComp != null) {
            this.viewComp.dispose();
        }
        this.viewComp = null;
        if (this.viewContainer != null) {
            this.viewContainer.dispose();
        }
        this.viewContainer = null;
        this._page = null;
        this._singlePatDS = null;
        this._curDS = null;
        if (this._status != null) {
            this._status.dispose();
        }
        this._status = null;
        this._openColorDialog = null;
        this._showCalleeAction = null;
        this._showCallerAction = null;
        this._showNextAction = null;
        this._showPrevAction = null;
        this._updateAction = null;
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this._updateAction);
        menu.add((IAction)this._openColorDialog);
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this._showCallerAction);
        menu.add((IAction)this._showCalleeAction);
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this._showNextAction);
        menu.add((IAction)this._showPrevAction);
        menu.add((IContributionItem)this.fSeparator);
        this._showPrevAction.setEnabled(this._curDS.hasLessElements());
        this._showNextAction.setEnabled(this._curDS.hasMoreElements());
        this._showCallerAction.setEnabled(this._curDS.hasCaller());
        this._showCalleeAction.setEnabled(this._curDS.hasCallee());
        this._canvas.fillContextMenu(menu);
    }

    public Control getControl() {
        return this.viewContainer;
    }

    public void initialize() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        this.initStrategies();
        this.setDrawStrategy(this._singlePatDS);
        this.fSeparator = new Separator();
    }

    private void initStrategies() {
        this._singlePatDS = new SinglePatternDrawStrategy(this);
    }

    public void menuAboutToShow(IMenuManager menu) {
        this.fillContextMenu(menu);
    }

    public void next() {
        this.initialize();
        if (this._singlePatDS != null) {
            this._singlePatDS.drawNextPattern();
            this._singlePatDS.jcanvas().zoomToFill(1.0f, 1000.0f);
            this._singlePatDS.jcanvas().redraw();
        }
    }

    public void openSource() {
        OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).getFirstElement());
    }

    public void previous() {
        this.initialize();
        if (this._singlePatDS != null) {
            this._singlePatDS.drawPreviousPattern();
            this._singlePatDS.jcanvas().zoomToFill(1.0f, 1000.0f);
            this._singlePatDS.jcanvas().redraw();
        }
    }

    public void resizeContent() {
        Rectangle viewContainerBounds = this.viewComp.getClientArea();
        this.dataPane.setBounds(viewContainerBounds.x, viewContainerBounds.y, viewContainerBounds.width, viewContainerBounds.height);
    }

    private void setDrawStrategy(SinglePatternDrawStrategy ds) {
        if (ds != this._curDS) {
            if (this._curDS != null) {
                this._curDS.jcanvas(null);
            }
            this._curDS = ds;
            this._curDS.jcanvas(this._canvas);
            this._canvas.zoomToFit();
            this._canvas.setDrawStrategy(this._curDS);
            this._canvas.redraw();
        }
    }

    public void showCallee() {
        if (this._curDS != null) {
            this._curDS.showCallee();
        }
    }

    public void showCaller() {
        if (this._curDS != null) {
            this._curDS.showCaller();
        }
    }

    public void update() {
        this.update(true);
    }

    public void update(boolean redraw) {
        this.initialize();
        if (this._singlePatDS != null) {
            this._singlePatDS.searchPattern();
            this.updateUI();
        }
    }

    public void updateButtons() {
        if (this._curDS != null) {
            if (this._page.previous() != null) {
                this._page.previous().setEnabled(this._curDS.hasLessElements());
            }
            if (this._page.next() != null) {
                this._page.next().setEnabled(this._curDS.hasMoreElements());
            }
            if (this._page.caller() != null) {
                this._page.caller().setEnabled(this._curDS.hasCaller());
            }
            if (this._page.callee() != null) {
                this._page.callee().setEnabled(this._curDS.hasCallee());
            }
            if (this._page.openSource() != null) {
                this._page.openSource().setEnabled(UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).getFirstElement() != null);
            }
        }
    }

    public void updateStatus(String status) {
        this._status.setText(status);
    }

    public void updateTitle(String title) {
        ((CLabel)this.dataPane.getTopLeft()).setText(title);
    }

    public void updateUI() {
        if (this._curDS.jcanvas() != null) {
            this._curDS.jcanvas().zoomToFill(1.0f, 1000.0f);
            this._curDS.jcanvas().redraw();
        }
    }

    public void zoomIn(boolean zoom) {
        this.initialize();
        this._canvas.isZoomIn(zoom);
        this._canvas.zoomIn();
    }

    public void zoomOut(boolean zoom) {
        this.initialize();
        this._canvas.isZoomOut(zoom);
        this._canvas.zoomOut();
    }

    public void handleTimeChangedEvent() {
        Action base = this._page.baseTime();
        Action raw = this._page.rawTime();
        int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
        if (base != null) {
            base.setChecked(ref == 0);
        }
        if (raw != null) {
            raw.setChecked(ref == 1);
        }
        if (this._curDS != null) {
            this._curDS.setDrawMode(ref);
        }
    }

    public SinglePatternPage getPage() {
        return this._page;
    }

    public void refresh() {
        if (this._canvas != null && !this._canvas.canvas().isDisposed() && this._canvas.canvas().isVisible()) {
            this._canvas.redraw();
        }
    }

    public void selectionChanged() {
        if (this._canvas != null && !this._canvas.canvas().isDisposed() && this._canvas.canvas().isVisible() && !this._canvas.canvas().isFocusControl()) {
            this.update();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        if (this._page == null) {
            return new StructuredSelection();
        }
        Object selection = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject()).getFirstElement();
        if (selection != null) {
            return new StructuredSelection(selection);
        }
        return new StructuredSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    public JCanvas getCanvas() {
        return this._canvas;
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        if (!this.getPage().getTraceViewer().isProcessRefreshEvents() || this.getCanvas().canvas().isFocusControl()) {
            return;
        }
        this.selectionChanged();
    }

    class ShowPreviousAction
    extends Action {
        public ShowPreviousAction(String name) {
            super(name);
        }

        public void run() {
            SinglePattern.this.previous();
        }
    }

    class ShowNextAction
    extends Action {
        public ShowNextAction(String name) {
            super(name);
        }

        public void run() {
            SinglePattern.this.next();
        }
    }

    class ShowCalleeAction
    extends Action {
        public ShowCalleeAction(String name) {
            super(name);
        }

        public void run() {
            SinglePattern.this.showCallee();
        }
    }

    class ShowCallerAction
    extends Action {
        public ShowCallerAction(String name) {
            super(name);
        }

        public void run() {
            SinglePattern.this.showCaller();
        }
    }

    class OpenColorDialog
    extends Action {
        public OpenColorDialog(String name) {
            super(name);
            TracePluginImages.setImageDescriptors((IAction)this, "tool16", "opengraphcolor_co.gif");
        }

        public void run() {
            GraphColorDialog dialog = new GraphColorDialog(SinglePattern.this.viewContainer.getShell(), TraceUIPlugin.getString("STR_GRAPH_COLOR_DLG"), null);
            dialog.open();
        }
    }

    class UpdateAction
    extends Action {
        public UpdateAction(String name) {
            super(name);
            PDPluginImages.setImageDescriptors((IAction)this, (String)"lcl16", (String)"updateviews_co.gif");
        }

        public void run() {
            ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
            event.setSource((Object)SinglePattern.this._page.getMOFObject());
            event.setType(32);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
    }
}

