/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.IImportWizardWidget;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ImportWizardRadioButton
implements IImportWizardWidget {
    protected Collection buttonList = new ArrayList();
    private ParserField _field = null;

    public ImportWizardRadioButton(ParserField field) {
        this._field = field;
    }

    public String getValue() {
        Iterator iter = this.buttonList.iterator();
        while (iter.hasNext()) {
            Button button = (Button)iter.next();
            if (!button.getSelection()) continue;
            return button.getText();
        }
        return null;
    }

    public void setValue(String newValue) {
        Iterator iter = this.buttonList.iterator();
        StringTokenizer st = new StringTokenizer(newValue, ",");
        String token = "";
        while (iter.hasNext() && st.hasMoreTokens()) {
            Button button = (Button)iter.next();
            token = st.nextToken();
            button.setSelection(token.equals("true"));
        }
    }

    public void createControl(Composite composite, String prefix) {
        Label label = new Label(composite, 64);
        GridData data = new GridData();
        data.widthHint = 400;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(this._field.getName());
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        String previousValue = store.getString(prefix + this._field.getId());
        StringTokenizer st = new StringTokenizer(this._field.getDefaultValue(), ",");
        int index = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Button radio = new Button(composite, 16);
            Point buttonSize = radio.computeSize(-1, -1, true);
            data = new GridData();
            data.widthHint = 400;
            data.horizontalSpan = 2;
            radio.setLayoutData((Object)data);
            radio.setToolTipText(this._field.getTooltip());
            radio.setText(token);
            if (previousValue != null && previousValue.trim().equals(token)) {
                radio.setSelection(true);
            } else if ((previousValue == null || previousValue.trim().equals("")) && index == 0) {
                radio.setSelection(true);
            } else {
                radio.setSelection(false);
            }
            ++index;
            this.buttonList.add(radio);
        }
    }

    public Collection getButtonList() {
        return this.buttonList;
    }

    public void setButtonList(Collection buttonList) {
        this.buttonList = buttonList;
    }

    public boolean isValid() {
        return true;
    }

    public ParserField getField() {
        return this._field;
    }
}

