/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.tests.collection.correlation;

import org.eclipse.hyades.collection.correlation.BaseCorrelatorDataImpl;
import org.eclipse.hyades.collection.correlation.exceptions.InsufficientBufferLengthException;

public class BaseCorrelatorDataImplTester
extends BaseCorrelatorDataImpl {
    public static void main(String[] args) {
        System.err.println("#1: create context data...");
        BaseCorrelatorDataImplTester x = new BaseCorrelatorDataImplTester();
        byte[] buffer = new byte[]{-1, -1, -1, -1, 18, 52, 86, 120, -84, 61};
        System.err.print("buffer state: ");
        for (int i = 0; i < 10; ++i) {
            System.err.print("0x" + Integer.toHexString(buffer[i] & 0xFF) + " ");
        }
        System.err.println("\n");
        try {
            int i;
            System.err.println("#2: read counters from buffer...");
            System.err.println("readBinary(buffer, 0, 10): " + x.readBinary(buffer, 0, 10));
            long s = x.getApplicationCounter();
            long t = x.getOperationCounter();
            System.err.println("getApplicationCounter: " + Long.toHexString(s));
            System.err.println("getOperationCounter: " + Long.toHexString(t));
            System.err.println();
            System.err.println("#3: modify counters, and write them back to buffer...");
            System.err.println("setApplicationCounter: applicationCounter++");
            x.setApplicationCounter(s + 1L);
            System.err.println("setOperationCounter: operationCounter--");
            x.setOperationCounter(t - 1L);
            System.err.println("writeBinary(buffer, 1, 10): " + x.writeBinary(buffer, 1, 10));
            System.err.print("buffer state: ");
            for (i = 0; i < 10; ++i) {
                System.err.print("0x" + Integer.toHexString(buffer[i] & 0xFF) + " ");
            }
            System.err.println("\n");
            System.err.println("#4: modify counters, and write them back to buffer (boundary case)...");
            System.err.println("setApplicationCounter: applicationCounter--");
            x.setApplicationCounter(s);
            System.err.println("setOperationCounter: operationCounter++");
            x.setOperationCounter(t);
            System.err.println("writeBinary(buffer, 2, 10): " + x.writeBinary(buffer, 2, 10));
            System.err.print("buffer state: ");
            for (i = 0; i < 10; ++i) {
                System.err.print("0x" + Integer.toHexString(buffer[i] & 0xFF) + " ");
            }
            System.err.println("\n");
            System.err.println("#5: read and write correlator using xml...");
            StringBuffer stringBuffer = new StringBuffer();
            System.err.println("setting application counter (2003) and operation counter (3002)");
            x.setApplicationCounter(2003L);
            x.setOperationCounter(3002L);
            System.err.println("writeXML: " + x.writeXML(stringBuffer));
            System.err.println("readXML(buffer, 0, " + stringBuffer.length() + "): " + x.readXML(stringBuffer, 0, stringBuffer.length()));
            System.err.println("getApplicationCounter: " + x.getApplicationCounter());
            System.err.println("getOperationCounter: " + x.getOperationCounter());
        }
        catch (InsufficientBufferLengthException e) {
            // empty catch block
        }
        System.err.println("#6: read from and write to buffer (exceptional case)...");
        System.err.println("readBinary(buffer, 5, 10):");
        try {
            x.readBinary(buffer, 5, 10);
        }
        catch (InsufficientBufferLengthException e) {
            System.err.println("required length is at least: " + e.getRequiredLength());
            e.printStackTrace();
        }
        System.err.println("writeBinary(buffer, 9, 10):");
        try {
            x.writeBinary(buffer, 9, 10);
        }
        catch (InsufficientBufferLengthException e) {
            System.err.println("required length is at least: " + e.getRequiredLength());
            e.printStackTrace();
        }
        System.err.println();
        System.err.println("EOT");
    }
}

