/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.AuthenticationFailedCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.ServerSecurityInfoCommand;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.ContextMapper;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeImpl;
import org.eclipse.hyades.internal.execution.security.AuthenticationListener;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;

public class ConnectionImpl
implements Connection {
    protected Socket _socket;
    protected Node _node;
    protected int _port;
    private static long _context = 1L;
    private ContextMapper _contextMapper = null;
    private CommandHandler _cmdHandler = null;
    private boolean _isComplete = false;
    private Vector _listeners = new Vector();
    private Vector _authenticationlisteners = new Vector();
    private Object _connectionLock = new Object();
    private Object _loginLock = new Object();
    private boolean _isInitialized = false;
    private SecureConnectionRequiredException _secureConnectionRequiredException;
    private LoginFailedException _loginFailed;
    private boolean _loginPending = false;

    public void connect(Node node, int port) throws IOException, SecureConnectionRequiredException, LoginFailedException, UntrustedAgentControllerException {
        this._port = port;
        int offset = 0;
        InetAddress[] addrs = node.getAllInetAddresses();
        while (true) {
            try {
                this._socket = new Socket(addrs[offset], port);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                if (++offset != addrs.length) continue;
                throw e;
                if (offset < addrs.length) continue;
            }
            break;
        }
        this._node = node;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws IOException, SecureConnectionRequiredException, LoginFailedException {
        try {
            this._socket.setSoTimeout(1000);
            this._socket.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            // empty catch block
        }
        this._contextMapper = new ContextMapper();
        final ConnectionImpl connection = this;
        Node node = this._node;
        this._cmdHandler = new CommandHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void incommingCommand(Node node, CommandElement command) {
                long contextId = command.getContext();
                switch ((int)command.getTag()) {
                    case 4: {
                        ConnectionImpl.this._secureConnectionRequiredException = new SecureConnectionRequiredException((ServerSecurityInfoCommand)command);
                        ConnectionImpl.this.disconnect();
                        break;
                    }
                    case 2: {
                        Vector vector = ConnectionImpl.this._authenticationlisteners;
                        synchronized (vector) {
                            AuthenticationFailedCommand failedCommand = (AuthenticationFailedCommand)command;
                            if (node.getUser() != null && failedCommand.getTicket() == 0L) {
                                try {
                                    ConnectionImpl.this._loginPending = true;
                                    node.getUser().login(connection);
                                    break;
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            Enumeration enumeration = ConnectionImpl.this._authenticationlisteners.elements();
                            while (enumeration.hasMoreElements()) {
                                if (failedCommand.getTicket() == 0L) {
                                    ((AuthenticationListener)enumeration.nextElement()).authenticationRequired(connection);
                                    continue;
                                }
                                ((AuthenticationListener)enumeration.nextElement()).authenticationFailed(connection);
                            }
                            Object object = ConnectionImpl.this._loginLock;
                            synchronized (object) {
                                Object object2 = ConnectionImpl.this._connectionLock;
                                synchronized (object2) {
                                    ConnectionImpl.this._loginFailed = new LoginFailedException(ConnectionImpl.this.getPort());
                                    ConnectionImpl.this._loginPending = false;
                                    ConnectionImpl.this.disconnect();
                                    ConnectionImpl.this._connectionLock.notifyAll();
                                    ConnectionImpl.this._loginLock.notifyAll();
                                }
                            }
                        }
                    }
                    case 3: {
                        Object object = ConnectionImpl.this._authenticationlisteners;
                        synchronized (object) {
                            Enumeration enumeration = ConnectionImpl.this._authenticationlisteners.elements();
                            while (enumeration.hasMoreElements()) {
                                ((AuthenticationListener)enumeration.nextElement()).authenticationSuccessful(connection);
                            }
                        }
                        object = ConnectionImpl.this._loginLock;
                        synchronized (object) {
                            Object object3 = ConnectionImpl.this._connectionLock;
                            synchronized (object3) {
                                ConnectionImpl.this._loginPending = false;
                                ConnectionImpl.this._connectionLock.notifyAll();
                                ConnectionImpl.this._loginLock.notifyAll();
                            }
                        }
                    }
                    default: {
                        CommandHandler ch = ConnectionImpl.this._contextMapper.getHandler(contextId);
                        if (ch == null) break;
                        ch.incommingCommand(ConnectionImpl.this._node, command);
                    }
                }
            }
        };
        Object object = this._connectionLock;
        synchronized (object) {
            SocketReaderThread reader = new SocketReaderThread();
            if (this._node.getUser() == null) {
                reader.setName(this._node.getName() + "_connection");
            } else {
                reader.setName(this._node.getName() + "_" + this._node.getUser().getName() + "_connection");
            }
            reader.setDaemon(true);
            reader.start();
            try {
                this._connectionLock.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this._isInitialized = true;
            if (this._secureConnectionRequiredException != null) {
                SecureConnectionRequiredException temp = this._secureConnectionRequiredException;
                this._secureConnectionRequiredException = null;
                this._loginPending = false;
                throw temp;
            }
            Object temp = this._loginLock;
            synchronized (temp) {
                if (this._loginPending) {
                    try {
                        this._loginLock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (this._loginFailed != null) {
                temp = this._loginFailed;
                this._loginFailed = null;
                this._loginPending = false;
                throw temp;
            }
            if (this._isComplete) {
                throw new IOException();
            }
        }
    }

    public void sendMessage(ControlMessage msg, CommandHandler handler) throws IOException {
        int count = msg.getSize();
        byte[] buffer = new byte[count];
        for (int i = 0; i < msg.getCommandCount(); ++i) {
            msg.getCommand(i).setContext(_context++);
            this._contextMapper.addContext(msg.getCommand(i).getContext(), handler);
        }
        msg.writeToBuffer(buffer, 0);
        OutputStream stream = this._socket.getOutputStream();
        stream.write(buffer);
        stream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this._connectionLock;
        synchronized (object) {
            if (!this._isComplete) {
                this._isComplete = true;
                this._connectionLock.notifyAll();
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this._node instanceof NodeImpl) {
                    ((NodeImpl)this._node).setSecurityParameters(null);
                }
                Vector vector = this._listeners;
                synchronized (vector) {
                    Enumeration e = this._listeners.elements();
                    while (e.hasMoreElements()) {
                        ConnectionListener listener = (ConnectionListener)e.nextElement();
                        listener.connectionClosed(this);
                    }
                }
            }
        }
    }

    public Node getNode() {
        return this._node;
    }

    public boolean isActive() {
        if (this._isInitialized) {
            return !this._isComplete;
        }
        return false;
    }

    public int getPort() {
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener listener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener listener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (this._listeners.contains(listener)) {
                this._listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthenticationListener(AuthenticationListener listener) {
        Vector vector = this._authenticationlisteners;
        synchronized (vector) {
            if (!this._authenticationlisteners.contains(listener)) {
                this._authenticationlisteners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuthenticationListener(AuthenticationListener listener) {
        Vector vector = this._authenticationlisteners;
        synchronized (vector) {
            if (this._authenticationlisteners.contains(listener)) {
                this._authenticationlisteners.remove(listener);
            }
        }
    }

    protected int processControlMessage(byte[] buffer, int offset, int length) {
        if (this._cmdHandler != null) {
            ControlMessage msg = new ControlMessage();
            int current = -1;
            try {
                current = msg.readFromBuffer(buffer, offset);
                if (current > offset + length) {
                    return -1;
                }
            }
            catch (IndexOutOfBoundsException e) {
                return -1;
            }
            catch (Exception e) {
                return -1;
            }
            if ((long)current == msg.getLength() + (long)offset) {
                int count = msg.getCommandCount();
                for (int i = 0; i < count; ++i) {
                    this._cmdHandler.incommingCommand(this._node, msg.getCommand(i));
                }
            }
            return current;
        }
        return -1;
    }

    class SocketReaderThread
    extends Thread
    implements Constants {
        SocketReaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] buffer = new byte[8096];
            int masterOffset = 0;
            int timeoutCount = 0;
            while (!ConnectionImpl.this._isComplete) {
                boolean incompleteMsg = false;
                try {
                    InputStream inStream = ConnectionImpl.this._socket.getInputStream();
                    int bytesRead = inStream.read(buffer, masterOffset, buffer.length - masterOffset);
                    if (bytesRead == -1) break;
                    if (masterOffset > 0) {
                        bytesRead += masterOffset;
                        masterOffset = 0;
                    }
                    Message incommingMessage = new Message();
                    while (masterOffset < bytesRead) {
                        int i;
                        int newOffset;
                        block22: {
                            newOffset = 0;
                            try {
                                newOffset = incommingMessage.readFromBuffer(buffer, masterOffset);
                                if (newOffset > bytesRead) {
                                    i = masterOffset;
                                    int j = 0;
                                    while (i < bytesRead) {
                                        buffer[j] = buffer[i];
                                        ++i;
                                        ++j;
                                    }
                                    masterOffset = bytesRead - masterOffset;
                                    incompleteMsg = true;
                                }
                                break block22;
                            }
                            catch (IndexOutOfBoundsException e) {
                                int i2 = masterOffset;
                                int j = 0;
                                while (i2 < bytesRead) {
                                    buffer[j] = buffer[i2];
                                    ++i2;
                                    ++j;
                                }
                                masterOffset = bytesRead - masterOffset;
                                incompleteMsg = true;
                            }
                            catch (Exception e) {}
                            break;
                        }
                        if (incommingMessage.getType() == 0L) continue;
                        newOffset = ConnectionImpl.this.processControlMessage(buffer, masterOffset, bytesRead);
                        if (newOffset == -1) {
                            if (masterOffset > 0) {
                                i = masterOffset;
                                int j = 0;
                                while (i < bytesRead) {
                                    buffer[j] = buffer[i];
                                    ++i;
                                    ++j;
                                }
                            } else if (bytesRead == buffer.length) {
                                int len = buffer.length * 2;
                                byte[] tmpbuffer = new byte[len];
                                System.arraycopy(buffer, masterOffset, tmpbuffer, 0, bytesRead - masterOffset);
                                buffer = tmpbuffer;
                            }
                            masterOffset = bytesRead - masterOffset;
                            incompleteMsg = true;
                            break;
                        }
                        masterOffset = newOffset;
                    }
                    if (incompleteMsg) continue;
                    masterOffset = 0;
                }
                catch (InterruptedIOException e) {
                    if (timeoutCount > 6 && !ConnectionImpl.this._isInitialized) {
                        Object object = ConnectionImpl.this._connectionLock;
                        synchronized (object) {
                            ConnectionImpl.this._connectionLock.notifyAll();
                        }
                    }
                    ++timeoutCount;
                }
                catch (SocketException e) {
                    break;
                }
                catch (IOException e) {
                    // empty catch block
                    break;
                }
            }
            ConnectionImpl.this.disconnect();
        }
    }
}

