/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import org.eclipse.hyades.sdb.internal.SDbPluginImages;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EditorPage
implements PaintListener {
    private String title = "";
    private Font titleFont;
    private int TITLE_HMARGIN = 10;
    private int TITLE_VMARGIN = 5;
    private Composite control;
    protected RASWidgetFactory factory;
    private int readOnly;
    private Color headingBackground;
    private Color headingForeground;
    private Image headingImage;
    private boolean headingVisible = true;

    public EditorPage(RASWidgetFactory factory) {
        this.factory = factory;
        this.titleFont = JFaceResources.getHeaderFont();
    }

    public Control getContent(Composite parent) {
        if (this.isWhiteBackground()) {
            this.setHeadingImage(SDbPluginImages.getImage("page_banner.gif"));
        }
        Canvas canvas = new Canvas(parent, 0);
        canvas.setBackground(this.factory.getBackgroundColor());
        canvas.setForeground(this.factory.getForegroundColor());
        canvas.addPaintListener((PaintListener)this);
        canvas.setLayout((Layout)new PageLayout());
        Composite formParent = this.factory.createComposite((Composite)canvas);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        formParent.setLayout((Layout)layout);
        formParent.setLayoutData((Object)new GridData(1808));
        this.createContent(formParent);
        this.control = canvas;
        return canvas;
    }

    public Control getContent() {
        return this.control;
    }

    protected void createContent(Composite parent) {
    }

    public Color getHeadingBackground() {
        return this.headingBackground;
    }

    public Color getHeadingForeground() {
        return this.headingForeground;
    }

    public Image getHeadingImage() {
        return this.headingImage;
    }

    public boolean isHeadingVisible() {
        return this.headingVisible;
    }

    public final void paintControl(PaintEvent event) {
        if (!this.headingVisible) {
            return;
        }
        GC gc = event.gc;
        Control page = (Control)event.widget;
        this.paint(page, gc);
    }

    private void paint(Control form, GC gc) {
        Rectangle bounds = form.getBounds();
        int height = this.getTitleHeight();
        if (this.headingImage != null) {
            Rectangle imageBounds = this.headingImage.getBounds();
            if (this.headingBackground != null) {
                gc.setBackground(this.headingBackground);
                gc.fillRectangle(0, 0, bounds.width, height);
            }
            if (!SWT.getPlatform().equals("motif")) {
                gc.drawImage(this.headingImage, 0, 0);
            }
            if (this.headingForeground != null) {
                gc.setForeground(this.headingForeground);
            } else {
                gc.setForeground(this.factory.getForegroundColor());
            }
            gc.setFont(this.titleFont);
            gc.drawText(this.getTitle(), this.TITLE_HMARGIN, this.TITLE_VMARGIN, true);
        } else {
            gc.setFont(this.titleFont);
            gc.setBackground(this.factory.getColor("__default__header__"));
            gc.setForeground(this.factory.getForegroundColor());
            gc.drawText(this.getTitle(), this.TITLE_HMARGIN, this.TITLE_VMARGIN, true);
        }
    }

    public void setHeadingBackground(Color newHeadingBackground) {
        this.headingBackground = newHeadingBackground;
    }

    public void setHeadingForeground(Color newHeadingForeground) {
        this.headingForeground = newHeadingForeground;
    }

    public void setHeadingImage(Image headingImage) {
        this.headingImage = headingImage;
    }

    public void setHeadingVisible(boolean newHeadingVisible) {
        if (newHeadingVisible != this.headingVisible) {
            this.headingVisible = newHeadingVisible;
            if (this.control != null) {
                this.control.layout(true);
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    private int getTitleHeight() {
        int imageHeight = 0;
        if (this.headingImage != null && !SWT.getPlatform().equals("motif")) {
            imageHeight = this.headingImage.getBounds().height;
        }
        GC gc = new GC((Drawable)this.control);
        gc.setFont(this.titleFont);
        FontMetrics fm = gc.getFontMetrics();
        int fontHeight = fm.getHeight();
        gc.dispose();
        int height = fontHeight + this.TITLE_VMARGIN + this.TITLE_VMARGIN;
        return Math.max(height, imageHeight);
    }

    private boolean isWhiteBackground() {
        Color bg = this.factory.getBackgroundColor();
        return bg.getRed() == 255 && bg.getGreen() == 255 && bg.getBlue() == 255;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
        if (this.control != null) {
            this.control.redraw();
        }
    }

    class PageLayout
    extends Layout {
        PageLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            boolean x = false;
            Control client = composite.getChildren()[0];
            Point csize = client.computeSize(-1, -1, flushCache);
            if (EditorPage.this.headingVisible) {
                csize.y += EditorPage.this.getTitleHeight();
            }
            return csize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle clientArea = composite.getClientArea();
            Control client = composite.getChildren()[0];
            int theight = EditorPage.this.headingVisible ? EditorPage.this.getTitleHeight() : 0;
            client.setBounds(clientArea.x, clientArea.y + theight, clientArea.width, clientArea.height - theight);
        }
    }
}

