/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.Page;

public abstract class TraceViewerPage
extends Page {
    protected TraceViewer _viewer;
    protected EObject _mofObject;
    protected Menu fContextMenu;

    public TraceViewerPage(EObject mofObject, TraceViewer viewer) {
        this._viewer = viewer;
        this._viewer.initializeActionBar();
        this._mofObject = mofObject;
    }

    public EObject getMOFObject() {
        return this._mofObject;
    }

    public TraceViewer getTraceViewer() {
        return this._viewer;
    }

    public abstract void refreshPage();

    public abstract void selectionChanged();

    public void setMofObject(EObject object) {
        this._mofObject = object;
    }

    public abstract void update(boolean var1);

    public void fillContextMenu(IMenuManager menu) {
    }

    public void setContextMenu(Control parent, ISelectionProvider selProvider) {
        if (parent == null || parent.isDisposed()) {
            return;
        }
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this._viewer);
        this.fContextMenu = menuMgr.createContextMenu(parent);
        parent.setMenu(this.fContextMenu);
        IWorkbenchPartSite site = this._viewer.getSite();
        site.registerContextMenu(menuMgr, selProvider);
        site.setSelectionProvider(selProvider);
    }

    public void dispose() {
        super.dispose();
        this._mofObject = null;
        if (this.fContextMenu != null) {
            this.fContextMenu.dispose();
        }
    }

    public boolean isEmpty() {
        return false;
    }
}

