/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.TimeEvent;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ColorImpl;
import org.eclipse.hyades.uml2sd.ui.view.DrawableToolTip;
import org.eclipse.hyades.uml2sd.ui.view.ITimeCompressionListener;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.hyades.uml2sd.ui.view.ScrollView;
import org.eclipse.hyades.uml2sd.util.TimeEventComparator;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class TimeCompressionBar
extends ScrollView
implements DisposeListener {
    private ArrayList listenerList = null;
    private Frame frame = null;
    private List nodeList = null;
    private double min = 0.0;
    private double max = 0.0;
    private float zoomValue = 1.0f;
    private DrawableToolTip c = null;
    private SDWidget sd = null;
    private ColorImpl[] col;
    private Accessible accessible = null;
    protected int focusedWidget = -1;
    protected SDView view = null;

    public TimeCompressionBar(Composite parent, int s) {
        super(parent, s | 0x40000);
        this.setVScrollBarMode(2);
        this.setHScrollBarMode(2);
        this.listenerList = new ArrayList();
        this.col = new ColorImpl[10];
        this.col[0] = new ColorImpl(Display.getDefault(), 255, 229, 229);
        this.col[1] = new ColorImpl(Display.getDefault(), 255, 204, 204);
        this.col[2] = new ColorImpl(Display.getDefault(), 255, 178, 178);
        this.col[3] = new ColorImpl(Display.getDefault(), 255, 153, 153);
        this.col[4] = new ColorImpl(Display.getDefault(), 255, 127, 127);
        this.col[5] = new ColorImpl(Display.getDefault(), 255, 102, 102);
        this.col[6] = new ColorImpl(Display.getDefault(), 255, 76, 76);
        this.col[7] = new ColorImpl(Display.getDefault(), 255, 51, 51);
        this.col[8] = new ColorImpl(Display.getDefault(), 255, 25, 25);
        this.col[9] = new ColorImpl(Display.getDefault(), 255, 0, 0);
        super.addDisposeListener((DisposeListener)this);
        this.accessible = this.getViewControl().getAccessible();
        this.accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID != -1 && e.childID == 0 && TimeCompressionBar.this.c != null) {
                    e.result = TimeCompressionBar.this.c.getText();
                }
            }
        });
        this.accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getFocus(AccessibleControlEvent e) {
                e.childID = TimeCompressionBar.this.focusedWidget == -1 ? -1 : TimeCompressionBar.this.focusedWidget;
            }

            public void getRole(AccessibleControlEvent e) {
                switch (e.childID) {
                    case -1: {
                        e.detail = 10;
                        break;
                    }
                    case 0: {
                        e.detail = 13;
                        break;
                    }
                    case 1: {
                        e.detail = 42;
                    }
                }
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x100000;
                if (e.childID == -1) {
                    e.detail |= 4;
                } else {
                    e.detail |= 0x200000;
                    if (e.childID == TimeCompressionBar.this.focusedWidget) {
                        e.detail |= 0x16;
                    }
                }
            }
        });
    }

    void setFocus(int newFocusShape) {
        this.focusedWidget = newFocusShape;
        if (this.focusedWidget == -1) {
            this.getViewControl().getAccessible().setFocus(-1);
        } else {
            this.getViewControl().getAccessible().setFocus(this.focusedWidget);
        }
    }

    public void setFrame(Frame theFrame) {
        this.frame = theFrame;
        this.min = this.frame.getMinTime();
        this.max = this.frame.getMaxTime();
    }

    protected void drawContents(GC gc, int clipx, int clipy, int clipw, int cliph) {
        List executionOccurrencesWithTime;
        TimeEvent t;
        BaseMessage m;
        int i;
        int firstVisible;
        if (this.frame == null) {
            return;
        }
        this.nodeList = new ArrayList();
        int messageArraysStep = 1;
        if ((float)(Metrics.getMessageFontHeigth() + 20) * this.zoomValue < 2.0f) {
            messageArraysStep = Math.round(1.0f + 1.0f / ((float)(Metrics.getMessageFontHeigth() + 20) * this.zoomValue));
        }
        if ((firstVisible = this.frame.getFirstVisibleSyncMessage()) > 0) {
            --firstVisible;
        }
        for (i = firstVisible; i < this.frame.syncMessageCount(); i += messageArraysStep) {
            m = this.frame.getSyncMessage(i);
            if (!((SyncMessage)m).hasTimeInfo()) continue;
            t = new TimeEvent(((SyncMessage)m).getFirstTime(), m.getEventOccurrence(), (ITimeRange)((Object)m));
            this.nodeList.add(t);
            if ((float)m.getY() * this.zoomValue > (float)(this.getContentsY() + this.getVisibleHeight())) break;
        }
        if ((firstVisible = this.frame.getFirstVisibleSyncMessageReturn()) > 0) {
            --firstVisible;
        }
        for (i = firstVisible; i < this.frame.syncMessageReturnCount(); i += messageArraysStep) {
            m = this.frame.getSyncMessageReturn(i);
            if (!((SyncMessage)m).hasTimeInfo()) continue;
            t = new TimeEvent(((SyncMessage)m).getFirstTime(), m.getEventOccurrence(), (ITimeRange)((Object)m));
            this.nodeList.add(t);
            if ((float)m.getY() * this.zoomValue > (float)(this.getContentsY() + this.getVisibleHeight())) break;
        }
        if ((firstVisible = this.frame.getFirstVisibleAsyncMessage()) > 0) {
            --firstVisible;
        }
        for (i = firstVisible; i < this.frame.asyncMessageCount(); i += messageArraysStep) {
            m = this.frame.getAsyncMessage(i);
            if (!((AsyncMessage)m).hasTimeInfo()) continue;
            t = new TimeEvent(((AsyncMessage)m).getFirstTime(), ((AsyncMessage)m).getStartOccurrence(), (ITimeRange)((Object)m));
            this.nodeList.add(t);
            t = new TimeEvent(((AsyncMessage)m).getLastTime(), ((AsyncMessage)m).getEndOccurrence(), (ITimeRange)((Object)m));
            this.nodeList.add(t);
            if ((float)((AsyncMessage)m).getY() * this.zoomValue > (float)(this.getContentsY() + this.getVisibleHeight())) break;
        }
        if ((firstVisible = this.frame.getFirstVisibleAsyncMessageReturn()) > 0) {
            --firstVisible;
        }
        for (i = firstVisible; i < this.frame.asyncMessageReturnCount(); i += messageArraysStep) {
            m = this.frame.getAsyncMessageReturn(i);
            if (!((AsyncMessage)m).hasTimeInfo()) continue;
            t = new TimeEvent(((AsyncMessage)m).getFirstTime(), ((AsyncMessage)m).getStartOccurrence(), (ITimeRange)((Object)m));
            this.nodeList.add(t);
            t = new TimeEvent(((AsyncMessage)m).getLastTime(), ((AsyncMessage)m).getEndOccurrence(), (ITimeRange)((Object)m));
            this.nodeList.add(t);
            if ((float)((AsyncMessage)m).getY() * this.zoomValue > (float)(this.getContentsY() + this.getVisibleHeight())) break;
        }
        if ((executionOccurrencesWithTime = this.frame.getExecutionOccurrencesWithTime()) != null) {
            this.nodeList.addAll(executionOccurrencesWithTime);
        }
        Object[] temp = this.nodeList.toArray();
        Arrays.sort(temp, new TimeEventComparator());
        this.nodeList = Arrays.asList(temp);
        Image dbuffer = null;
        GC gcim = null;
        if (!SDViewerPlugin.debugDoubleBuffer()) {
            try {
                dbuffer = new Image((Device)this.getDisplay(), this.getClientArea().width, this.getClientArea().height);
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            gcim = new GC(dbuffer);
        } else {
            gcim = gc;
        }
        for (int i2 = 0; i2 < this.nodeList.size() - 1; ++i2) {
            AsyncMessage as;
            int colIndex;
            TimeEvent m1 = (TimeEvent)this.nodeList.get(i2);
            TimeEvent m2 = (TimeEvent)this.nodeList.get(i2 + 1);
            double gr = (this.max - this.min) / 10.0;
            double delta = m2.getTime() - m1.getTime() - this.min;
            ColorImpl color = gr != 0.0 ? ((colIndex = Math.round((float)((delta /= (double)messageArraysStep) / gr))) < this.col.length && colIndex >= 0 ? this.col[colIndex] : (colIndex < 0 ? this.col[0] : this.col[this.col.length - 1])) : this.col[0];
            if (color.getColor() instanceof Color) {
                gcim.setBackground((Color)color.getColor());
            }
            int y1 = ((GraphNode)((Object)m1.getGraphNode())).getY();
            int y2 = ((GraphNode)((Object)m2.getGraphNode())).getY();
            if (m1.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m1.getGraphNode()).getLastTime() == m1.getTime()) {
                y1 += as.getHeight();
            }
            if (m2.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m2.getGraphNode()).getLastTime() == m2.getTime()) {
                y2 += as.getHeight();
            }
            if (m1.getGraphNode() instanceof ExecutionOccurrence) {
                ExecutionOccurrence eo = (ExecutionOccurrence)m1.getGraphNode();
                if (m1.getEvent() == eo.getEndOccurrence()) {
                    y1 += eo.getHeight();
                }
                if (m2.getGraphNode() instanceof ExecutionOccurrence) {
                    ExecutionOccurrence eo2 = (ExecutionOccurrence)m2.getGraphNode();
                    if (m2.getEvent() == eo2.getEndOccurrence()) {
                        y2 += eo2.getHeight();
                    }
                }
            }
            gcim.fillRectangle(this.contentsToViewX(0), this.contentsToViewY(Math.round((float)y1 * this.zoomValue)), 10, Math.round((float)(y2 - y1) * this.zoomValue) + 1);
            if (messageArraysStep != 1) continue;
            Color backupColor = gcim.getForeground();
            gcim.setForeground(Display.getDefault().getSystemColor(1));
            gcim.drawRectangle(this.contentsToViewX(0), this.contentsToViewY(Math.round((float)y1 * this.zoomValue)), 9, Math.round((float)(y2 - y1) * this.zoomValue));
            gcim.setForeground(backupColor);
        }
        if (!SDViewerPlugin.debugDoubleBuffer()) {
            try {
                gc.drawImage(dbuffer, 0, 0, this.getClientArea().width, this.getClientArea().height, 0, 0, this.getClientArea().width, this.getClientArea().height);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            gcim.dispose();
            dbuffer.dispose();
        }
        gc.dispose();
    }

    protected boolean checkFocusOnChilds(Control childs) {
        if (childs instanceof Composite) {
            Control[] child = ((Composite)childs).getChildren();
            for (int i = 0; i < child.length; ++i) {
                if (child[i].isFocusControl()) {
                    return true;
                }
                this.checkFocusOnChilds(child[i]);
            }
        }
        return false;
    }

    public boolean isFocusControl() {
        Control[] child = this.getChildren();
        for (int i = 0; i < child.length; ++i) {
            if (child[i].isFocusControl()) {
                return true;
            }
            this.checkFocusOnChilds(child[i]);
        }
        return false;
    }

    protected void contentsMouseMoveEvent(MouseEvent event) {
        if (this.c != null) {
            this.c.hideToolTip();
        }
        super.contentsMouseMoveEvent(event);
        if (!this.isFocusControl() || this.getViewControl().isFocusControl()) {
            Control[] child = this.getParent().getChildren();
            for (int i = 0; i < child.length; ++i) {
                if (!child[i].isFocusControl()) continue;
                this.getViewControl().setFocus();
                break;
            }
        }
        this.setFocus(-1);
    }

    protected void contentsMouseHover(MouseEvent e) {
        if (this.c == null) {
            this.c = new DrawableToolTip(this);
        }
        if (this.frame != null) {
            this.setFocus(0);
            for (int i = 0; i < this.nodeList.size() - 1; ++i) {
                AsyncMessage as;
                TimeEvent m1 = (TimeEvent)this.nodeList.get(i);
                TimeEvent m2 = (TimeEvent)this.nodeList.get(i + 1);
                int y1 = ((GraphNode)((Object)m1.getGraphNode())).getY();
                int y2 = ((GraphNode)((Object)m2.getGraphNode())).getY();
                if (m1.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m1.getGraphNode()).getLastTime() == m1.getTime()) {
                    y1 += as.getHeight();
                }
                if (m2.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m2.getGraphNode()).getLastTime() == m2.getTime()) {
                    y2 += as.getHeight();
                }
                if (m1.getGraphNode() instanceof ExecutionOccurrence) {
                    ExecutionOccurrence eo = (ExecutionOccurrence)m1.getGraphNode();
                    if (m1.getEvent() == eo.getEndOccurrence()) {
                        y1 += eo.getHeight();
                    }
                    if (m2.getGraphNode() instanceof ExecutionOccurrence) {
                        ExecutionOccurrence eo2 = (ExecutionOccurrence)m2.getGraphNode();
                        if (m2.getEvent() == eo2.getEndOccurrence()) {
                            y2 += eo2.getHeight();
                        }
                    }
                }
                int m1Y = Math.round((float)y1 * this.zoomValue);
                int m2Y = Math.round((float)y2 * this.zoomValue);
                if (m1Y >= e.y || m2Y < e.y) continue;
                double delta = m2.getTime() - m1.getTime();
                if (this.frame != null) {
                    this.c.showToolTip(delta, this.min, this.max, this.frame.getTimeUnitName());
                    continue;
                }
                this.c.showToolTip(delta, this.min, this.max, "");
            }
        }
        this.setFocus(0);
    }

    protected void contentsMouseExit(MouseEvent e) {
        if (this.c != null) {
            this.c.hideToolTip();
        }
    }

    protected void contentsMouseUpEvent(MouseEvent event) {
        if (this.frame != null) {
            for (int i = 0; i < this.nodeList.size() - 1; ++i) {
                AsyncMessage as;
                TimeEvent m1 = (TimeEvent)this.nodeList.get(i);
                TimeEvent m2 = (TimeEvent)this.nodeList.get(i + 1);
                int y1 = ((GraphNode)((Object)m1.getGraphNode())).getY();
                int y2 = ((GraphNode)((Object)m2.getGraphNode())).getY();
                if (m1.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m1.getGraphNode()).getLastTime() == m1.getTime()) {
                    y1 += as.getHeight();
                }
                if (m2.getGraphNode() instanceof AsyncMessage && (as = (AsyncMessage)m2.getGraphNode()).getLastTime() == m2.getTime()) {
                    y2 += as.getHeight();
                }
                if (m1.getGraphNode() instanceof ExecutionOccurrence) {
                    ExecutionOccurrence eo = (ExecutionOccurrence)m1.getGraphNode();
                    if (m1.getEvent() == eo.getEndOccurrence()) {
                        y1 += eo.getHeight();
                    }
                    if (m2.getGraphNode() instanceof ExecutionOccurrence) {
                        ExecutionOccurrence eo2 = (ExecutionOccurrence)m2.getGraphNode();
                        if (m2.getEvent() == eo2.getEndOccurrence()) {
                            y2 += eo2.getHeight();
                        }
                    }
                }
                int m1Y = Math.round((float)y1 * this.zoomValue);
                int m2Y = Math.round((float)y2 * this.zoomValue);
                if (m1Y >= event.y || m2Y < event.y) continue;
                double gr = (this.max - this.min) / 10.0;
                double delta = Math.abs(m2.getTime() - m1.getTime() - this.min);
                int colIndex = 0;
                if (gr != 0.0) {
                    colIndex = Math.round((float)(delta / gr));
                    if (colIndex >= this.col.length) {
                        colIndex = this.col.length - 1;
                    } else if (colIndex < 0) {
                        colIndex = 0;
                    }
                } else {
                    colIndex = 0;
                }
                for (int j = 0; j < this.listenerList.size(); ++j) {
                    ExecutionOccurrence eo;
                    ITimeCompressionListener list = (ITimeCompressionListener)this.listenerList.get(j);
                    if (m1.getGraphNode() instanceof BaseMessage) {
                        BaseMessage mes1 = (BaseMessage)((Object)m1.getGraphNode());
                        if (mes1.getEndLifeline() != null) {
                            list.deltaSelected(mes1.getEndLifeline(), m1.getEvent(), m2.getEvent() - m1.getEvent(), this.col[colIndex]);
                            continue;
                        }
                        if (m2.getGraphNode() instanceof BaseMessage && ((BaseMessage)((Object)m2.getGraphNode())).getStartLifeline() != null) {
                            list.deltaSelected(((BaseMessage)((Object)m2.getGraphNode())).getStartLifeline(), m1.getEvent(), m2.getEvent() - m1.getEvent(), this.col[colIndex]);
                            continue;
                        }
                        list.deltaSelected(mes1.getStartLifeline(), m1.getEvent(), m2.getEvent() - m1.getEvent(), this.col[colIndex]);
                        continue;
                    }
                    if (!(m1.getGraphNode() instanceof ExecutionOccurrence)) continue;
                    if (m2.getGraphNode() instanceof ExecutionOccurrence) {
                        eo = (ExecutionOccurrence)m1.getGraphNode();
                        list.deltaSelected(eo.getLifeline(), m1.getEvent(), m2.getEvent() - m1.getEvent(), this.col[colIndex]);
                        continue;
                    }
                    eo = (ExecutionOccurrence)m1.getGraphNode();
                    list.deltaSelected(eo.getLifeline(), m1.getEvent(), m2.getEvent() - m1.getEvent(), this.col[colIndex]);
                }
            }
        }
        super.contentsMouseUpEvent(event);
    }

    public void highlightRegion(BaseMessage mes1, BaseMessage mes2) {
        AsyncMessage as;
        if (this.frame == null) {
            return;
        }
        if (!(mes1 instanceof ITimeRange)) {
            return;
        }
        if (!(mes2 instanceof ITimeRange)) {
            return;
        }
        ITimeRange t1 = (ITimeRange)((Object)mes1);
        ITimeRange t2 = (ITimeRange)((Object)mes2);
        double time1 = t1.getFirstTime();
        double time2 = t2.getFirstTime();
        int event1 = mes1.getEventOccurrence();
        int event2 = mes2.getEventOccurrence();
        if (mes1 instanceof AsyncMessage) {
            as = (AsyncMessage)mes2;
            time1 = as.getLastTime();
            event1 = as.getEndOccurrence();
        }
        if (mes2 instanceof AsyncMessage) {
            as = (AsyncMessage)mes2;
            if (as.getEndOccurrence() > as.getStartOccurrence()) {
                time1 = as.getLastTime();
                event1 = as.getEndOccurrence();
            } else {
                time1 = as.getFirstTime();
                event1 = as.getStartOccurrence();
            }
        }
        if (event1 > event2) {
            AsyncMessage as2;
            BaseMessage tempMes = mes2;
            mes2 = mes1;
            mes1 = tempMes;
            t1 = (ITimeRange)((Object)mes1);
            t2 = (ITimeRange)((Object)mes2);
            time1 = t1.getFirstTime();
            time2 = t2.getFirstTime();
            event1 = mes1.getEventOccurrence();
            event2 = mes2.getEventOccurrence();
            if (mes1 instanceof AsyncMessage) {
                as2 = (AsyncMessage)mes2;
                time1 = as2.getLastTime();
                event1 = as2.getEndOccurrence();
            }
            if (mes2 instanceof AsyncMessage) {
                as2 = (AsyncMessage)mes2;
                if (as2.getEndOccurrence() > as2.getStartOccurrence()) {
                    time1 = as2.getLastTime();
                    event1 = as2.getEndOccurrence();
                } else {
                    time1 = as2.getFirstTime();
                    event1 = as2.getStartOccurrence();
                }
            }
        }
        double gr = (this.max - this.min) / 10.0;
        double delta = Math.abs(time2 - time1 - this.min);
        int colIndex = 0;
        if (gr != 0.0) {
            colIndex = Math.round((float)(delta / gr));
            if (colIndex >= this.col.length) {
                colIndex = this.col.length - 1;
            } else if (colIndex < 0) {
                colIndex = 0;
            }
        } else {
            colIndex = 0;
        }
        for (int j = 0; j < this.listenerList.size(); ++j) {
            ITimeCompressionListener list = (ITimeCompressionListener)this.listenerList.get(j);
            if (mes1.getEndLifeline() != null) {
                list.deltaSelected(mes1.getEndLifeline(), event1, event2 - event1, this.col[colIndex]);
                continue;
            }
            if (mes2.getStartLifeline() != null) {
                list.deltaSelected(mes2.getStartLifeline(), event1, event2 - event1, this.col[colIndex]);
                continue;
            }
            list.deltaSelected(mes1.getStartLifeline(), event1, event2 - event1, this.col[colIndex]);
        }
    }

    public void highlightRegionSync(final BaseMessage mes1, final BaseMessage mes2) {
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                TimeCompressionBar.this.highlightRegion(mes1, mes2);
            }
        });
    }

    public void scrollBy(int x, int y) {
    }

    public void setZoom(float value) {
        this.zoomValue = value;
        this.redraw();
    }

    public void addTimeCompressionListener(ITimeCompressionListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeSelectionChangedListener(ITimeCompressionListener listener) {
        this.listenerList.remove(listener);
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.c != null) {
            this.c.dispose();
        }
        super.removeDisposeListener((DisposeListener)this);
        for (int i = 0; i < this.col.length; ++i) {
            this.col[i].dispose();
        }
    }
}

