/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ConfigurationItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ContextInstanceTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ContextInstanceSection
extends Composite
implements IDetails,
ModifyListener,
INotifyChangedListener,
SelectionListener {
    protected Text descriptionText;
    protected Button continousBtn;
    protected Text idleText;
    protected Text pauseText;
    protected Label uniqueId;
    protected boolean isDisplaying;
    protected ContextInstanceType currentSelection;
    protected ContextInstanceTypeItemProvider itemProvider;
    protected ConfigurationItemProviderAdapterFactory itemFactory = new ConfigurationItemProviderAdapterFactory();

    public ContextInstanceSection(RuleBuilderWidgetFactory factory, Composite composite, int style) {
        super(composite, style);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        detailLayout.verticalSpacing = 5;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_DESCR"), 0);
        this.descriptionText = factory.createText(this, "", 2);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_ID"), 0);
        this.uniqueId = factory.createLabel(this, "");
        this.uniqueId.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, "", 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.continousBtn = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_CONT"), 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.continousBtn.setLayoutData((Object)data);
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_TIME"), 0);
        this.idleText = factory.createText(this, "", 0);
        this.idleText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_PAUSEI"), 0);
        this.pauseText = factory.createText(this, "", 0);
        this.pauseText.setLayoutData((Object)new GridData(768));
        this.descriptionText.addModifyListener((ModifyListener)this);
        this.idleText.addModifyListener((ModifyListener)this);
        this.pauseText.addModifyListener((ModifyListener)this);
        this.continousBtn.addSelectionListener((SelectionListener)this);
        this.itemProvider = (ContextInstanceTypeItemProvider)this.itemFactory.createContextInstanceTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void display(EObject object) {
        if (object != null) {
            AcadGuiModelManager.setCurrentModel((ContextInstanceType)object);
        }
        if (this.currentSelection == object) {
            return;
        }
        if (this.descriptionText.isFocusControl() || this.uniqueId.isFocusControl() || this.idleText.isFocusControl() || this.pauseText.isFocusControl() || this.continousBtn.isFocusControl()) {
            return;
        }
        this.currentSelection = (ContextInstanceType)object;
        this.isDisplaying = true;
        this.descriptionText.setText(this.currentSelection.getDescription() == null ? "" : this.currentSelection.getDescription());
        this.uniqueId.setText(this.currentSelection.getUniqueID() == null ? "" : this.currentSelection.getUniqueID());
        this.idleText.setText(this.currentSelection.getMaximumIdleTime() == null ? "" : this.currentSelection.getMaximumIdleTime());
        this.pauseText.setText(this.currentSelection.getPauseInterval() == null ? "" : this.currentSelection.getPauseInterval());
        this.continousBtn.setSelection(this.currentSelection.isContinuousOperation());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject currentSelection) {
        this.currentSelection = (ContextInstanceType)currentSelection;
        this.currentSelection.setDescription(this.descriptionText.getText());
        this.currentSelection.setUniqueID(this.uniqueId.getText());
        this.currentSelection.setMaximumIdleTime(this.idleText.getText());
        this.currentSelection.setPauseInterval(this.pauseText.getText());
        this.currentSelection.setContinuousOperation(this.continousBtn.getSelection());
        return false;
    }

    public void setFocusToText() {
        this.descriptionText.setFocus();
        this.descriptionText.selectAll();
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (e.getSource() == this.descriptionText) {
            String text2 = this.descriptionText.getText();
            if (!text2.equals(this.currentSelection.getDescription())) {
                if (text2.length() == 0 && this.currentSelection.getDescription() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextInstanceTypeItemProvider.DESCRIPTION);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text2);
                }
            }
        } else if (e.getSource() == this.uniqueId) {
            String text3 = this.uniqueId.getText();
            if (!text3.equals(this.currentSelection.getUniqueID())) {
                if (text3.length() == 0 && this.currentSelection.getUniqueID() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextInstanceTypeItemProvider.UNIQUE_ID);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text3);
                }
            }
        } else if (e.getSource() == this.idleText) {
            String text4 = this.idleText.getText();
            if (!text4.equals(this.currentSelection.getMaximumIdleTime())) {
                if (text4.length() == 0 && this.currentSelection.getMaximumIdleTime() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextInstanceTypeItemProvider.MAXIMUM_IDLE);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text4);
                }
            }
        } else if (e.getSource() == this.pauseText && !(text = this.pauseText.getText()).equals(this.currentSelection.getPauseInterval())) {
            if (text.length() == 0 && this.currentSelection.getPauseInterval() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextInstanceTypeItemProvider.PAUSE_INTERVAL);
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object obj = notification.getNotifier();
        if (obj == null || obj != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void widgetSelected(SelectionEvent e) {
        boolean value;
        if (e.getSource() == this.continousBtn && (value = this.continousBtn.getSelection()) != this.currentSelection.isContinuousOperation()) {
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ContextInstanceTypeItemProvider.DESCRIPTION);
            String oldValue = this.currentSelection.getDescription();
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)oldValue);
            }
            this.currentSelection.setContinuousOperation(value);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

