/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserConfigTypeItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ParserSection
extends Composite
implements IDetails,
ModifyListener,
INotifyChangedListener {
    protected Text nameText;
    protected Label uniqueId;
    protected Text indexText;
    protected Text designationText;
    protected ParserConfigType currentSelection;
    protected boolean isDisplaying = false;
    protected ParserConfigTypeItemProvider itemProvider;
    protected ParserItemProviderAdapterFactory itemFactory = new ParserItemProviderAdapterFactory();

    public ParserSection(RuleBuilderWidgetFactory factory, Composite composite, int style) {
        super(composite, style);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        detailLayout.verticalSpacing = 5;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PARSER_DESCR"), 0);
        this.nameText = factory.createText(this, "", 0);
        this.nameText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PARSER_ID"), 0);
        this.uniqueId = factory.createLabel(this, "");
        this.uniqueId.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, "", 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PARSER_SEPTOKEN"), 0);
        this.indexText = factory.createText(this, "");
        this.indexText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PARSER_DESTOKEN"), 0);
        this.designationText = factory.createText(this, "");
        this.designationText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, "", 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.nameText.addModifyListener((ModifyListener)this);
        this.indexText.addModifyListener((ModifyListener)this);
        this.designationText.addModifyListener((ModifyListener)this);
        this.itemProvider = (ParserConfigTypeItemProvider)this.itemFactory.createParserConfigTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void setFocusToText() {
        this.nameText.setFocus();
        this.nameText.selectAll();
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
        this.currentSelection = null;
    }

    public void notifyChanged(Notification notification) {
        Object obj = notification.getNotifier();
        if (obj == null || obj != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void display(EObject object) {
        if (this.nameText.isFocusControl() || this.uniqueId.isFocusControl() || this.indexText.isFocusControl() || this.designationText.isFocusControl()) {
            return;
        }
        this.currentSelection = (ParserConfigType)object;
        this.isDisplaying = true;
        this.nameText.setText(this.currentSelection.getDescription() == null ? "" : this.currentSelection.getDescription());
        this.uniqueId.setText(this.currentSelection.getUniqueID() == null ? "" : this.currentSelection.getUniqueID());
        this.indexText.setText(this.currentSelection.getSeparatorToken() == null ? "" : this.currentSelection.getSeparatorToken());
        this.designationText.setText(this.currentSelection.getDesignationToken() == null ? "" : this.currentSelection.getDesignationToken());
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                AcadGuiModelManager.setCurrentModel((ContextInstanceType)ParserSection.this.currentSelection.eContainer());
            }
        });
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject currentSelection) {
        this.currentSelection = (ParserConfigType)currentSelection;
        this.currentSelection.setDescription(this.nameText.getText());
        this.currentSelection.setSeparatorToken(this.indexText.getText());
        this.currentSelection.setDesignationToken(this.designationText.getText());
        return false;
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (e.getSource() == this.indexText) {
            String text2 = this.indexText.getText();
            if (!text2.equals(this.currentSelection.getSeparatorToken())) {
                if (text2.length() == 0 && this.currentSelection.getSeparatorToken() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ParserConfigTypeItemProvider.SEPARATOR);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text2);
                }
            }
        } else if (e.getSource() == this.nameText) {
            String text3 = this.nameText.getText();
            if (!text3.equals(this.currentSelection.getDescription())) {
                if (text3.length() == 0 && this.currentSelection.getDescription() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ParserConfigTypeItemProvider.DESCRIPTION);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text3);
                }
            }
        } else if (e.getSource() == this.designationText && !(text = this.designationText.getText()).equals(this.currentSelection.getDesignationToken())) {
            if (text.length() == 0 && this.currentSelection.getDesignationToken() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, ParserConfigTypeItemProvider.DESIGNATION);
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }
}

