/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.actions.SaveAction;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.log.ui.internal.navigator.NewActionGroup;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.TraceLogActionGroup;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.OpenFileAction;

public class LogNavigatorActionGroup
extends TraceLogActionGroup {
    private OpenFileAction fOpenFileAction;
    private NewActionGroup newActionGroup;
    private SaveAction fLogNavigatorSaveAction;

    public LogNavigatorActionGroup(LogNavigator logNavigator) {
        super((INavigator)logNavigator);
    }

    public void dispose() {
        this.newActionGroup.dispose();
        this.newActionGroup = null;
        this.fOpenFileAction = null;
        super.dispose();
    }

    public void setContext(ActionContext context) {
        if (this.newActionGroup != null) {
            this.newActionGroup.setContext(context);
        }
        super.setContext(context);
    }

    public void fillContextMenu(IMenuManager menu) {
        boolean multiSelection;
        super.fillContextMenu(menu);
        this.newActionGroup.fillContextMenu(menu);
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean sameClass = false;
        boolean bl = multiSelection = selection.size() > 1;
        if (multiSelection) {
            sameClass = this.areSameClass(selection);
        }
        Object sel = null;
        if (selection.iterator().hasNext()) {
            sel = selection.iterator().next();
        }
        this.updateActions(selection);
        if (sel != null) {
            if (sel instanceof LogicalFolder) {
                menu.appendToGroup("group.save", (IAction)this.fLogNavigatorSaveAction);
            } else if (sel instanceof TRCAgentProxy) {
                if (!multiSelection || sameClass) {
                    menu.appendToGroup("group.additions", (IContributionItem)this.fMonitorGrp);
                    menu.appendToGroup("group.additions", (IContributionItem)this.fGCGroup);
                    menu.appendToGroup("group.additions", (IContributionItem)this.fAttachGrp);
                }
                if (!multiSelection) {
                    menu.appendToGroup("group.additions", (IContributionItem)this.fNewSnapshotGrp);
                    menu.appendToGroup("group.additions", (IContributionItem)this.fTerminateGrp);
                    menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
                    this.addViews(menu, sel);
                }
                menu.appendToGroup("group.delete", (IAction)this.fDeleteAction);
                menu.appendToGroup("group.save", (IAction)this.fLogNavigatorSaveAction);
            } else if (sel instanceof CorrelationContainerProxy) {
                if (!multiSelection) {
                    menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
                    this.addViews(menu, sel);
                }
                menu.appendToGroup("group.delete", (IAction)this.fDeleteAction);
                menu.appendToGroup("group.save", (IAction)this.fLogNavigatorSaveAction);
            } else if (sel instanceof IFile) {
                menu.appendToGroup("org.eclipse.ui.OpenWithSubMenu", (IAction)this.fOpenFileAction);
                this.fOpenFileAction.selectionChanged((IStructuredSelection)this.getContext().getSelection());
                menu.appendToGroup("group.delete", (IAction)this.fDeleteAction);
                menu.appendToGroup("group.save", (IAction)this.fLogNavigatorSaveAction);
            } else if (sel instanceof TRCNode) {
                menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
                this.addViews(menu, sel);
                menu.appendToGroup("group.additions", (IContributionItem)this.fRefreshGrp);
            } else if (sel instanceof INavigatorItem) {
                menu.appendToGroup("group.delete", (IAction)this.fDeleteAction);
                menu.appendToGroup("group.save", (IAction)this.fLogNavigatorSaveAction);
                menu.appendToGroup("group.additions", (IContributionItem)new Separator("group.add.views"));
                this.addViews(menu, sel);
                menu.appendToGroup("group.additions", (IContributionItem)this.fRefreshGrp);
            }
        }
        menu.appendToGroup("group.refresh", (IAction)this.fRefreshTree);
        menu.appendToGroup("group.refresh", (IAction)this.fRefreshLocal);
        if (!multiSelection) {
            if (sel instanceof TRCAgentProxy) {
                if (((TRCAgentProxy)sel).getType().equals("Logging")) {
                    menu.appendToGroup("group.properties", (IAction)this.fOpenLogAgentAction);
                }
            } else if (sel instanceof TRCNode) {
                menu.appendToGroup("group.properties", (IAction)this.fOpenNodeAction);
            }
        }
        this.fImportActionGroup.fillContextMenu(menu);
    }

    protected void addViews(IMenuManager menu, Object obj) {
        block9: {
            MenuManager popup;
            block11: {
                block10: {
                    block8: {
                        if (obj == null || !(obj instanceof EObject) && !(obj instanceof INavigatorItem)) {
                            return;
                        }
                        popup = new MenuManager(UIPlugin.getResourceString((String)"MENU_MANAGER"));
                        menu.appendToGroup("group.add.views", (IContributionItem)popup);
                        if (!(obj instanceof TRCAgentProxy)) break block8;
                        IAction[] actions = this.getViewMappingForType(((TRCAgentProxy)obj).getType());
                        for (int idx = 0; idx < actions.length; ++idx) {
                            if (actions[idx] == null) continue;
                            popup.add(actions[idx]);
                        }
                        break block9;
                    }
                    if (!(obj instanceof CorrelationContainerProxy)) break block10;
                    IAction[] actions = this.getViewMappingForType("Logging");
                    for (int idx = 0; idx < actions.length; ++idx) {
                        if (actions[idx] == null) continue;
                        popup.add(actions[idx]);
                    }
                    break block9;
                }
                if (!(obj instanceof TRCNode)) break block11;
                IAction[] actions = this.getViewMappingForType("Host");
                for (int idx = 0; idx < actions.length; ++idx) {
                    if (actions[idx] == null) continue;
                    popup.add(actions[idx]);
                }
                ArrayList<String> typesList = new ArrayList<String>();
                EList processes = ((TRCNode)obj).getProcessProxies();
                for (int i = 0; i < processes.size(); ++i) {
                    TRCProcessProxy process = (TRCProcessProxy)processes.get(i);
                    EList agents = process.getAgentProxies();
                    for (int j = 0; j < agents.size(); ++j) {
                        TRCAgentProxy agent = (TRCAgentProxy)agents.get(j);
                        if (typesList.contains(agent.getType())) continue;
                        typesList.add(agent.getType());
                        actions = this.getViewMappingForType(agent.getType());
                        if (actions.length <= 0) continue;
                        popup.add((IContributionItem)new Separator());
                        for (int k = 0; k < actions.length; ++k) {
                            popup.add(actions[k]);
                        }
                    }
                }
                break block9;
            }
            if (!(obj instanceof INavigatorItem)) break block9;
            IAction[] actions = this.getViewMappingForType(((INavigatorItem)obj).getType());
            for (int idx = 0; idx < actions.length; ++idx) {
                if (actions[idx] == null) continue;
                popup.add(actions[idx]);
            }
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.newActionGroup != null) {
            this.newActionGroup.fillActionBars(actionBars);
        }
        super.fillActionBars(actionBars);
    }

    public void handleKeyPressed(KeyEvent event) {
        super.handleKeyPressed(event);
    }

    protected void createActions() {
        super.createActions();
        this.fOpenFileAction = new OpenFileAction(this.getNavigator().getSite().getPage());
        this.fLogNavigatorSaveAction = new SaveAction(this.getNavigator());
    }

    protected void createActionGroups() {
        super.createActionGroups();
        this.newActionGroup = new NewActionGroup((Navigator)((LogNavigator)this.getNavigator()));
    }

    public void handleDoubleClick(DoubleClickEvent event) {
        super.handleDoubleClick(event);
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object obj = s.getFirstElement();
        if (obj instanceof IFile) {
            this.fOpenFileAction.selectionChanged(s);
            this.fOpenFileAction.run();
        }
    }
}

