/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import java.text.MessageFormat;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.DatapoolUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class DatapoolRowDialog
extends Dialog {
    private static final String TAG_EQUIVALENCE_CLASSES = "equivalenceClasses";
    private static final String TAG_EQUIVALENCE_CLASS = "equivalenceClass";
    private static final String TAG_RECORD = "record";
    private static final int HEIGHT = 40;
    private static final int WIDTH = 400;
    private Shell shell = null;
    private IDatapool datapool = null;
    private String title = null;
    private boolean insertionMode = false;
    private Table table = null;
    private TableItem previousTableItem = null;
    private TableItem selectedTableItem = null;
    private Combo equivalenceClassCombo = null;
    private Combo recordIndexCombo = null;
    private int insertionEquivalenceClassIndex = -1;
    private int insertionRecordIndex = -1;
    private TableItem insertionTableItem = null;
    private boolean showEquivalenceClasses = true;
    private SelectionListener equivalenceClassListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            IDatapoolEquivalenceClass equivalenceClass = null;
            Combo combo = (Combo)e.widget;
            DatapoolRowDialog.this.insertionEquivalenceClassIndex = combo.getSelectionIndex();
            IDatapoolEquivalenceClass[] equivalenceClasses = (IDatapoolEquivalenceClass[])combo.getData(DatapoolRowDialog.TAG_EQUIVALENCE_CLASSES);
            equivalenceClass = equivalenceClasses[DatapoolRowDialog.this.insertionEquivalenceClassIndex];
            String[] recordIndexLabels = DatapoolRowDialog.this.getRecordIndexLabels(equivalenceClass);
            DatapoolRowDialog.this.recordIndexCombo.setItems(recordIndexLabels);
            DatapoolRowDialog.this.recordIndexCombo.select(0);
            DatapoolRowDialog.this.insertionRecordIndex = -1;
            DatapoolRowDialog.this.recordIndexCombo.setData(DatapoolRowDialog.TAG_EQUIVALENCE_CLASS, (Object)equivalenceClass);
            DatapoolRowDialog.this.enableOK();
        }
    };
    private SelectionListener recordIndexListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Combo combo = (Combo)e.widget;
            DatapoolRowDialog.this.insertionRecordIndex = combo.getSelectionIndex() - 1;
            DatapoolRowDialog.this.enableOK();
        }
    };

    public DatapoolRowDialog(Shell parentShell, IDatapool datapool, Table table, TableItem selectedTableItem, TableItem previousTableItem, String title, boolean showEquivalenceClasses) {
        super(parentShell);
        this.shell = parentShell;
        this.datapool = datapool;
        this.title = title;
        this.table = table;
        this.selectedTableItem = selectedTableItem;
        this.previousTableItem = previousTableItem;
        if (title.equals(DatapoolPlugin.getResourceString("DATA_ROW_DLG_TITLE_INS"))) {
            this.insertionMode = true;
        }
        this.showEquivalenceClasses = showEquivalenceClasses;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.enableOK();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite superComposite = (Composite)super.createDialogArea(parent);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 40;
        gridData.widthHint = 400;
        superComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        superComposite.setLayout((Layout)gridLayout);
        if (this.showEquivalenceClasses) {
            Label equivalenceClassLabel = new Label(superComposite, 0);
            if (this.insertionMode) {
                equivalenceClassLabel.setText(DatapoolPlugin.getResourceString("DATA_ROW_DLG_INS_INTO"));
            } else {
                equivalenceClassLabel.setText(DatapoolPlugin.getResourceString("DATA_ROW_DLG_MOVE_INTO"));
            }
            this.equivalenceClassCombo = new Combo(superComposite, 12);
            IDatapoolEquivalenceClass[] equivalenceClasses = DatapoolUtil.getInstance().getEquivalenceClasses(this.datapool, null);
            String[] equivalenceClassLabels = this.getEquivalenceClassLabels(equivalenceClasses);
            this.equivalenceClassCombo.setItems(equivalenceClassLabels);
            this.equivalenceClassCombo.setData(TAG_EQUIVALENCE_CLASSES, (Object)equivalenceClasses);
            gridData = new GridData(256);
            gridData.horizontalSpan = 1;
            gridData.widthHint = 150;
            this.equivalenceClassCombo.setLayoutData((Object)gridData);
            this.equivalenceClassCombo.addSelectionListener(this.equivalenceClassListener);
        }
        Label recordIndexLabel = new Label(superComposite, 0);
        if (this.showEquivalenceClasses) {
            recordIndexLabel.setText(DatapoolPlugin.getResourceString("DATA_ROW_DLG_INDEX"));
        } else {
            recordIndexLabel.setText(DatapoolPlugin.getResourceString("DATA_DLG_MOVE"));
        }
        IDatapoolEquivalenceClass selectedEquivalenceClass = null;
        IDatapoolRecord selectedRecord = null;
        IDatapoolEquivalenceClass previousEquivalenceClass = null;
        IDatapoolRecord previousRecord = null;
        if (this.selectedTableItem != null) {
            selectedEquivalenceClass = (IDatapoolEquivalenceClass)this.selectedTableItem.getData(TAG_EQUIVALENCE_CLASS);
            selectedRecord = (IDatapoolRecord)this.selectedTableItem.getData(TAG_RECORD);
        }
        if (this.previousTableItem != null) {
            previousEquivalenceClass = (IDatapoolEquivalenceClass)this.previousTableItem.getData(TAG_EQUIVALENCE_CLASS);
            previousRecord = (IDatapoolRecord)this.previousTableItem.getData(TAG_RECORD);
        }
        String[] recordIndexLabels = null;
        recordIndexLabels = this.insertionMode ? this.getRecordIndexLabels(previousEquivalenceClass) : this.getRecordIndexLabels(selectedEquivalenceClass);
        this.recordIndexCombo = new Combo(superComposite, 12);
        if (recordIndexLabels != null) {
            this.recordIndexCombo.setItems(recordIndexLabels);
        }
        this.recordIndexCombo.setData(TAG_EQUIVALENCE_CLASS, (Object)previousEquivalenceClass);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 55;
        this.recordIndexCombo.setLayoutData((Object)gridData);
        this.recordIndexCombo.addSelectionListener(this.recordIndexListener);
        if (!(this.insertionMode || previousEquivalenceClass != null && previousEquivalenceClass.equals(selectedEquivalenceClass))) {
            int selectedEquivalenceClassIndex = this.datapool.getEquivalenceClassIndexById(selectedEquivalenceClass.getId());
            if (selectedEquivalenceClassIndex != -1) {
                if (this.equivalenceClassCombo != null) {
                    this.equivalenceClassCombo.select(selectedEquivalenceClassIndex);
                }
                this.insertionEquivalenceClassIndex = selectedEquivalenceClassIndex;
            }
            this.recordIndexCombo.select(0);
            this.insertionRecordIndex = -1;
        } else {
            int previousEquivalenceClassIndex = this.datapool.getEquivalenceClassIndexById(previousEquivalenceClass.getId());
            int previousRecordIndex = this.getRecordIndex(previousEquivalenceClass, previousRecord);
            if (previousRecordIndex != -1) {
                this.recordIndexCombo.select(previousRecordIndex + 1);
                this.insertionRecordIndex = previousRecordIndex;
            }
            if (previousEquivalenceClassIndex != -1) {
                if (this.equivalenceClassCombo != null) {
                    this.equivalenceClassCombo.select(previousEquivalenceClassIndex);
                }
                this.insertionEquivalenceClassIndex = previousEquivalenceClassIndex;
            }
        }
        return superComposite;
    }

    private boolean enableOK() {
        this.getButton(0).setEnabled(true);
        return true;
    }

    private String[] getEquivalenceClassLabels(IDatapoolEquivalenceClass[] equivalenceClasses) {
        if (equivalenceClasses == null) {
            return null;
        }
        int listSize = equivalenceClasses.length;
        String[] returnList = new String[listSize];
        for (int i = 0; i < listSize; ++i) {
            IDatapoolEquivalenceClass equivalenceClass = equivalenceClasses[i];
            returnList[i] = equivalenceClass.getName();
        }
        return returnList;
    }

    private String[] getRecordIndexLabels(IDatapoolEquivalenceClass equivalenceClass) {
        int listSize = 0;
        if (equivalenceClass != null) {
            listSize = equivalenceClass.getRecordCount();
        }
        String[] returnList = new String[listSize + 1];
        String insertFormat = DatapoolPlugin.getResourceString("DATA_DLG_INSERT_VARIABLE_FORMAT");
        for (int i = 0; i < listSize; ++i) {
            Object[] messageElements;
            String recordIndex = String.valueOf(i);
            if (i == 0) {
                messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_DLG_BEFORE"), new Integer(recordIndex)};
                returnList[i] = MessageFormat.format(insertFormat, messageElements);
            }
            messageElements = new Object[]{DatapoolPlugin.getResourceString("DATA_DLG_AFTER"), new Integer(recordIndex)};
            returnList[i + 1] = MessageFormat.format(insertFormat, messageElements);
        }
        if (listSize == 0) {
            returnList[0] = DatapoolPlugin.getResourceString("DATA_DLG_FIRST_ELEMENT");
        }
        return returnList;
    }

    private int findEquivalenceClassIndexInCombo(IDatapoolEquivalenceClass[] equivalenceClasses, IDatapoolEquivalenceClass equivalenceClass) {
        if (equivalenceClasses == null || equivalenceClass == null) {
            return -1;
        }
        for (int i = 0; i < equivalenceClasses.length; ++i) {
            if (!equivalenceClasses[i].equals(equivalenceClass)) continue;
            return i;
        }
        return -1;
    }

    public int getInsertionEquivalenceClassIndex() {
        return this.insertionEquivalenceClassIndex;
    }

    public int getInsertionRecordIndex() {
        return this.insertionRecordIndex;
    }

    private int getRecordIndex(IDatapoolEquivalenceClass equivalenceClass, IDatapoolRecord record) {
        for (int i = 0; i < equivalenceClass.getRecordCount(); ++i) {
            org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord compRecord = equivalenceClass.getRecord(i);
            if (!compRecord.equals(record)) continue;
            return i;
        }
        return -1;
    }
}

