/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.logging.core.SerializationException;
import org.w3c.dom.Document;

public class XmlUtility
implements Constants {
    private static boolean isJavaXMLTransformerAvailable = true;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Writer;
    static /* synthetic */ Class class$org$w3c$dom$Document;

    public static void serialize(Document document, File file) throws SerializationException {
        XmlUtility.serialize(document, file, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void serialize(Document document, File file, boolean bl) throws SerializationException {
        FileWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(file);
                XmlUtility.serialize(document, fileWriter, bl);
            }
            catch (Exception exception) {
                throw new SerializationException(exception.toString());
            }
            Object var6_4 = null;
            if (fileWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (fileWriter == null) throw throwable;
            try {
                fileWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fileWriter.close();
        return;
    }

    public static String serialize(Document document) throws SerializationException {
        return XmlUtility.serialize(document, true);
    }

    public static String serialize(Document document, boolean bl) throws SerializationException {
        StringWriter stringWriter = new StringWriter();
        try {
            XmlUtility.serialize(document, stringWriter, bl);
        }
        catch (Exception exception) {
            throw new SerializationException(exception.toString());
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (IOException iOException) {}
        }
        return stringWriter.toString();
    }

    public static byte[] serializeAsByteArray(Document document) throws SerializationException {
        return XmlUtility.serializeAsByteArray(document, true);
    }

    public static byte[] serializeAsByteArray(Document document, boolean bl) throws SerializationException {
        return XmlUtility.serialize(document, bl).getBytes();
    }

    public static void serialize(Document document, Writer writer) throws SerializationException {
        XmlUtility.serialize(document, writer, true);
    }

    public static void serialize(Document document, Writer writer, boolean bl) throws SerializationException {
        if (isJavaXMLTransformerAvailable) {
            try {
                JavaXMLTransformer.serialize(document, writer, bl);
                return;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                isJavaXMLTransformerAvailable = false;
            }
            catch (Exception exception) {
                throw new SerializationException(exception.toString());
            }
        }
        try {
            XercesXMLSerializer.serialize(document, writer, bl);
        }
        catch (Exception exception) {
            throw new SerializationException(exception.toString());
        }
    }

    public static String normalize(String string) {
        if (string == null) {
            return "null";
        }
        if (string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            if (c == '\t') {
                stringBuffer.append("&#x9;");
                continue;
            }
            if (c == '\n') {
                stringBuffer.append("&#xA;");
                continue;
            }
            if (c == '\r') {
                stringBuffer.append("&#xD;");
                continue;
            }
            if (c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('?');
        }
        return stringBuffer.toString();
    }

    public static String denormalize(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        int n = -1;
        String string2 = null;
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c == '&' && (n = string.indexOf(59, i + 1)) != -1) {
                string2 = string.substring(i + 1, n).trim();
                if (string2.equals("lt")) {
                    stringBuffer.append('<');
                } else if (string2.equals("gt")) {
                    stringBuffer.append('>');
                } else if (string2.equals("amp")) {
                    stringBuffer.append('&');
                } else if (string2.equals("quot")) {
                    stringBuffer.append('\"');
                } else if (string2.equals("apos")) {
                    stringBuffer.append('\'');
                } else if (string2.equals("#x9")) {
                    stringBuffer.append('\t');
                } else if (string2.equals("#xA")) {
                    stringBuffer.append('\n');
                } else if (string2.equals("#xD")) {
                    stringBuffer.append('\r');
                } else {
                    stringBuffer.append('&');
                    stringBuffer.append(string2);
                    stringBuffer.append(';');
                }
                i = n;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class XercesXMLSerializer
    implements Constants {
        private static Object outputFormat = null;

        private XercesXMLSerializer() {
        }

        private static void serialize(Document document, Writer writer, boolean bl) throws Exception {
            Class<?> clazz;
            if (outputFormat == null) {
                clazz = Class.forName("org.apache.xml.serialize.OutputFormat");
                outputFormat = clazz.newInstance();
                clazz.getMethod("setMethod", class$java$lang$String == null ? (class$java$lang$String = XmlUtility.class$("java.lang.String")) : class$java$lang$String).invoke(outputFormat, "xml");
                if (Constants.OS_NAME.equals("z/OS") || Constants.OS_NAME.equals("OS/390")) {
                    clazz.getMethod("setEncoding", class$java$lang$String == null ? (class$java$lang$String = XmlUtility.class$("java.lang.String")) : class$java$lang$String).invoke(outputFormat, "IBM-1047");
                } else {
                    clazz.getMethod("setEncoding", class$java$lang$String == null ? (class$java$lang$String = XmlUtility.class$("java.lang.String")) : class$java$lang$String).invoke(outputFormat, "UTF-8");
                }
                clazz.getMethod("setLineWidth", Integer.TYPE).invoke(outputFormat, new Integer(Integer.MAX_VALUE));
            }
            if (bl) {
                outputFormat.getClass().getMethod("setIndent", Integer.TYPE).invoke(outputFormat, new Integer(2));
            } else {
                outputFormat.getClass().getMethod("setIndent", Integer.TYPE).invoke(outputFormat, new Integer(0));
            }
            clazz = Class.forName("org.apache.xml.serialize.XMLSerializer");
            Object obj = clazz.getConstructor(class$java$io$Writer == null ? (class$java$io$Writer = XmlUtility.class$("java.io.Writer")) : class$java$io$Writer, outputFormat.getClass()).newInstance(writer, outputFormat);
            clazz.getMethod("serialize", class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = XmlUtility.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document).invoke(obj, document);
        }
    }

    private static class JavaXMLTransformer
    implements Constants {
        private static Transformer transformer = null;

        private JavaXMLTransformer() {
        }

        private static void serialize(Document document, Writer writer, boolean bl) throws Exception {
            if (transformer == null) {
                transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                if (Constants.OS_NAME.equals("z/OS") || Constants.OS_NAME.equals("OS/390")) {
                    transformer.setOutputProperty("encoding", "IBM-1047");
                } else {
                    transformer.setOutputProperty("encoding", "UTF-8");
                }
            }
            if (bl) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            } else {
                transformer.setOutputProperty("indent", "no");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "0");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "0");
            }
            transformer.transform(new DOMSource(document), new StreamResult(writer));
        }
    }
}

