/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.hyades.probekit.internal.JarReader;
import org.eclipse.hyades.probekit.internal.JarWriter;

public class ProbeInstrumenter {
    boolean verbose = false;
    String exePath = null;
    String newline = System.getProperty("line.separator");
    static final String COMPILER_PLUGIN_NAME = "org.eclipse.hyades.probekit";
    static final String INSERTION_EXECUTABLE_BASENAME = "probeinstrumenter";
    private File scriptFile;
    String errorString = "";
    int classFilesBatchSize = 10;

    public static void main(String[] stringArray) {
        int n;
        String string = "";
        ProbeInstrumenter probeInstrumenter = new ProbeInstrumenter();
        try {
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].equals("-v")) {
                    if (stringArray[n].equals("-h")) {
                        throw new Exception("");
                    }
                    if (!stringArray[n].startsWith("-")) break;
                    throw new Exception("Unrecognized option " + stringArray[n]);
                }
                probeInstrumenter.setVerbose(true);
            }
            if (stringArray.length - n < 2) {
                throw new Exception("Not enough arguments.");
            }
            string = stringArray[n];
            if (!new File(string).exists()) {
                throw new Exception("First argument (script file) does not exist.");
            }
        }
        catch (Exception exception) {
            System.out.println("Usage error: " + exception);
            System.out.println("Usage: ProbeInstrumenter engine_script item [item ...]");
            System.out.println("Where \"items\" may be class files, jar files, or directories.");
            System.out.println("Directories are processed recursively, instrumenting all jar and");
            System.out.println("class files found within.");
            return;
        }
        String[] stringArray2 = new String[stringArray.length - ++n];
        for (int i = 0; i < stringArray.length - n; ++i) {
            stringArray2[i] = stringArray[n + i];
        }
        try {
            probeInstrumenter.SetExePath(INSERTION_EXECUTABLE_BASENAME);
            probeInstrumenter.instrumentItems(new File(string), stringArray2, true);
        }
        catch (StaticProbeInstrumenterException staticProbeInstrumenterException) {
            System.err.println(staticProbeInstrumenterException);
        }
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void SetExePath(String string) {
        this.exePath = string;
    }

    void SetExePathFromPlugin() throws StaticProbeInstrumenterException {
        this.SetExePath(ProbeInstrumenterInner.getExeName());
    }

    public void instrumentItems(File file, String[] stringArray, boolean bl) throws StaticProbeInstrumenterException {
        this.scriptFile = file;
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                File file2 = new File(stringArray[i]);
                if (!file2.exists()) {
                    throw new StaticProbeInstrumenterException("no such file or directory");
                }
                if (stringArray[i].endsWith(".class")) {
                    this.processClassFile(file2, bl);
                    continue;
                }
                if (stringArray[i].endsWith(".jar")) {
                    this.processJarFile(file2, bl);
                    continue;
                }
                if (!file2.isDirectory()) continue;
                this.processDirectory(file2, bl);
                continue;
            }
            catch (StaticProbeInstrumenterException staticProbeInstrumenterException) {
                string = string + "Item \"" + stringArray[i] + "\": " + staticProbeInstrumenterException + this.newline;
            }
        }
        if (string.length() > 0) {
            throw new StaticProbeInstrumenterException(string);
        }
        if (this.verbose) {
            System.out.println("Finished.");
        }
    }

    void processClassFiles(List list, boolean bl) throws StaticProbeInstrumenterException {
        if (this.verbose) {
            System.out.println("(Class file list)");
        }
        try {
            String[] stringArray;
            String[] stringArray2 = new String[2 + list.size()];
            if (this.exePath == null) {
                this.SetExePathFromPlugin();
            }
            stringArray2[0] = this.exePath;
            stringArray2[1] = this.scriptFile.getCanonicalPath();
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (!(e instanceof File)) {
                    throw new StaticProbeInstrumenterException("Internal error: processClassFiles with a non-File list element");
                }
                stringArray2[i + 2] = ((File)e).getAbsolutePath();
            }
            try {
                stringArray = this.executeCommandAndWait(stringArray2);
            }
            catch (IOException iOException) {
                throw new StaticProbeInstrumenterException("Error executing instrumenter - not on path? " + this.newline + "Tried \"" + stringArray2[0] + "\"" + this.newline);
            }
            for (int i = 0; i < list.size(); ++i) {
                File file = (File)list.get(i);
                File file2 = new File(file.getAbsolutePath() + ".bci");
                if (!file2.exists()) {
                    throw new StaticProbeInstrumenterException("Instrumenting " + file.getAbsolutePath() + " did not result in a *.bci file." + this.newline + "Instrumenter error output follows:" + this.newline + stringArray[1]);
                }
                if (bl) {
                    File file3 = new File(file.getAbsolutePath() + ".bak");
                    file3.delete();
                    if (!file.renameTo(file3)) {
                        throw new StaticProbeInstrumenterException("Failed to rename " + file.getAbsolutePath() + " to *.bak");
                    }
                } else {
                    file.delete();
                }
                if (file2.renameTo(file)) continue;
                throw new StaticProbeInstrumenterException("Failed to rename " + file2.getAbsolutePath() + " to *.class");
            }
        }
        catch (IOException iOException) {
            throw new StaticProbeInstrumenterException("I/O error in class file batch: " + iOException.getMessage() + this.newline);
        }
    }

    void processClassFile(File file, boolean bl) throws StaticProbeInstrumenterException {
        if (this.verbose) {
            System.out.println("Class file " + file.getName());
        }
        String string = "";
        try {
            try {
                string = file.getAbsolutePath();
                String[] stringArray = new String[3];
                if (this.exePath == null) {
                    this.SetExePathFromPlugin();
                }
                stringArray[0] = this.exePath;
                stringArray[1] = this.scriptFile.getAbsolutePath();
                stringArray[2] = string;
                String[] stringArray2 = this.executeCommandAndWait(stringArray);
                File file2 = new File(file.getAbsolutePath() + ".bci");
                if (!file2.exists()) {
                    throw new StaticProbeInstrumenterException("Instrumenting " + file.getAbsolutePath() + " did not result in a *.bci file." + "Instrumenter error output follows:" + this.newline + stringArray2[1]);
                }
                if (bl) {
                    File file3 = new File(file.getAbsolutePath() + ".bak");
                    file3.delete();
                    if (!file.renameTo(file3)) {
                        throw new StaticProbeInstrumenterException("Failed to rename " + file.getAbsolutePath() + " to *.bak");
                    }
                } else {
                    file.delete();
                }
                if (!file2.renameTo(file)) {
                    throw new StaticProbeInstrumenterException("Failed to rename " + file2.getAbsolutePath() + " to *.class");
                }
            }
            catch (IOException iOException) {
                throw new StaticProbeInstrumenterException(iOException.getMessage());
            }
        }
        catch (StaticProbeInstrumenterException staticProbeInstrumenterException) {
            throw new StaticProbeInstrumenterException("Error processing class file " + string + ": " + staticProbeInstrumenterException.getMessage() + this.newline);
        }
    }

    void processJarFile(File file, boolean bl) throws StaticProbeInstrumenterException {
        if (this.verbose) {
            System.out.println("Jar file " + file.getName());
        }
        File file2 = null;
        try {
            Object object;
            file2 = File.createTempFile("probetemp-", "");
            if (!file2.delete() || !file2.mkdir()) {
                throw new StaticProbeInstrumenterException("Some problem managing temporary/batch files" + this.newline);
            }
            JarReader jarReader = new JarReader(file);
            Manifest manifest = jarReader.getManifest();
            jarReader.extractAll(file2);
            jarReader.close();
            this.processDirectory(file2, false);
            if (manifest != null) {
                ProbeInstrumenter.stripManifest(manifest);
            }
            if (this.verbose) {
                System.out.println("Repack " + file.getName());
            }
            if (bl) {
                object = new File(file.getCanonicalPath() + ".bak");
                ((File)object).delete();
                if (((File)object).exists()) {
                    throw new StaticProbeInstrumenterException("Unable to delete backup jar file: " + ((File)object).getCanonicalPath() + this.newline);
                }
                if (!file.renameTo((File)object)) {
                    throw new StaticProbeInstrumenterException("Unable to rename jar file to *.bak: " + file.getCanonicalPath() + this.newline);
                }
            } else {
                file.delete();
                if (file.exists()) {
                    throw new StaticProbeInstrumenterException("Unable to delete/overwrite jar file: " + file.getCanonicalPath() + this.newline);
                }
            }
            object = new JarWriter(file, manifest, null);
            ((JarWriter)object).write(file2, "", true);
            ((JarWriter)object).close();
            return;
        }
        catch (IOException iOException) {
            throw new StaticProbeInstrumenterException("I/O Exception processing jar file " + file.getAbsolutePath() + ": " + iOException.getClass() + iOException.getMessage() + this.newline);
        }
        finally {
            this.recursiveDelete(file2);
        }
    }

    void processDirectory(File file, boolean bl) throws StaticProbeInstrumenterException {
        if (this.verbose) {
            System.out.println("Directory " + file.getName());
        }
        if (!file.isDirectory()) {
            throw new StaticProbeInstrumenterException("non-directory passed to processDirectory" + this.newline);
        }
        String string = "";
        File[] fileArray = file.listFiles();
        Vector<File> vector = new Vector<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                if (fileArray[i].isDirectory()) {
                    this.processDirectory(fileArray[i], bl);
                } else if (fileArray[i].getName().endsWith(".class")) {
                    vector.add(fileArray[i]);
                } else if (fileArray[i].getName().endsWith(".jar")) {
                    this.processJarFile(fileArray[i], bl);
                }
                if (i != fileArray.length - 1 && vector.size() != this.classFilesBatchSize) continue;
                this.processClassFiles(vector, bl);
                vector.clear();
                continue;
            }
            catch (StaticProbeInstrumenterException staticProbeInstrumenterException) {
                String string2 = System.getProperty("line.separator");
                string = string + "Error processing directory " + file.getAbsolutePath() + ": " + string2 + staticProbeInstrumenterException + string2;
            }
        }
        if (string.length() > 0) {
            throw new StaticProbeInstrumenterException(string);
        }
    }

    boolean recursiveDelete(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.recursiveDelete(fileArray[i]);
            }
        }
        return file.delete();
    }

    static void stripManifest(Manifest manifest) {
        Map<String, Attributes> map = manifest.getEntries();
        if (map != null) {
            Iterator<Map.Entry<String, Attributes>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                String string;
                Iterator iterator2;
                Map.Entry<String, Attributes> entry = iterator.next();
                Map.Entry<String, Attributes> entry2 = entry;
                Attributes attributes = entry2.getValue();
                if (attributes == null) continue;
                Set<Object> set = attributes.keySet();
                Iterator<Object> iterator3 = set.iterator();
                HashSet<String> hashSet = new HashSet<String>();
                while (iterator3.hasNext()) {
                    iterator2 = iterator3.next();
                    string = iterator2.toString();
                    if (!string.endsWith("-Digest")) continue;
                    hashSet.add(string);
                }
                iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    string = (String)iterator2.next();
                    Attributes.Name name = new Attributes.Name(string);
                    attributes.remove(name);
                }
            }
        }
    }

    private String[] executeCommandAndWait(String[] stringArray) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(stringArray);
        StreamCapture streamCapture = new StreamCapture(process.getInputStream());
        streamCapture.start();
        StreamCapture streamCapture2 = new StreamCapture(process.getErrorStream());
        streamCapture2.start();
        boolean bl = false;
        do {
            try {
                int n = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        } while (bl);
        String string = streamCapture.getCapture().toString();
        String string2 = streamCapture2.getCapture().toString();
        return new String[]{string, string2};
    }

    static class StreamCapture
    extends Thread {
        InputStream stream;
        StringBuffer capture = new StringBuffer();
        static final String newline = System.getProperty("line.separator");

        public StreamCapture(InputStream inputStream) {
            this.stream = inputStream;
        }

        public void run() {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.stream));
            String string = null;
            boolean bl = false;
            do {
                try {
                    string = bufferedReader.readLine();
                    if (string == null) continue;
                    this.capture.append(string);
                    this.capture.append(newline);
                }
                catch (IOException iOException) {
                    this.capture.append("IO Exception in stream reader:");
                    this.capture.append(newline);
                    this.capture.append(iOException.getMessage());
                    this.capture.append(newline);
                    if (bl) break;
                    bl = true;
                }
            } while (string != null);
        }

        public StringBuffer getCapture() {
            return this.capture;
        }
    }

    public static class StaticProbeInstrumenterException
    extends Exception {
        public StaticProbeInstrumenterException(String string) {
            super(string);
        }
    }

    static class ProbeInstrumenterInner {
        ProbeInstrumenterInner() {
        }

        static String getExeName() throws StaticProbeInstrumenterException {
            Path path;
            Plugin plugin;
            URL uRL;
            String string = "$os$/probeinstrumenter";
            if (BootLoader.getOS().equals("win32")) {
                string = string + ".exe";
            }
            if ((uRL = (plugin = Platform.getPlugin((String)ProbeInstrumenter.COMPILER_PLUGIN_NAME)).find((IPath)(path = new Path(string)), null)) == null) {
                throw new StaticProbeInstrumenterException("Native executable for instrumentation not found (tried " + string + " relative to " + plugin.getDescriptor().getUniqueIdentifier());
            }
            String string2 = uRL.getFile();
            if (!new File(string2).exists()) {
                throw new StaticProbeInstrumenterException("Native executable for instrumentation not found (tried " + string2 + ")");
            }
            return string2;
        }
    }
}

